/*
 * Decompiled with CFR 0.152.
 */
package com.webcohesion.enunciate.modules.jackson1.model;

import com.webcohesion.enunciate.EnunciateException;
import com.webcohesion.enunciate.modules.jackson1.EnunciateJackson1Context;
import com.webcohesion.enunciate.modules.jackson1.model.EnumValue;
import com.webcohesion.enunciate.modules.jackson1.model.SimpleTypeDefinition;
import com.webcohesion.enunciate.modules.jackson1.model.types.JsonType;
import com.webcohesion.enunciate.modules.jackson1.model.types.KnownJsonType;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.xml.bind.annotation.XmlEnumValue;
import org.codehaus.jackson.annotate.JsonValue;

public class EnumTypeDefinition
extends SimpleTypeDefinition {
    private List<EnumValue> enumValues;
    private KnownJsonType baseType;

    public EnumTypeDefinition(TypeElement delegate, EnunciateJackson1Context context) {
        super(delegate, context);
        this.baseType = this.loadBaseType(delegate);
    }

    protected KnownJsonType loadBaseType(TypeElement delegate) {
        KnownJsonType baseType = KnownJsonType.STRING;
        for (ExecutableElement method : ElementFilter.methodsIn(delegate.getEnclosedElements())) {
            JsonValue jsonValue = method.getAnnotation(JsonValue.class);
            if (jsonValue == null || !jsonValue.value()) continue;
            TypeMirror returnType = method.getReturnType();
            switch (returnType.getKind()) {
                case BOOLEAN: {
                    baseType = KnownJsonType.BOOLEAN;
                    break;
                }
                case FLOAT: 
                case DOUBLE: {
                    baseType = KnownJsonType.NUMBER;
                    break;
                }
                case INT: 
                case LONG: 
                case SHORT: 
                case BYTE: {
                    baseType = KnownJsonType.WHOLE_NUMBER;
                }
            }
            break;
        }
        return baseType;
    }

    protected List<EnumValue> loadEnumValues() {
        List enumConstants = this.enumValues();
        ArrayList<EnumValue> enumValueMap = new ArrayList<EnumValue>();
        HashSet<String> enumValues = new HashSet<String>(enumConstants.size());
        for (VariableElement enumConstant : enumConstants) {
            XmlEnumValue enumValue;
            String value = enumConstant.getSimpleName().toString();
            if (this.context.isHonorJaxb() && (enumValue = enumConstant.getAnnotation(XmlEnumValue.class)) != null) {
                value = enumValue.value();
            }
            if (!enumValues.add(value)) {
                throw new EnunciateException(this.getQualifiedName() + ": duplicate enum value: " + value);
            }
            enumValueMap.add(new EnumValue(this, enumConstant, enumConstant.getSimpleName().toString(), value));
        }
        return enumValueMap;
    }

    @Override
    public JsonType getBaseType() {
        return this.baseType;
    }

    public List<EnumValue> getEnumValues() {
        if (this.enumValues == null) {
            this.enumValues = this.loadEnumValues();
        }
        return this.enumValues;
    }

    @Override
    public boolean isSimple() {
        return false;
    }

    @Override
    public boolean isEnum() {
        return true;
    }
}

