/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.util;

import java.nio.ByteBuffer;
import java.util.UUID;
import org.checkerframework.checker.nullness.qual.NonNull;

public class UUIDUtil {
    private UUIDUtil() {
    }

    public static @NonNull UUID fromString(@NonNull String value) {
        return UUID.fromString(value);
    }

    public static @NonNull byte[] convertUUIDToBytes(@NonNull UUID uuid) {
        long hi = uuid.getMostSignificantBits();
        long lo = uuid.getLeastSignificantBits();
        return ByteBuffer.allocate(16).putLong(hi).putLong(lo).array();
    }

    public static @NonNull UUID fromBytes(@NonNull byte[] bytes) {
        ByteBuffer bb = ByteBuffer.wrap(bytes);
        long hi = bb.getLong();
        long lo = bb.getLong();
        return new UUID(hi, lo);
    }
}

