/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.frontend;

import com.vaadin.flow.internal.FileIOUtils;
import com.vaadin.flow.server.frontend.AbstractFileGeneratorFallibleCommand;
import com.vaadin.flow.server.frontend.Options;
import com.vaadin.flow.server.frontend.TaskCopyFrontendFiles;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskCopyLocalFrontendFiles
extends AbstractFileGeneratorFallibleCommand {
    private final Options options;

    TaskCopyLocalFrontendFiles(Options options) {
        this.options = options;
    }

    private static boolean shouldApplyWriteableFlag() {
        return !Boolean.parseBoolean(System.getProperty("vaadin.frontend.disableWritableFlagCheckOnCopy", "false"));
    }

    @Override
    public void execute() {
        File target = this.options.getJarFrontendResourcesFolder();
        File localResourcesFolder = this.options.getLocalResourcesFolder();
        TaskCopyLocalFrontendFiles.createTargetFolder(target);
        if (localResourcesFolder != null && localResourcesFolder.isDirectory()) {
            TaskCopyLocalFrontendFiles.log().info("Copying project local frontend resources.");
            Set<String> files = TaskCopyLocalFrontendFiles.copyLocalResources(localResourcesFolder, target, new String[0]);
            this.track(files.stream().map(path -> target.toPath().resolve((String)path).toFile()).toList());
            TaskCopyLocalFrontendFiles.log().info("Copying frontend directory completed.");
        } else {
            TaskCopyLocalFrontendFiles.log().debug("Found no local frontend resources for the project");
        }
    }

    static Set<String> copyLocalResources(File source, File target, String ... relativePathExclusions) {
        if (!source.isDirectory() || !target.isDirectory()) {
            return Collections.emptySet();
        }
        try {
            long start = System.nanoTime();
            HashSet<String> handledFiles = new HashSet<String>(TaskCopyFrontendFiles.getFilesInDirectory(source, relativePathExclusions));
            FileIOUtils.copyDirectory(source, target, TaskCopyLocalFrontendFiles.withoutExclusions(source, relativePathExclusions));
            if (TaskCopyLocalFrontendFiles.shouldApplyWriteableFlag()) {
                try (Stream<Path> fileStream = Files.walk(Paths.get(target.getPath(), new String[0]), new FileVisitOption[0]);){
                    fileStream.filter(file -> !Files.isWritable(file)).forEach(filePath -> filePath.toFile().setWritable(true));
                }
            }
            long ms = (System.nanoTime() - start) / 1000000L;
            TaskCopyLocalFrontendFiles.log().info("Copied {} local frontend files. Took {} ms.", (Object)handledFiles.size(), (Object)ms);
            return handledFiles;
        }
        catch (IOException e) {
            throw new UncheckedIOException(String.format("Failed to copy project frontend resources from '%s' to '%s'", source, target), e);
        }
    }

    static void createTargetFolder(File target) {
        try {
            Files.createDirectories(Objects.requireNonNull(target).toPath(), new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new UncheckedIOException(String.format("Failed to create directory '%s'", target), e);
        }
    }

    static boolean keepFile(File source, String[] relativePathExclusions, File fileToCheck) {
        for (String exclusion : relativePathExclusions) {
            File basePath = new File(source, exclusion);
            if (!fileToCheck.getPath().startsWith(basePath.getPath())) continue;
            return false;
        }
        return true;
    }

    private static FileFilter withoutExclusions(File source, String[] relativePathExclusions) {
        return file -> TaskCopyLocalFrontendFiles.keepFile(source, relativePathExclusions, file);
    }

    private static Logger log() {
        return LoggerFactory.getLogger(TaskCopyLocalFrontendFiles.class);
    }
}

