/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.archunit.junit.engine_api;

import com.tngtech.archunit.Internal;
import com.tngtech.archunit.PublicAPI;
import java.lang.reflect.Field;
import java.util.Objects;
import org.junit.platform.engine.TestSource;

@PublicAPI(usage=PublicAPI.Usage.ACCESS)
public final class FieldSource
implements TestSource {
    private final Class<?> javaClass;
    private final String fieldName;

    private FieldSource(Field field) {
        this.javaClass = field.getDeclaringClass();
        this.fieldName = field.getName();
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public String getClassName() {
        return this.javaClass.getName();
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public Class<?> getJavaClass() {
        return this.javaClass;
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public String getFieldName() {
        return this.fieldName;
    }

    public int hashCode() {
        return Objects.hash(this.javaClass, this.fieldName);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        FieldSource other = (FieldSource)obj;
        return Objects.equals(this.javaClass, other.javaClass) && Objects.equals(this.fieldName, other.fieldName);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{" + this.getClassName() + '.' + this.fieldName + '}';
    }

    @Internal
    public static FieldSource from(Field field) {
        return new FieldSource(field);
    }
}

