/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.model.wsdl;

import com.sun.istack.NotNull;
import com.sun.istack.Nullable;
import com.sun.xml.ws.api.model.ParameterBinding;
import com.sun.xml.ws.api.model.wsdl.WSDLBoundOperation;
import com.sun.xml.ws.api.model.wsdl.WSDLBoundPortType;
import com.sun.xml.ws.api.model.wsdl.WSDLPart;
import com.sun.xml.ws.model.wsdl.AbstractExtensibleImpl;
import com.sun.xml.ws.model.wsdl.WSDLBoundFaultImpl;
import com.sun.xml.ws.model.wsdl.WSDLBoundPortTypeImpl;
import com.sun.xml.ws.model.wsdl.WSDLMessageImpl;
import com.sun.xml.ws.model.wsdl.WSDLModelImpl;
import com.sun.xml.ws.model.wsdl.WSDLOperationImpl;
import com.sun.xml.ws.model.wsdl.WSDLPartImpl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jws.WebParam;
import javax.jws.soap.SOAPBinding;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamReader;

public final class WSDLBoundOperationImpl
extends AbstractExtensibleImpl
implements WSDLBoundOperation {
    private final QName name;
    private final Map<String, ParameterBinding> inputParts;
    private final Map<String, ParameterBinding> outputParts;
    private final Map<String, ParameterBinding> faultParts;
    private final Map<String, String> inputMimeTypes;
    private final Map<String, String> outputMimeTypes;
    private final Map<String, String> faultMimeTypes;
    private boolean explicitInputSOAPBodyParts = false;
    private boolean explicitOutputSOAPBodyParts = false;
    private boolean explicitFaultSOAPBodyParts = false;
    private Boolean emptyInputBody;
    private Boolean emptyOutputBody;
    private Boolean emptyFaultBody;
    private final Map<String, WSDLPartImpl> inParts;
    private final Map<String, WSDLPartImpl> outParts;
    private final List<WSDLBoundFaultImpl> wsdlBoundFaults;
    private WSDLOperationImpl operation;
    private String soapAction;
    private WSDLBoundOperation.ANONYMOUS anonymous;
    private final WSDLBoundPortTypeImpl owner;
    private SOAPBinding.Style style = SOAPBinding.Style.DOCUMENT;
    private String reqNamespace;
    private String respNamespace;
    private QName requestPayloadName;
    private QName responsePayloadName;
    private boolean emptyRequestPayload;
    private boolean emptyResponsePayload;
    private Map<QName, WSDLMessageImpl> messages;

    public WSDLBoundOperationImpl(XMLStreamReader xsr, WSDLBoundPortTypeImpl owner, QName name) {
        super(xsr);
        this.name = name;
        this.inputParts = new HashMap<String, ParameterBinding>();
        this.outputParts = new HashMap<String, ParameterBinding>();
        this.faultParts = new HashMap<String, ParameterBinding>();
        this.inputMimeTypes = new HashMap<String, String>();
        this.outputMimeTypes = new HashMap<String, String>();
        this.faultMimeTypes = new HashMap<String, String>();
        this.inParts = new HashMap<String, WSDLPartImpl>();
        this.outParts = new HashMap<String, WSDLPartImpl>();
        this.wsdlBoundFaults = new ArrayList<WSDLBoundFaultImpl>();
        this.owner = owner;
    }

    @Override
    public QName getName() {
        return this.name;
    }

    @Override
    public String getSOAPAction() {
        return this.soapAction;
    }

    public void setSoapAction(String soapAction) {
        this.soapAction = soapAction != null ? soapAction : "";
    }

    @Override
    public WSDLPartImpl getPart(String partName, WebParam.Mode mode) {
        if (mode == WebParam.Mode.IN) {
            return this.inParts.get(partName);
        }
        if (mode == WebParam.Mode.OUT) {
            return this.outParts.get(partName);
        }
        return null;
    }

    public void addPart(WSDLPartImpl part, WebParam.Mode mode) {
        if (mode == WebParam.Mode.IN) {
            this.inParts.put(part.getName(), part);
        } else if (mode == WebParam.Mode.OUT) {
            this.outParts.put(part.getName(), part);
        }
    }

    public Map<String, ParameterBinding> getInputParts() {
        return this.inputParts;
    }

    public Map<String, ParameterBinding> getOutputParts() {
        return this.outputParts;
    }

    public Map<String, ParameterBinding> getFaultParts() {
        return this.faultParts;
    }

    @Override
    public Map<String, WSDLPart> getInParts() {
        return Collections.unmodifiableMap(this.inParts);
    }

    @Override
    public Map<String, WSDLPart> getOutParts() {
        return Collections.unmodifiableMap(this.outParts);
    }

    @NotNull
    public List<WSDLBoundFaultImpl> getFaults() {
        return this.wsdlBoundFaults;
    }

    public void addFault(@NotNull WSDLBoundFaultImpl fault) {
        this.wsdlBoundFaults.add(fault);
    }

    public Map<String, String> getInputMimeTypes() {
        return this.inputMimeTypes;
    }

    public Map<String, String> getOutputMimeTypes() {
        return this.outputMimeTypes;
    }

    public Map<String, String> getFaultMimeTypes() {
        return this.faultMimeTypes;
    }

    public ParameterBinding getInputBinding(String part) {
        ParameterBinding block;
        if (this.emptyInputBody == null) {
            this.emptyInputBody = this.inputParts.get(" ") != null ? Boolean.valueOf(true) : Boolean.valueOf(false);
        }
        if ((block = this.inputParts.get(part)) == null) {
            if (this.explicitInputSOAPBodyParts || this.emptyInputBody.booleanValue()) {
                return ParameterBinding.UNBOUND;
            }
            return ParameterBinding.BODY;
        }
        return block;
    }

    public ParameterBinding getOutputBinding(String part) {
        ParameterBinding block;
        if (this.emptyOutputBody == null) {
            this.emptyOutputBody = this.outputParts.get(" ") != null ? Boolean.valueOf(true) : Boolean.valueOf(false);
        }
        if ((block = this.outputParts.get(part)) == null) {
            if (this.explicitOutputSOAPBodyParts || this.emptyOutputBody.booleanValue()) {
                return ParameterBinding.UNBOUND;
            }
            return ParameterBinding.BODY;
        }
        return block;
    }

    public ParameterBinding getFaultBinding(String part) {
        ParameterBinding block;
        if (this.emptyFaultBody == null) {
            this.emptyFaultBody = this.faultParts.get(" ") != null ? Boolean.valueOf(true) : Boolean.valueOf(false);
        }
        if ((block = this.faultParts.get(part)) == null) {
            if (this.explicitFaultSOAPBodyParts || this.emptyFaultBody.booleanValue()) {
                return ParameterBinding.UNBOUND;
            }
            return ParameterBinding.BODY;
        }
        return block;
    }

    public String getMimeTypeForInputPart(String part) {
        return this.inputMimeTypes.get(part);
    }

    public String getMimeTypeForOutputPart(String part) {
        return this.outputMimeTypes.get(part);
    }

    public String getMimeTypeForFaultPart(String part) {
        return this.faultMimeTypes.get(part);
    }

    @Override
    public WSDLOperationImpl getOperation() {
        return this.operation;
    }

    @Override
    public WSDLBoundPortType getBoundPortType() {
        return this.owner;
    }

    public void setInputExplicitBodyParts(boolean b) {
        this.explicitInputSOAPBodyParts = b;
    }

    public void setOutputExplicitBodyParts(boolean b) {
        this.explicitOutputSOAPBodyParts = b;
    }

    public void setFaultExplicitBodyParts(boolean b) {
        this.explicitFaultSOAPBodyParts = b;
    }

    public void setStyle(SOAPBinding.Style style) {
        this.style = style;
    }

    @Override
    @Nullable
    public QName getReqPayloadName() {
        if (this.emptyRequestPayload) {
            return null;
        }
        if (this.requestPayloadName != null) {
            return this.requestPayloadName;
        }
        if (this.style.equals((Object)SOAPBinding.Style.RPC)) {
            String ns = this.getRequestNamespace() != null ? this.getRequestNamespace() : this.name.getNamespaceURI();
            this.requestPayloadName = new QName(ns, this.name.getLocalPart());
            return this.requestPayloadName;
        }
        QName inMsgName = this.operation.getInput().getMessage().getName();
        WSDLMessageImpl message = this.messages.get(inMsgName);
        for (WSDLPartImpl part : message.parts()) {
            ParameterBinding binding = this.getInputBinding(part.getName());
            if (!binding.isBody()) continue;
            this.requestPayloadName = part.getDescriptor().name();
            return this.requestPayloadName;
        }
        this.emptyRequestPayload = true;
        return null;
    }

    @Override
    @Nullable
    public QName getResPayloadName() {
        if (this.emptyResponsePayload) {
            return null;
        }
        if (this.responsePayloadName != null) {
            return this.responsePayloadName;
        }
        if (this.style.equals((Object)SOAPBinding.Style.RPC)) {
            String ns = this.getResponseNamespace() != null ? this.getResponseNamespace() : this.name.getNamespaceURI();
            this.responsePayloadName = new QName(ns, this.name.getLocalPart() + "Response");
            return this.responsePayloadName;
        }
        QName outMsgName = this.operation.getOutput().getMessage().getName();
        WSDLMessageImpl message = this.messages.get(outMsgName);
        for (WSDLPartImpl part : message.parts()) {
            ParameterBinding binding = this.getOutputBinding(part.getName());
            if (!binding.isBody()) continue;
            this.responsePayloadName = part.getDescriptor().name();
            return this.responsePayloadName;
        }
        this.emptyResponsePayload = true;
        return null;
    }

    @Override
    public String getRequestNamespace() {
        return this.reqNamespace != null ? this.reqNamespace : this.name.getNamespaceURI();
    }

    public void setRequestNamespace(String ns) {
        this.reqNamespace = ns;
    }

    @Override
    public String getResponseNamespace() {
        return this.respNamespace != null ? this.respNamespace : this.name.getNamespaceURI();
    }

    public void setResponseNamespace(String ns) {
        this.respNamespace = ns;
    }

    WSDLBoundPortTypeImpl getOwner() {
        return this.owner;
    }

    void freeze(WSDLModelImpl parent) {
        this.messages = parent.getMessages();
        this.operation = this.owner.getPortType().get(this.name.getLocalPart());
        for (WSDLBoundFaultImpl bf : this.wsdlBoundFaults) {
            bf.freeze(this);
        }
    }

    public void setAnonymous(WSDLBoundOperation.ANONYMOUS anonymous) {
        this.anonymous = anonymous;
    }

    @Override
    public WSDLBoundOperation.ANONYMOUS getAnonymous() {
        return this.anonymous;
    }
}

