/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.queries;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.exceptions.QueryException;
import org.eclipse.persistence.internal.databaseaccess.DatabaseCall;
import org.eclipse.persistence.internal.helper.InvalidObject;
import org.eclipse.persistence.internal.queries.JoinedAttributeManager;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.queries.Cursor;
import org.eclipse.persistence.queries.ObjectLevelReadQuery;
import org.eclipse.persistence.queries.ScrollableCursorPolicy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScrollableCursor
extends Cursor
implements ListIterator {
    protected transient Object nextObject;
    protected transient Object previousObject;
    protected AbstractRecord previousRow;
    protected boolean atEndOfCursor = false;

    public ScrollableCursor() {
    }

    public ScrollableCursor(DatabaseCall call, ScrollableCursorPolicy policy) {
        super(call, policy);
        this.setPosition(-1);
    }

    public boolean absolute(int rows) throws DatabaseException {
        int initiallyConforming;
        boolean suceeded;
        block7: {
            this.clearNextAndPrevious();
            try {
                suceeded = false;
                initiallyConforming = this.objectCollection.size();
                if (rows < 0 || rows > initiallyConforming) break block7;
                this.resultSet.beforeFirst();
                this.setPosition(rows);
                return true;
            }
            catch (SQLException exception) {
                DatabaseException commException = this.getAccessor().processExceptionForCommError(this.session, exception, null);
                if (commException != null) {
                    throw commException;
                }
                throw DatabaseException.sqlException(exception, this.getAccessor(), this.session, false);
            }
        }
        if (rows > initiallyConforming) {
            suceeded = this.resultSet.absolute(rows - initiallyConforming);
            if (suceeded) {
                this.setPosition(initiallyConforming + rows);
            } else {
                this.setPosition(this.size() + 1);
            }
            return suceeded;
        }
        return this.absolute(this.size() + rows);
    }

    public void add(Object object) throws QueryException {
        QueryException.invalidOperation("add");
    }

    public void afterLast() throws DatabaseException {
        this.clearNextAndPrevious();
        try {
            this.resultSet.afterLast();
            this.setPosition(this.size() + 1);
        }
        catch (SQLException exception) {
            DatabaseException commException = this.getAccessor().processExceptionForCommError(this.session, exception, null);
            if (commException != null) {
                throw commException;
            }
            throw DatabaseException.sqlException(exception, this.getAccessor(), this.session, false);
        }
    }

    public void beforeFirst() throws DatabaseException {
        this.clearNextAndPrevious();
        try {
            this.resultSet.beforeFirst();
            this.setPosition(0);
        }
        catch (SQLException exception) {
            DatabaseException commException = this.getAccessor().processExceptionForCommError(this.session, exception, null);
            if (commException != null) {
                throw commException;
            }
            throw DatabaseException.sqlException(exception, this.getAccessor(), this.session, false);
        }
    }

    protected void clearNextAndPrevious() {
        this.nextObject = null;
        this.previousObject = null;
        this.nextRow = null;
        this.previousRow = null;
        this.atEndOfCursor = false;
    }

    protected void clearNextAndPreviousObject() {
        this.nextObject = null;
        this.previousObject = null;
    }

    public int currentIndex() throws DatabaseException {
        return this.getPosition();
    }

    public boolean first() throws DatabaseException {
        block4: {
            this.clearNextAndPrevious();
            try {
                if (this.objectCollection.size() <= 0) break block4;
                this.setPosition(1);
                this.resultSet.beforeFirst();
                return true;
            }
            catch (SQLException exception) {
                DatabaseException commException = this.getAccessor().processExceptionForCommError(this.session, exception, null);
                if (commException != null) {
                    throw commException;
                }
                throw DatabaseException.sqlException(exception, this.getAccessor(), this.session, false);
            }
        }
        return this.resultSet.first();
    }

    @Override
    protected int getCursorSize() throws DatabaseException {
        if (this.getKnownCursorSize() != -1) {
            return this.getKnownCursorSize();
        }
        int currentPos = 0;
        boolean wasAfterLast = false;
        try {
            wasAfterLast = this.resultSet.isAfterLast();
            currentPos = this.resultSet.getRow();
            this.resultSet.last();
        }
        catch (SQLException exception) {
            DatabaseException commException = this.getAccessor().processExceptionForCommError(this.session, exception, null);
            if (commException != null) {
                throw commException;
            }
            throw DatabaseException.sqlException(exception, this.getAccessor(), this.session, false);
        }
        int size = 0;
        try {
            size = this.resultSet.getRow();
            if (wasAfterLast) {
                this.resultSet.afterLast();
            } else if (currentPos == 0) {
                this.resultSet.beforeFirst();
            } else {
                this.resultSet.absolute(currentPos);
            }
        }
        catch (SQLException exception) {
            DatabaseException commException = this.getAccessor().processExceptionForCommError(this.session, exception, null);
            if (commException != null) {
                throw commException;
            }
            throw DatabaseException.sqlException(exception, this.getAccessor(), this.session, false);
        }
        return size;
    }

    protected int getKnownCursorSize() {
        if (this.size == -1) {
            return this.size;
        }
        return this.size - this.objectCollection.size();
    }

    protected Object getNextObject() {
        return this.nextObject;
    }

    @Override
    public int getPosition() throws DatabaseException {
        try {
            if (this.position == -1) {
                this.position = this.resultSet.getRow();
                if (this.position == 0) {
                    if (this.isAfterLast()) {
                        this.position = this.size() + 1;
                    }
                } else {
                    this.position += this.objectCollection.size();
                }
            }
            return this.position;
        }
        catch (SQLException exception) {
            DatabaseException commException = this.getAccessor().processExceptionForCommError(this.session, exception, null);
            if (commException != null) {
                throw commException;
            }
            throw DatabaseException.sqlException(exception, this.getAccessor(), this.session, false);
        }
    }

    protected Object getPreviousObject() {
        return this.previousObject;
    }

    @Override
    public boolean hasMoreElements() throws DatabaseException {
        return this.hasNext();
    }

    @Override
    public boolean hasNext() throws DatabaseException {
        if (this.isClosed()) {
            return false;
        }
        this.loadNext();
        return this.nextObject != null;
    }

    public boolean hasNextElement() throws DatabaseException {
        return this.hasNext();
    }

    @Override
    public boolean hasPrevious() throws DatabaseException {
        if (this.isClosed()) {
            return false;
        }
        this.loadPrevious();
        return this.getPreviousObject() != null;
    }

    public boolean isAfterLast() throws DatabaseException {
        block6: {
            block5: {
                try {
                    if (this.nextObject == null) break block5;
                    return false;
                }
                catch (SQLException exception) {
                    DatabaseException commException = this.getAccessor().processExceptionForCommError(this.session, exception, null);
                    if (commException != null) {
                        throw commException;
                    }
                    throw DatabaseException.sqlException(exception, this.getAccessor(), this.session, false);
                }
            }
            if (this.objectCollection.size() <= 0 || this.getPosition() > this.objectCollection.size()) break block6;
            return false;
        }
        return this.resultSet.isAfterLast();
    }

    public boolean isBeforeFirst() throws DatabaseException {
        if (this.getPreviousObject() != null) {
            return false;
        }
        return this.getPosition() == 0;
    }

    public boolean isFirst() throws DatabaseException {
        if (this.getPreviousObject() != null) {
            return false;
        }
        try {
            if (this.objectCollection.size() > 0) {
                return this.getPosition() == 1;
            }
            return this.resultSet.isFirst();
        }
        catch (SQLException exception) {
            DatabaseException commException = this.getAccessor().processExceptionForCommError(this.session, exception, null);
            if (commException != null) {
                throw commException;
            }
            throw DatabaseException.sqlException(exception, this.getAccessor(), this.session, false);
        }
    }

    public boolean isLast() throws DatabaseException {
        if (this.nextObject != null) {
            return false;
        }
        try {
            return this.resultSet.isLast();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            try {
                return this.resultSet.getRow() == this.getCursorSize();
            }
            catch (SQLException ex2) {
                DatabaseException commException = this.getAccessor().processExceptionForCommError(this.session, ex2, null);
                if (commException != null) {
                    throw commException;
                }
                throw DatabaseException.sqlException(ex2, this.getAccessor(), this.session, false);
            }
        }
        catch (SQLException exception) {
            DatabaseException commException = this.getAccessor().processExceptionForCommError(this.session, exception, null);
            if (commException != null) {
                throw commException;
            }
            throw DatabaseException.sqlException(exception, this.getAccessor(), this.session, false);
        }
    }

    public boolean last() throws DatabaseException {
        this.clearNextAndPrevious();
        try {
            boolean isLast = this.resultSet.last();
            if (!isLast) {
                if (this.objectCollection.size() > 0) {
                    this.setPosition(this.objectCollection.size());
                    isLast = true;
                }
            } else {
                this.setSize(this.objectCollection.size() + this.resultSet.getRow());
                this.setPosition(this.size);
            }
            return isLast;
        }
        catch (SQLException exception) {
            DatabaseException commException = this.getAccessor().processExceptionForCommError(this.session, exception, null);
            if (commException != null) {
                throw commException;
            }
            throw DatabaseException.sqlException(exception, this.getAccessor(), this.session, false);
        }
    }

    protected void loadNext() {
        if (this.nextObject == null) {
            Object next;
            this.nextObject = next = this.retrieveNextObject();
        }
    }

    protected void loadPrevious() {
        if (this.previousObject == null) {
            this.previousObject = this.retrievePreviousObject();
        }
    }

    @Override
    public Object next() throws DatabaseException, QueryException {
        this.loadNext();
        if (this.nextObject == null) {
            throw QueryException.readBeyondStream(this.query);
        }
        Object next = this.nextObject;
        this.clearNextAndPreviousObject();
        return next;
    }

    public List<Object> next(int number) throws DatabaseException {
        ArrayList<Object> result = new ArrayList<Object>(number);
        int index = 0;
        while (index < number) {
            result.add(this.next());
            ++index;
        }
        return result;
    }

    public Object nextElement() throws DatabaseException, QueryException {
        return this.next();
    }

    @Override
    public int nextIndex() throws DatabaseException {
        return this.currentIndex() + 1;
    }

    public Object previous() throws DatabaseException, QueryException {
        this.loadPrevious();
        if (this.previousObject == null) {
            throw QueryException.readBeyondStream(this.query);
        }
        Object previous = this.previousObject;
        this.clearNextAndPreviousObject();
        return previous;
    }

    @Override
    public int previousIndex() throws DatabaseException {
        return this.currentIndex() - 1;
    }

    public boolean relative(int rows) throws DatabaseException {
        this.clearNextAndPrevious();
        try {
            boolean suceeded = false;
            int oldPosition = this.getPosition();
            int newPosition = this.getPosition() + rows;
            int initiallyConforming = this.objectCollection.size();
            if (newPosition <= initiallyConforming) {
                this.setPosition(newPosition);
                if (oldPosition > initiallyConforming) {
                    this.resultSet.beforeFirst();
                }
                if (newPosition < 0) {
                    this.setPosition(0);
                }
                suceeded = newPosition > 0;
            } else {
                suceeded = this.resultSet.relative(rows);
                if (!suceeded) {
                    this.setPosition(this.size() + 1);
                } else {
                    this.setPosition(newPosition);
                }
            }
            return suceeded;
        }
        catch (SQLException exception) {
            DatabaseException commException = this.getAccessor().processExceptionForCommError(this.session, exception, null);
            if (commException != null) {
                throw commException;
            }
            throw DatabaseException.sqlException(exception, this.getAccessor(), this.session, false);
        }
    }

    @Override
    protected Object retrieveNextObject() throws DatabaseException {
        AbstractRecord row;
        Object object;
        do {
            JoinedAttributeManager joinManager;
            int currentPosition;
            if ((currentPosition = this.getPosition()) < this.objectCollection.size()) {
                this.position = currentPosition + 1;
                return this.objectCollection.get(currentPosition);
            }
            if (this.isClosed()) {
                return null;
            }
            row = null;
            if (!this.atEndOfCursor) {
                if (this.nextRow == null) {
                    row = this.getAccessor().cursorRetrieveNextRow(this.fields, this.resultSet, this.executionSession);
                } else {
                    row = this.nextRow;
                    this.nextRow = null;
                }
            }
            this.position = currentPosition + 1;
            if (row == null) {
                this.atEndOfCursor = true;
                return null;
            }
            if (!this.query.isObjectLevelReadQuery() || !((ObjectLevelReadQuery)this.query).hasJoining() || !(joinManager = ((ObjectLevelReadQuery)this.query).getJoinedAttributeManager()).isToManyJoin()) continue;
            this.nextRow = joinManager.processDataResults(row, this, true);
            if (this.nextRow != null) continue;
            this.atEndOfCursor = true;
        } while ((object = this.buildAndRegisterObject(row)) == InvalidObject.instance);
        return object;
    }

    protected Object retrievePreviousObject() throws DatabaseException {
        AbstractRecord row;
        Object object;
        do {
            JoinedAttributeManager joinManager;
            int currentPosition;
            if ((currentPosition = this.getPosition()) <= this.objectCollection.size() + 1) {
                if (currentPosition == this.objectCollection.size() + 1 && !this.isClosed()) {
                    this.getAccessor().cursorRetrievePreviousRow(this.fields, this.resultSet, this.executionSession);
                }
                if (currentPosition <= 1) {
                    this.position = 0;
                    return null;
                }
                this.position = currentPosition - 1;
                return this.objectCollection.get(this.position - 1);
            }
            if (this.isClosed()) {
                return null;
            }
            row = null;
            if (this.previousRow == null) {
                row = this.getAccessor().cursorRetrievePreviousRow(this.fields, this.resultSet, this.executionSession);
            } else {
                row = this.previousRow;
                this.previousRow = null;
            }
            this.position = currentPosition - 1;
            if (row == null) {
                return null;
            }
            if (!this.query.isObjectLevelReadQuery() || !((ObjectLevelReadQuery)this.query).hasJoining() || !(joinManager = ((ObjectLevelReadQuery)this.query).getJoinedAttributeManager()).isToManyJoin()) continue;
            this.previousRow = joinManager.processDataResults(row, this, false);
        } while ((object = this.buildAndRegisterObject(row)) == InvalidObject.instance);
        return object;
    }

    public void set(Object object) throws QueryException {
        QueryException.invalidOperation("set");
    }

    protected void setNextObject(Object nextObject) {
        this.nextObject = nextObject;
    }

    protected void setPreviousObject(Object previousObject) {
        this.previousObject = previousObject;
    }
}

