/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.queries;

import org.eclipse.persistence.internal.jpa.parsing.JPQLParseTree;
import org.eclipse.persistence.internal.jpa.parsing.jpql.JPQLParser;
import org.eclipse.persistence.internal.jpa.parsing.jpql.JPQLParserFactory;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.JPAQueryBuilder;
import org.eclipse.persistence.queries.ObjectLevelReadQuery;

public final class ANTLRQueryBuilder
implements JPAQueryBuilder {
    public DatabaseQuery buildQuery(String jpqlQuery, AbstractSession session) {
        JPQLParseTree parseTree = this.buildParseTree(jpqlQuery, session);
        DatabaseQuery databaseQuery = parseTree.createDatabaseQuery();
        databaseQuery.setJPQLString(jpqlQuery);
        this.populateQueryInternal(jpqlQuery, session, parseTree, databaseQuery);
        return databaseQuery;
    }

    public void populateQuery(String jpqlQuery, DatabaseQuery query, AbstractSession session) {
        new JPQLParserFactory().populateQuery(jpqlQuery, (ObjectLevelReadQuery)query, session);
    }

    private JPQLParseTree buildParseTree(String jpqlQuery, AbstractSession session) {
        JPQLParseTree parseTree = JPQLParser.buildParseTree(jpqlQuery);
        parseTree.setClassLoader(session.getDatasourcePlatform().getConversionManager().getLoader());
        return parseTree;
    }

    private void populateQueryInternal(String jpqlQuery, AbstractSession session, JPQLParseTree parseTree, DatabaseQuery databaseQuery) {
        parseTree.populateQuery(databaseQuery, session);
        parseTree.addParametersToQuery(databaseQuery);
    }
}

