/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.oxm.record;

import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.xml.namespace.QName;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.exceptions.XMLMarshalException;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.oxm.UnmarshalXPathEngine;
import org.eclipse.persistence.internal.oxm.XMLConversionManager;
import org.eclipse.persistence.internal.oxm.XPathEngine;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.oxm.NamespaceResolver;
import org.eclipse.persistence.oxm.XMLField;
import org.eclipse.persistence.oxm.mappings.nullpolicy.AbstractNullPolicy;
import org.eclipse.persistence.oxm.record.XMLEntry;
import org.eclipse.persistence.oxm.record.XMLRecord;
import org.eclipse.persistence.platform.xml.XMLNamespaceResolver;
import org.eclipse.persistence.platform.xml.XMLParser;
import org.eclipse.persistence.platform.xml.XMLPlatform;
import org.eclipse.persistence.platform.xml.XMLPlatformFactory;
import org.eclipse.persistence.platform.xml.XMLTransformer;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DOMRecord
extends XMLRecord {
    private Node dom;
    private Node currentNode;
    private XMLField lastUpdatedField;

    public DOMRecord() {
    }

    public DOMRecord(String rootElementName) {
        this(rootElementName, (NamespaceResolver)null);
    }

    public DOMRecord(String rootElementName, NamespaceResolver namespaceResolver) {
        this();
        String rootElementNamespaceURI = this.resolveNamespace(namespaceResolver, rootElementName);
        this.setDOM(this.createNewDocument(rootElementName, rootElementNamespaceURI));
    }

    public DOMRecord(String rootElementName, String rootElementNamespaceURI) {
        this();
        this.setDOM(this.createNewDocument(rootElementName, rootElementNamespaceURI));
    }

    public DOMRecord(String localRootElementName, Node parent) {
        this(localRootElementName, null, parent);
    }

    public DOMRecord(String localRootElementName, NamespaceResolver namespaceResolver, Node parent) {
        this();
        Document document = parent instanceof Document ? (Document)parent : parent.getOwnerDocument();
        String localRootElementNamespaceURI = this.resolveNamespace(namespaceResolver, localRootElementName);
        Element child = document.createElementNS(localRootElementNamespaceURI, localRootElementName);
        parent.appendChild(child);
        this.setDOM(child);
    }

    public DOMRecord(Element element) {
        this();
        this.setDOM(element);
    }

    public DOMRecord(Node node) {
        this();
        this.setDOM(node);
    }

    public DOMRecord(Document document) {
        this();
        this.setDOM(document.getDocumentElement());
    }

    @Override
    public String getLocalName() {
        String localName = this.getDOM().getLocalName();
        if (localName != null) {
            return localName;
        }
        return this.getDOM().getNodeName();
    }

    @Override
    public String getNamespaceURI() {
        return this.getDOM().getNamespaceURI();
    }

    @Override
    public void add(DatabaseField key, Object value) {
        Object nodeValue = this.convertToNodeValue(value);
        XPathEngine.getInstance().create(this.convertToXMLField(key), this.dom, nodeValue, this.session);
    }

    private Object convertToNodeValue(Object value) {
        if (value instanceof List) {
            List values = (List)value;
            Vector<Object> nodeValues = new Vector<Object>(values.size());
            int index = 0;
            while (index < values.size()) {
                Object nestedValue = values.get(index);
                nodeValues.add(this.convertToNodeValue(nestedValue));
                ++index;
            }
            return nodeValues;
        }
        if (value instanceof DOMRecord) {
            return ((DOMRecord)value).getDOM();
        }
        if (value != null && value.getClass() == XMLEntry.class) {
            XMLEntry entry = (XMLEntry)value;
            entry.setValue(this.convertToNodeValue(entry.getValue()));
            return entry;
        }
        return value;
    }

    @Override
    public void clear() {
        if (this.getDOM() instanceof Element) {
            String domName = ((Element)this.getDOM()).getTagName();
            this.currentNode = this.dom = this.createNewDocument(domName, null);
        }
    }

    @Override
    public DOMRecord clone() {
        DOMRecord clone = (DOMRecord)super.clone();
        if (clone != null) {
            clone.setDOM((Element)this.dom.cloneNode(true));
        }
        return clone;
    }

    public Node createNewDocument(String defaultRootElementName) {
        return this.createNewDocument(defaultRootElementName, null);
    }

    public Node createNewDocument(String defaultRootElementName, String namespaceURI) {
        XMLPlatform xmlPlatform = XMLPlatformFactory.getInstance().getXMLPlatform();
        Document document = xmlPlatform.createDocument();
        if (defaultRootElementName == null || defaultRootElementName.length() == 0) {
            DocumentFragment fragment = document.createDocumentFragment();
            return fragment;
        }
        Element rootNode = document.createElementNS(namespaceURI, defaultRootElementName);
        document.appendChild(rootNode);
        return document.getDocumentElement();
    }

    @Override
    public Document getDocument() {
        return this.getDOM().getOwnerDocument();
    }

    @Override
    public boolean containsKey(DatabaseField key) {
        XMLField xmlField = this.convertToXMLField(key);
        NodeList nodeList = UnmarshalXPathEngine.getInstance().selectNodes(this.dom, xmlField, (XMLNamespaceResolver)xmlField.getNamespaceResolver());
        return nodeList.getLength() > 0;
    }

    @Override
    public boolean contains(Object value) {
        return this.values().contains(value);
    }

    @Override
    public Object get(DatabaseField key) {
        Object value = this.getIndicatingNoEntry(key);
        if (value == noEntry) {
            return null;
        }
        return value;
    }

    @Override
    public Object getIndicatingNoEntry(DatabaseField key) {
        return this.getIndicatingNoEntry(key, false, false);
    }

    public Object getIndicatingNoEntry(DatabaseField key, boolean shouldReturnNode) {
        return this.getIndicatingNoEntry(key, shouldReturnNode, false);
    }

    public Object getIndicatingNoEntry(DatabaseField key, boolean shouldReturnNode, boolean checkForXsiNil) {
        XMLField field = this.convertToXMLField(key);
        if (field.isSelfField()) {
            return this;
        }
        Object result = UnmarshalXPathEngine.getInstance().selectSingleNode(this.dom, field, (XMLNamespaceResolver)field.getNamespaceResolver(), checkForXsiNil);
        if (result == noEntry) {
            if (shouldReturnNode) {
                return null;
            }
            return noEntry;
        }
        if (result == NIL) {
            return NIL;
        }
        Node node = (Node)result;
        if (shouldReturnNode) {
            return node;
        }
        if (node == null) {
            return null;
        }
        if (1 != node.getNodeType()) {
            if (node.getNodeType() == 2) {
                this.getValueFromAttribute((Attr)node, field);
            }
            return this.getValueFromElement((Element)node.getParentNode(), node, field);
        }
        return this.buildNestedRow((Element)node);
    }

    @Override
    public Object getValues(String key) {
        Object value = this.getValuesIndicatingNoEntry(new XMLField(key));
        if (value == AbstractRecord.noEntry) {
            return null;
        }
        return value;
    }

    @Override
    public Object getValues(DatabaseField key) {
        return this.getValues(key, null);
    }

    public Object getValues(DatabaseField key, AbstractNullPolicy nullPolicy) {
        Object value = this.getValuesIndicatingNoEntry(key, nullPolicy);
        if (value == AbstractRecord.noEntry) {
            return null;
        }
        return value;
    }

    public Object getValuesIndicatingNoEntry(DatabaseField key) {
        return this.getValuesIndicatingNoEntry(key, null);
    }

    public Object getValuesIndicatingNoEntry(DatabaseField key, AbstractNullPolicy nullPolicy) {
        return this.getValuesIndicatingNoEntry(key, false, nullPolicy);
    }

    public List<XMLEntry> getValuesIndicatingNoEntry(List<DatabaseField> keys) {
        return this.getValuesIndicatingNoEntry(keys, false);
    }

    public List<XMLEntry> getValuesIndicatingNoEntry(List<DatabaseField> keys, boolean shouldReturnNodes) {
        List<XMLField> xmlFields = this.convertToXMLField(keys);
        List<XMLEntry> values = UnmarshalXPathEngine.getInstance().selectNodes(this.dom, xmlFields, (XMLNamespaceResolver)xmlFields.get(0).getNamespaceResolver());
        if (shouldReturnNodes) {
            return values;
        }
        for (XMLEntry next : values) {
            Node nextNode = (Node)next.getValue();
            if (nextNode.getNodeType() != 1) {
                Object value = this.getValueFromElement((Element)nextNode.getParentNode(), nextNode, next.getXMLField());
                next.setValue(value);
                continue;
            }
            next.setValue(this.buildNestedRow((Element)nextNode));
        }
        return values;
    }

    public Object getValuesIndicatingNoEntry(DatabaseField key, boolean shouldReturnNodes) {
        return this.getValuesIndicatingNoEntry(key, shouldReturnNodes, null);
    }

    public Object getValuesIndicatingNoEntry(DatabaseField key, boolean shouldReturnNodes, AbstractNullPolicy nullPolicy) {
        XMLField field = this.convertToXMLField(key);
        NodeList nodeList = UnmarshalXPathEngine.getInstance().selectNodes(this.dom, field, (XMLNamespaceResolver)field.getNamespaceResolver(), nullPolicy);
        if (nodeList == null) {
            return null;
        }
        int resultSize = nodeList.getLength();
        Vector<Object> result = new Vector<Object>(resultSize);
        if (resultSize == 0) {
            return result;
        }
        if (shouldReturnNodes) {
            int i = 0;
            while (i < resultSize) {
                result.add(nodeList.item(i));
                ++i;
            }
            return result;
        }
        Node firstNode = nodeList.item(0);
        if (firstNode == null || firstNode.getNodeType() != 1) {
            if (field.usesSingleNode() && resultSize == 1) {
                Node next = nodeList.item(0);
                if (next == null) {
                    result.add(null);
                } else {
                    Vector<Object> list = new Vector<Object>();
                    String sourceObject = next.getNodeValue();
                    StringTokenizer tokenizer = new StringTokenizer(sourceObject, " ");
                    while (tokenizer.hasMoreElements()) {
                        String token = tokenizer.nextToken();
                        Object nextItem = this.convertValue((Element)next.getParentNode(), field, token);
                        list.add(nextItem);
                    }
                    return list;
                }
            }
            int x = 0;
            while (x < resultSize) {
                Node next = nodeList.item(x);
                if (next == null) {
                    result.add(null);
                } else {
                    result.add(this.getValueFromElement((Element)next.getParentNode(), next, field));
                }
                ++x;
            }
        } else {
            int x = 0;
            while (x < resultSize) {
                result.add(this.buildNestedRow((Element)nodeList.item(x)));
                ++x;
            }
        }
        return result;
    }

    private Object getValueFromAttribute(Attr node, XMLField key) {
        this.currentNode = node.getOwnerElement();
        Object convertedValue = key.convertValueBasedOnSchemaType(node.getNodeValue(), (XMLConversionManager)this.session.getDatasourcePlatform().getConversionManager(), this);
        this.currentNode = this.getDOM();
        return convertedValue;
    }

    private Object getValueFromElement(Element node, Node textChild, XMLField key) {
        String value = textChild.getNodeValue();
        return this.convertValue(node, key, value);
    }

    private Object convertValue(Element node, XMLField key, Object value) {
        String schemaType;
        XMLConversionManager xmlCnvMgr = (XMLConversionManager)this.session.getDatasourcePlatform().getConversionManager();
        if (key.isTypedTextField() && node != null && (schemaType = node.getAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "type")) != null && schemaType.length() > 0) {
            QName qname = null;
            int index = schemaType.indexOf(58);
            if (index == -1) {
                qname = new QName(schemaType);
                Class convertClass = key.getJavaClass(qname);
                return xmlCnvMgr.convertObject(value, convertClass);
            }
            String prefix = schemaType.substring(0, index);
            String localPart = schemaType.substring(index + 1);
            XMLPlatform xmlPlatform = XMLPlatformFactory.getInstance().getXMLPlatform();
            String url = xmlPlatform.resolveNamespacePrefix(node, prefix);
            qname = new QName(url, localPart);
            Class convertClass = key.getJavaClass(qname);
            return xmlCnvMgr.convertObject(value, convertClass, qname);
        }
        this.currentNode = node;
        Object convertedValue = key.convertValueBasedOnSchemaType(value, xmlCnvMgr, this);
        this.currentNode = this.getDOM();
        return convertedValue;
    }

    public XMLRecord buildNestedRow(Element element) {
        DOMRecord record = new DOMRecord(element);
        record.setUnmarshaller(this.getUnmarshaller());
        record.setOwningObject(this.getCurrentObject());
        record.setDocPresPolicy(this.getDocPresPolicy());
        return record;
    }

    @Override
    public Node getDOM() {
        return this.dom;
    }

    @Override
    public Object put(DatabaseField key, Object value) {
        XMLField field = this.convertToXMLField(key);
        Object nodeValue = this.convertToNodeValue(value);
        NodeList replaced = null;
        boolean isEmptyCollection = false;
        if (nodeValue instanceof Collection) {
            isEmptyCollection = ((Collection)nodeValue).size() == 0;
            replaced = XPathEngine.getInstance().replaceCollection(this.convertToXMLField(key), this.dom, (Collection)nodeValue, this.session);
        } else {
            replaced = XPathEngine.getInstance().replaceValue(this.convertToXMLField(key), this.dom, nodeValue, this.session);
        }
        if (replaced.getLength() == 0) {
            XPathEngine.getInstance().create(this.convertToXMLField(key), this.dom, nodeValue, this.lastUpdatedField, this.getDocPresPolicy(), this.session);
        } else if (replaced.item(0) == this.getDOM()) {
            this.setDOM(this.getDocument().getDocumentElement());
        }
        if (!(field.getXPathFragment().isAttribute() || field.getXPathFragment().nameIsText() || value == null || isEmptyCollection)) {
            this.lastUpdatedField = field;
        }
        return replaced;
    }

    public Object put(List<XMLField> xmlFields, List<XMLEntry> values) {
        Vector valuesToWrite = (Vector)this.convertToNodeValue(values);
        List<XMLEntry> replaced = null;
        replaced = XPathEngine.getInstance().replaceCollection(xmlFields, valuesToWrite, this.dom, this.getDocPresPolicy(), this.lastUpdatedField, this.session);
        if (replaced.size() == 0) {
            XPathEngine.getInstance().create(xmlFields, this.dom, valuesToWrite, this.lastUpdatedField, this.getDocPresPolicy(), this.session);
        }
        return replaced;
    }

    @Override
    public Object put(Object key, Object value) throws ValidationException {
        if (key instanceof String) {
            return this.put((String)key, value);
        }
        if (key instanceof DatabaseField) {
            return this.put((DatabaseField)key, value);
        }
        if (key instanceof List) {
            return this.put((List)key, (List)value);
        }
        throw ValidationException.onlyFieldsAreValidKeysForDatabaseRows();
    }

    @Override
    public Object remove(DatabaseField key) {
        return XPathEngine.getInstance().remove(this.convertToXMLField(key), this.dom, true);
    }

    @Override
    public void replaceAt(Object value, int index) {
        throw XMLMarshalException.operationNotSupported("replaceAt(Object value, int index)");
    }

    @Override
    public Set entrySet() {
        int size = this.size();
        HashMap tempMap = new HashMap(size);
        Vector fields = this.getFields();
        Vector values = this.getValues();
        int i = 0;
        while (i < size) {
            tempMap.put(fields.elementAt(i), values.elementAt(i));
            ++i;
        }
        return tempMap.entrySet();
    }

    @Override
    protected void setFields(Vector fields) throws XMLMarshalException {
        throw XMLMarshalException.operationNotSupported("setField(Vector fields)");
    }

    @Override
    public Vector getFields() {
        int length = this.getDOM().getChildNodes().getLength();
        Node nextNode = null;
        if (length > 0) {
            nextNode = this.getDOM().getChildNodes().item(0);
        }
        Vector<DatabaseField> fields = new Vector<DatabaseField>(length);
        while (nextNode != null) {
            fields.add(new DatabaseField(nextNode.getNodeName()));
            nextNode = nextNode.getNextSibling();
        }
        return fields;
    }

    @Override
    public Vector getValues() {
        int length = this.getDOM().getChildNodes().getLength();
        Node nextNode = null;
        if (length > 0) {
            nextNode = this.getDOM().getFirstChild();
        }
        Vector<Node> values = new Vector<Node>(length);
        while (nextNode != null) {
            values.add(nextNode);
            nextNode = nextNode.getNextSibling();
        }
        return values;
    }

    @Override
    protected void setValues(Vector values) throws XMLMarshalException {
        throw XMLMarshalException.operationNotSupported("setValues(Vector values)");
    }

    public void setDOM(Node element) {
        this.dom = element;
        this.currentNode = element;
        this.getNamespaceResolver().setDOM(element);
    }

    public void setDOM(Element element) {
        this.dom = element;
        this.currentNode = element;
        this.getNamespaceResolver().setDOM(element);
    }

    @Override
    public String toString() {
        StringWriter writer = new StringWriter();
        writer.write(Helper.getShortClassName(this.getClass()));
        writer.write("(");
        this.transformToWriter(writer);
        writer.write(")");
        return writer.toString();
    }

    @Override
    public Set keySet() {
        int length = this.getDOM().getChildNodes().getLength();
        HashSet<String> keys = new HashSet<String>(length);
        int index = 0;
        while (index < length) {
            keys.add(this.getDOM().getChildNodes().item(index).getNodeName());
            ++index;
        }
        return keys;
    }

    @Override
    public Collection values() {
        int length = this.getDOM().getChildNodes().getLength();
        Vector<Node> values = new Vector<Node>(length);
        int index = 0;
        while (index < length) {
            values.add(this.getDOM().getChildNodes().item(index));
            ++index;
        }
        return values;
    }

    @Override
    public int size() {
        return this.getDOM().getAttributes().getLength() + this.getDOM().getChildNodes().getLength();
    }

    public void transformFromXML(String xml) {
        StringReader reader = new StringReader(xml);
        this.transformFromXML(reader);
    }

    private String resolveNamespace(NamespaceResolver namespaceResolver, String localName) {
        if (localName == null) {
            return null;
        }
        int colonIndex = localName.indexOf(58);
        if (colonIndex < 0) {
            if (namespaceResolver != null) {
                return namespaceResolver.getDefaultNamespaceURI();
            }
            return null;
        }
        if (namespaceResolver == null) {
            throw XMLMarshalException.namespaceResolverNotSpecified(localName);
        }
        String prefix = localName.substring(0, colonIndex);
        String uri = namespaceResolver.resolveNamespacePrefix(prefix);
        if (uri == null) {
            throw XMLMarshalException.namespaceNotFound(prefix);
        }
        return uri;
    }

    public void transformFromXML(Reader reader) {
        XMLParser parser = XMLPlatformFactory.getInstance().getXMLPlatform().newXMLParser();
        Document document = parser.parse(reader);
        this.setDOM(document.getDocumentElement());
    }

    @Override
    public String transformToXML() {
        StringWriter writer = new StringWriter();
        this.transformToWriter(writer);
        return writer.toString();
    }

    public void transformToWriter(Writer writer) {
        XMLTransformer xmlTransformer = XMLPlatformFactory.getInstance().getXMLPlatform().newXMLTransformer();
        xmlTransformer.transform(this.getDOM(), writer);
    }

    @Override
    public String resolveNamespacePrefix(String prefix) {
        XMLPlatform xmlPlatform = XMLPlatformFactory.getInstance().getXMLPlatform();
        return xmlPlatform.resolveNamespacePrefix(this.currentNode, prefix);
    }
}

