/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.oxm;

import org.eclipse.persistence.internal.oxm.XPathFragment;
import org.eclipse.persistence.internal.oxm.record.ExtendedContentHandler;
import org.eclipse.persistence.oxm.NamespaceResolver;
import org.eclipse.persistence.oxm.record.MarshalRecord;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class MarshalRecordContentHandler
implements ExtendedContentHandler {
    protected MarshalRecord marshalRecord;
    protected NamespaceResolver resolver;

    public MarshalRecordContentHandler(MarshalRecord record, NamespaceResolver resolver) {
        this.marshalRecord = record;
        this.resolver = resolver;
    }

    public void setMarshalRecord(MarshalRecord record) {
        this.marshalRecord = record;
    }

    public MarshalRecord getMarshalRecord() {
        return this.marshalRecord;
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        XPathFragment frag = new XPathFragment(qName);
        this.marshalRecord.openStartElement(frag, this.resolver);
        int i = 0;
        while (i < atts.getLength()) {
            this.marshalRecord.attribute(atts.getURI(i), atts.getLocalName(i), atts.getQName(i), atts.getValue(i));
            ++i;
        }
        this.marshalRecord.closeStartElement();
    }

    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        XPathFragment frag = new XPathFragment(qName);
        this.marshalRecord.endElement(frag, this.resolver);
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        this.marshalRecord.startPrefixMapping(prefix, uri);
    }

    public void processingInstruction(String target, String data) throws SAXException {
    }

    public void setDocumentLocator(Locator locator) {
    }

    public void startDocument() throws SAXException {
    }

    public void endDocument() throws SAXException {
    }

    public void skippedEntity(String name) throws SAXException {
    }

    public void endPrefixMapping(String prefix) throws SAXException {
        this.marshalRecord.endPrefixMapping(prefix);
    }

    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        String characters = new String(ch, start, length);
        this.characters(characters);
    }

    public void characters(CharSequence charSequence) throws SAXException {
        String characters = charSequence.toString();
        if (characters.trim().length() > 0) {
            this.marshalRecord.characters(characters);
        }
    }
}

