/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.jpql;

import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.persistence.internal.jpa.jpql.AbstractRangeDeclaration;
import org.eclipse.persistence.internal.jpa.jpql.CollectionDeclaration;
import org.eclipse.persistence.internal.jpa.jpql.Declaration;
import org.eclipse.persistence.internal.jpa.jpql.DerivedDeclaration;
import org.eclipse.persistence.internal.jpa.jpql.JPQLQueryContext;
import org.eclipse.persistence.internal.jpa.jpql.JoinDeclaration;
import org.eclipse.persistence.internal.jpa.jpql.RangeDeclaration;
import org.eclipse.persistence.jpa.jpql.parser.AbstractEclipseLinkExpressionVisitor;
import org.eclipse.persistence.jpa.jpql.parser.CollectionExpression;
import org.eclipse.persistence.jpa.jpql.parser.CollectionMemberDeclaration;
import org.eclipse.persistence.jpa.jpql.parser.CollectionValuedPathExpression;
import org.eclipse.persistence.jpa.jpql.parser.DeleteClause;
import org.eclipse.persistence.jpa.jpql.parser.DeleteStatement;
import org.eclipse.persistence.jpa.jpql.parser.Expression;
import org.eclipse.persistence.jpa.jpql.parser.ExpressionVisitor;
import org.eclipse.persistence.jpa.jpql.parser.FromClause;
import org.eclipse.persistence.jpa.jpql.parser.IdentificationVariable;
import org.eclipse.persistence.jpa.jpql.parser.IdentificationVariableDeclaration;
import org.eclipse.persistence.jpa.jpql.parser.JPQLExpression;
import org.eclipse.persistence.jpa.jpql.parser.Join;
import org.eclipse.persistence.jpa.jpql.parser.JoinFetch;
import org.eclipse.persistence.jpa.jpql.parser.RangeVariableDeclaration;
import org.eclipse.persistence.jpa.jpql.parser.ResultVariable;
import org.eclipse.persistence.jpa.jpql.parser.SelectClause;
import org.eclipse.persistence.jpa.jpql.parser.SelectStatement;
import org.eclipse.persistence.jpa.jpql.parser.SimpleFromClause;
import org.eclipse.persistence.jpa.jpql.parser.SimpleSelectClause;
import org.eclipse.persistence.jpa.jpql.parser.SimpleSelectStatement;
import org.eclipse.persistence.jpa.jpql.parser.UpdateClause;
import org.eclipse.persistence.jpa.jpql.parser.UpdateStatement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class DeclarationResolver {
    private Declaration baseDeclaration;
    private Map<String, Declaration> declarations;
    private DeclarationVisitor declarationVisitor;
    private DeclarationResolver parent;
    private boolean populated;
    private QualifyRangeDeclarationVisitor qualifyRangeDeclarationVisitor;
    private JPQLQueryContext queryContext;
    private Set<String> resultVariables;
    private boolean resultVariablesPopulated;
    private ResultVariableVisitor resultVariableVisitor;

    DeclarationResolver(JPQLQueryContext queryContext, DeclarationResolver parent) {
        this.initialize(queryContext, parent);
    }

    RangeDeclaration addRangeVariableDeclaration(String entityName, String variableName) {
        RangeVariableDeclaration rangeVariableDeclaration = new RangeVariableDeclaration(entityName, variableName);
        RangeDeclaration declaration = new RangeDeclaration(this.queryContext);
        declaration.rootPath = entityName;
        declaration.baseExpression = rangeVariableDeclaration;
        declaration.identificationVariable = (IdentificationVariable)rangeVariableDeclaration.getIdentificationVariable();
        variableName = variableName.toUpperCase().intern();
        this.declarations.put(variableName, declaration);
        if (this.baseDeclaration == null) {
            this.baseDeclaration = declaration;
        }
        return declaration;
    }

    void convertUnqualifiedDeclaration(RangeDeclaration declaration, String outerVariableName) {
        QualifyRangeDeclarationVisitor visitor = this.qualifyRangeDeclarationVisitor();
        try {
            visitor.declaration = declaration;
            visitor.outerVariableName = outerVariableName;
            visitor.queryContext = this.queryContext.getCurrentContext();
            declaration.declarationExpression.accept((ExpressionVisitor)visitor);
            String variableName = null;
            for (Map.Entry<String, Declaration> entry : this.declarations.entrySet()) {
                if (entry.getValue() != declaration) continue;
                variableName = entry.getKey();
                break;
            }
            this.declarations.put(variableName, visitor.declaration);
            if (this.baseDeclaration == declaration) {
                this.baseDeclaration = visitor.declaration;
            }
        }
        finally {
            visitor.declaration = null;
            visitor.queryContext = null;
            visitor.outerVariableName = null;
        }
    }

    private DeclarationVisitor declarationVisitor() {
        if (this.parent != null) {
            return this.parent.declarationVisitor();
        }
        if (this.declarationVisitor == null) {
            this.declarationVisitor = new DeclarationVisitor();
        }
        return this.declarationVisitor;
    }

    void dispose() {
        this.populated = false;
        this.baseDeclaration = null;
        this.resultVariablesPopulated = false;
        this.declarations.clear();
        if (this.resultVariables != null) {
            this.resultVariables.clear();
        }
    }

    Declaration getDeclaration(String variableName) {
        return this.declarations.get(variableName);
    }

    Collection<Declaration> getDeclarations() {
        return this.declarations.values();
    }

    Declaration getFirstDeclaration() {
        return this.baseDeclaration;
    }

    Collection<JoinFetch> getJoinFetches(String variableName) {
        RangeDeclaration rangeDeclaration;
        Declaration declaration = this.getDeclaration(variableName);
        if (declaration != null && declaration.isRange() && (rangeDeclaration = (RangeDeclaration)declaration).hasJoinFetches()) {
            return rangeDeclaration.getJoinFetches();
        }
        return null;
    }

    private void initialize(JPQLQueryContext queryContext, DeclarationResolver parent) {
        this.parent = parent;
        this.queryContext = queryContext;
        this.declarations = new LinkedHashMap<String, Declaration>();
    }

    boolean isRangeIdentificationVariable(String variableName) {
        boolean result = this.isRangeIdentificationVariableImp(variableName);
        if (!result && this.parent != null) {
            result = this.parent.isRangeIdentificationVariableImp(variableName);
        }
        return result;
    }

    private boolean isRangeIdentificationVariableImp(String variableName) {
        Declaration declaration = this.getDeclaration(variableName);
        return declaration != null && declaration.isRange();
    }

    boolean isResultVariable(String variableName) {
        if (this.parent != null) {
            return this.parent.isResultVariable(variableName);
        }
        if (!this.resultVariablesPopulated) {
            this.resultVariablesPopulated = true;
            this.queryContext.getJPQLExpression().accept((ExpressionVisitor)this.resultVariableVisitor());
        }
        return this.resultVariables.contains(variableName);
    }

    void populate(Expression expression) {
        if (!this.populated) {
            this.populated = true;
            this.populateImp(expression);
        }
    }

    private void populateImp(Expression expression) {
        DeclarationVisitor visitor = this.declarationVisitor();
        try {
            visitor.queryContext = this.queryContext.getCurrentContext();
            visitor.declarations = this.declarations;
            expression.accept((ExpressionVisitor)visitor);
            this.baseDeclaration = visitor.baseDeclaration;
        }
        finally {
            visitor.queryContext = null;
            visitor.declarations = null;
            visitor.baseDeclaration = null;
        }
    }

    private QualifyRangeDeclarationVisitor qualifyRangeDeclarationVisitor() {
        if (this.parent != null) {
            return this.parent.qualifyRangeDeclarationVisitor();
        }
        if (this.qualifyRangeDeclarationVisitor == null) {
            this.qualifyRangeDeclarationVisitor = new QualifyRangeDeclarationVisitor();
        }
        return this.qualifyRangeDeclarationVisitor;
    }

    private ResultVariableVisitor resultVariableVisitor() {
        if (this.resultVariableVisitor == null) {
            this.resultVariables = new HashSet<String>();
            this.resultVariableVisitor = new ResultVariableVisitor();
        }
        return this.resultVariableVisitor;
    }

    private static class DeclarationVisitor
    extends AbstractEclipseLinkExpressionVisitor {
        private Declaration baseDeclaration;
        private Declaration currentDeclaration;
        Map<String, Declaration> declarations;
        JPQLQueryContext queryContext;

        private DeclarationVisitor() {
        }

        public void visit(CollectionExpression expression) {
            expression.acceptChildren((ExpressionVisitor)this);
        }

        public void visit(CollectionMemberDeclaration expression) {
            CollectionDeclaration declaration = new CollectionDeclaration(this.queryContext);
            declaration.baseExpression = expression.getCollectionValuedPathExpression();
            declaration.declarationExpression = expression;
            if (expression.isDerived()) {
                this.declarations.put(declaration.baseExpression.toParsedText(), declaration);
            } else {
                IdentificationVariable identificationVariable;
                declaration.identificationVariable = identificationVariable = (IdentificationVariable)expression.getIdentificationVariable();
                this.declarations.put(identificationVariable.getVariableName(), declaration);
            }
            if (this.baseDeclaration == null) {
                this.baseDeclaration = declaration;
            }
        }

        public void visit(DeleteClause expression) {
            try {
                expression.getRangeVariableDeclaration().accept((ExpressionVisitor)this);
            }
            finally {
                this.currentDeclaration = null;
            }
        }

        public void visit(DeleteStatement expression) {
            expression.getDeleteClause().accept((ExpressionVisitor)this);
        }

        public void visit(FromClause expression) {
            expression.getDeclaration().accept((ExpressionVisitor)this);
        }

        public void visit(IdentificationVariableDeclaration expression) {
            try {
                expression.getRangeVariableDeclaration().accept((ExpressionVisitor)this);
                this.currentDeclaration.declarationExpression = expression;
                if (expression.hasJoins()) {
                    expression.getJoins().accept((ExpressionVisitor)this);
                }
            }
            finally {
                this.currentDeclaration = null;
            }
        }

        public void visit(Join expression) {
            ((AbstractRangeDeclaration)this.currentDeclaration).addJoin(expression);
            IdentificationVariable identificationVariable = (IdentificationVariable)expression.getIdentificationVariable();
            JoinDeclaration declaration = new JoinDeclaration(this.queryContext);
            declaration.baseExpression = expression;
            declaration.identificationVariable = identificationVariable;
            this.declarations.put(identificationVariable.getVariableName(), declaration);
        }

        public void visit(JoinFetch expression) {
            ((RangeDeclaration)this.currentDeclaration).addJoinFetch(expression);
        }

        public void visit(JPQLExpression expression) {
            expression.getQueryStatement().accept((ExpressionVisitor)this);
        }

        public void visit(RangeVariableDeclaration expression) {
            IdentificationVariable identificationVariable = (IdentificationVariable)expression.getIdentificationVariable();
            String rootPath = expression.getAbstractSchemaName().toParsedText();
            this.currentDeclaration = rootPath.indexOf(46) == -1 ? new RangeDeclaration(this.queryContext) : new DerivedDeclaration(this.queryContext);
            this.currentDeclaration.identificationVariable = identificationVariable;
            this.currentDeclaration.baseExpression = expression;
            this.currentDeclaration.rootPath = rootPath;
            this.declarations.put(identificationVariable.getVariableName(), this.currentDeclaration);
            if (this.baseDeclaration == null) {
                this.baseDeclaration = this.currentDeclaration;
            }
        }

        public void visit(SelectStatement expression) {
            expression.getFromClause().accept((ExpressionVisitor)this);
        }

        public void visit(SimpleFromClause expression) {
            expression.getDeclaration().accept((ExpressionVisitor)this);
        }

        public void visit(SimpleSelectClause expression) {
            expression.getSelectExpression().accept((ExpressionVisitor)this);
        }

        public void visit(SimpleSelectStatement expression) {
            expression.getFromClause().accept((ExpressionVisitor)this);
        }

        public void visit(UpdateClause expression) {
            try {
                expression.getRangeVariableDeclaration().accept((ExpressionVisitor)this);
            }
            finally {
                this.currentDeclaration = null;
            }
        }

        public void visit(UpdateStatement expression) {
            expression.getUpdateClause().accept((ExpressionVisitor)this);
        }
    }

    private static class QualifyRangeDeclarationVisitor
    extends AbstractEclipseLinkExpressionVisitor {
        AbstractRangeDeclaration declaration;
        String outerVariableName;
        JPQLQueryContext queryContext;

        private QualifyRangeDeclarationVisitor() {
        }

        public void visit(CollectionValuedPathExpression expression) {
            StringBuilder rootPath = new StringBuilder();
            rootPath.append(this.outerVariableName);
            rootPath.append(".");
            rootPath.append(expression.toParsedText());
            this.declaration.rootPath = rootPath.toString();
        }

        public void visit(IdentificationVariableDeclaration expression) {
            expression.getRangeVariableDeclaration().accept((ExpressionVisitor)this);
            this.declaration.declarationExpression = expression;
        }

        public void visit(RangeVariableDeclaration expression) {
            DerivedDeclaration derivedDeclaration = new DerivedDeclaration(this.queryContext);
            derivedDeclaration.joins = this.declaration.joins;
            derivedDeclaration.rootPath = this.declaration.rootPath;
            derivedDeclaration.baseExpression = this.declaration.baseExpression;
            derivedDeclaration.identificationVariable = this.declaration.identificationVariable;
            this.declaration = derivedDeclaration;
            expression.setVirtualIdentificationVariable(this.outerVariableName, this.declaration.rootPath);
            expression.getAbstractSchemaName().accept((ExpressionVisitor)this);
        }
    }

    private class ResultVariableVisitor
    extends AbstractEclipseLinkExpressionVisitor {
        private ResultVariableVisitor() {
        }

        public void visit(CollectionExpression expression) {
            expression.acceptChildren((ExpressionVisitor)this);
        }

        public void visit(JPQLExpression expression) {
            expression.getQueryStatement().accept((ExpressionVisitor)this);
        }

        public void visit(ResultVariable expression) {
            IdentificationVariable identificationVariable = (IdentificationVariable)expression.getResultVariable();
            DeclarationResolver.this.resultVariables.add(identificationVariable.getVariableName());
        }

        public void visit(SelectClause expression) {
            expression.getSelectExpression().accept((ExpressionVisitor)this);
        }

        public void visit(SelectStatement expression) {
            expression.getSelectClause().accept((ExpressionVisitor)this);
        }
    }
}

