/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.identitymaps;

import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.lang.reflect.Constructor;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.eclipse.persistence.config.ReferenceMode;
import org.eclipse.persistence.descriptors.CacheIndex;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.exceptions.EclipseLinkException;
import org.eclipse.persistence.exceptions.QueryException;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.internal.descriptors.ObjectBuilder;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.helper.ConcurrencyManager;
import org.eclipse.persistence.internal.helper.DeferredLockManager;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.helper.InvalidObject;
import org.eclipse.persistence.internal.helper.WriteLockManager;
import org.eclipse.persistence.internal.identitymaps.CacheId;
import org.eclipse.persistence.internal.identitymaps.CacheKey;
import org.eclipse.persistence.internal.identitymaps.IdentityMap;
import org.eclipse.persistence.internal.identitymaps.UnitOfWorkIdentityMap;
import org.eclipse.persistence.internal.identitymaps.WeakUnitOfWorkIdentityMap;
import org.eclipse.persistence.internal.localization.LoggingLocalization;
import org.eclipse.persistence.internal.localization.TraceLocalization;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.security.PrivilegedGetConstructorFor;
import org.eclipse.persistence.internal.security.PrivilegedInvokeConstructor;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.UnitOfWorkImpl;
import org.eclipse.persistence.queries.ObjectLevelReadQuery;
import org.eclipse.persistence.queries.ReadQuery;
import org.eclipse.persistence.sessions.Record;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IdentityMapManager
implements Serializable,
Cloneable {
    protected static final String MONITOR_PREFIX = "Info:CacheSize:";
    protected Map<Class, IdentityMap> identityMaps;
    protected Map<Object, IdentityMap> queryResults;
    protected Map<CacheIndex, IdentityMap> cacheIndexes;
    protected AbstractSession session;
    protected transient ConcurrencyManager cacheMutex;
    protected IdentityMap lastAccessedIdentityMap = null;
    protected transient WriteLockManager writeLockManager;
    protected boolean isCacheAccessPreCheckRequired;

    public IdentityMapManager(AbstractSession session) {
        this.session = session;
        this.cacheMutex = new ConcurrencyManager();
        if (session.isUnitOfWork()) {
            this.identityMaps = new HashMap<Class, IdentityMap>();
        } else if (session.isIsolatedClientSession()) {
            this.identityMaps = new HashMap<Class, IdentityMap>();
            this.queryResults = new HashMap<Object, IdentityMap>();
            this.cacheIndexes = new HashMap<CacheIndex, IdentityMap>();
        } else {
            this.identityMaps = new ConcurrentHashMap<Class, IdentityMap>();
            this.queryResults = new ConcurrentHashMap<Object, IdentityMap>();
            this.cacheIndexes = new ConcurrentHashMap<CacheIndex, IdentityMap>();
        }
        this.checkIsCacheAccessPreCheckRequired();
    }

    public CacheKey acquireDeferredLock(Object primaryKey, Class domainClass, ClassDescriptor descriptor) {
        CacheKey cacheKey = null;
        if (this.isCacheAccessPreCheckRequired) {
            this.session.startOperationProfile("Timer:Caching");
            this.acquireReadLock();
            IdentityMap identityMap = this.getIdentityMap(descriptor, false);
            try {
                cacheKey = identityMap.acquireDeferredLock(primaryKey);
            }
            finally {
                this.releaseReadLock();
            }
            this.session.endOperationProfile("Timer:Caching");
            if (!this.session.isUnitOfWork() && cacheKey.getObject() == null) {
                this.session.updateProfile(MONITOR_PREFIX + domainClass.getSimpleName(), identityMap.getSize());
            }
        } else {
            cacheKey = this.getIdentityMap(descriptor, false).acquireDeferredLock(primaryKey);
        }
        return cacheKey;
    }

    public CacheKey acquireLock(Object primaryKey, Class domainClass, boolean forMerge, ClassDescriptor descriptor) {
        if (primaryKey == null) {
            CacheKey cacheKey = new CacheKey(primaryKey);
            cacheKey.acquire();
            return cacheKey;
        }
        CacheKey cacheKey = null;
        if (this.isCacheAccessPreCheckRequired) {
            this.session.startOperationProfile("Timer:Caching");
            this.acquireReadLock();
            IdentityMap identityMap = this.getIdentityMap(descriptor, false);
            try {
                cacheKey = identityMap.acquireLock(primaryKey, forMerge);
            }
            finally {
                this.releaseReadLock();
            }
            this.session.endOperationProfile("Timer:Caching");
            if (!this.session.isUnitOfWork() && cacheKey != null && cacheKey.getObject() == null) {
                this.session.updateProfile(MONITOR_PREFIX + domainClass.getSimpleName(), identityMap.getSize());
            }
        } else {
            cacheKey = this.getIdentityMap(descriptor, false).acquireLock(primaryKey, forMerge);
        }
        return cacheKey;
    }

    public CacheKey acquireLockNoWait(Object primaryKey, Class domainClass, boolean forMerge, ClassDescriptor descriptor) {
        if (primaryKey == null) {
            CacheKey cacheKey = new CacheKey(primaryKey);
            cacheKey.acquire();
            return cacheKey;
        }
        CacheKey cacheKey = null;
        if (this.isCacheAccessPreCheckRequired) {
            this.session.startOperationProfile("Timer:Caching");
            this.acquireReadLock();
            IdentityMap identityMap = this.getIdentityMap(descriptor, false);
            try {
                cacheKey = identityMap.acquireLockNoWait(primaryKey, forMerge);
            }
            finally {
                this.releaseReadLock();
            }
            this.session.endOperationProfile("Timer:Caching");
            if (!this.session.isUnitOfWork() && cacheKey != null && cacheKey.getObject() == null) {
                this.session.updateProfile(MONITOR_PREFIX + domainClass.getSimpleName(), identityMap.getSize());
            }
        } else {
            cacheKey = this.getIdentityMap(descriptor, false).acquireLockNoWait(primaryKey, forMerge);
        }
        return cacheKey;
    }

    public CacheKey acquireLockWithWait(Object primaryKey, Class domainClass, boolean forMerge, ClassDescriptor descriptor, int wait) {
        if (primaryKey == null) {
            CacheKey cacheKey = new CacheKey(primaryKey);
            cacheKey.acquire();
            return cacheKey;
        }
        CacheKey cacheKey = null;
        if (this.isCacheAccessPreCheckRequired) {
            this.session.startOperationProfile("Timer:Caching");
            this.acquireReadLock();
            IdentityMap identityMap = this.getIdentityMap(descriptor, false);
            try {
                cacheKey = identityMap.acquireLockWithWait(primaryKey, forMerge, wait);
            }
            finally {
                this.releaseReadLock();
            }
            this.session.endOperationProfile("Timer:Caching");
            if (!this.session.isUnitOfWork() && cacheKey != null && cacheKey.getObject() == null) {
                this.session.updateProfile(MONITOR_PREFIX + domainClass.getSimpleName(), identityMap.getSize());
            }
        } else {
            cacheKey = this.getIdentityMap(descriptor, false).acquireLockWithWait(primaryKey, forMerge, wait);
        }
        return cacheKey;
    }

    public void checkIsCacheAccessPreCheckRequired() {
        this.isCacheAccessPreCheckRequired = this.session.getProfiler() != null || this.session.getDatasourceLogin() != null && this.session.getDatasourceLogin().shouldSynchronizedReadOnWrite();
    }

    public void acquireReadLock() {
        this.session.startOperationProfile("Timer:Caching");
        if (this.session.getDatasourceLogin().shouldSynchronizedReadOnWrite()) {
            this.getCacheMutex().acquireReadLock();
        }
        this.session.endOperationProfile("Timer:Caching");
    }

    public CacheKey acquireReadLockOnCacheKey(Object primaryKey, Class domainClass, ClassDescriptor descriptor) {
        if (primaryKey == null) {
            CacheKey cacheKey = new CacheKey(primaryKey);
            cacheKey.acquireReadLock();
            return cacheKey;
        }
        CacheKey cacheKey = null;
        if (this.isCacheAccessPreCheckRequired) {
            this.session.startOperationProfile("Timer:Caching");
            this.acquireReadLock();
            try {
                cacheKey = this.getIdentityMap(descriptor, false).acquireReadLockOnCacheKey(primaryKey);
            }
            finally {
                this.releaseReadLock();
            }
            this.session.endOperationProfile("Timer:Caching");
        } else {
            cacheKey = this.getIdentityMap(descriptor, false).acquireReadLockOnCacheKey(primaryKey);
        }
        return cacheKey;
    }

    public CacheKey acquireReadLockOnCacheKeyNoWait(Object primaryKey, Class domainClass, ClassDescriptor descriptor) {
        if (primaryKey == null) {
            CacheKey cacheKey = new CacheKey(primaryKey);
            cacheKey.acquireReadLock();
            return cacheKey;
        }
        CacheKey cacheKey = null;
        if (this.isCacheAccessPreCheckRequired) {
            this.session.startOperationProfile("Timer:Caching");
            this.acquireReadLock();
            try {
                cacheKey = this.getIdentityMap(descriptor, false).acquireReadLockOnCacheKeyNoWait(primaryKey);
            }
            finally {
                this.releaseReadLock();
            }
            this.session.endOperationProfile("Timer:Caching");
        } else {
            cacheKey = this.getIdentityMap(descriptor, false).acquireReadLockOnCacheKeyNoWait(primaryKey);
        }
        return cacheKey;
    }

    public boolean acquireWriteLock() {
        if (this.session.getDatasourceLogin().shouldSynchronizedReadOnWrite() || this.session.getDatasourceLogin().shouldSynchronizeWrites()) {
            this.getCacheMutex().acquire();
            return true;
        }
        return false;
    }

    public IdentityMap buildNewIdentityMapForUnitOfWork(UnitOfWorkImpl unitOfwork, ClassDescriptor descriptor) {
        ReferenceMode mode = unitOfwork.getReferenceMode();
        if (mode == ReferenceMode.FORCE_WEAK) {
            return new WeakUnitOfWorkIdentityMap(32, descriptor);
        }
        if (mode == ReferenceMode.WEAK && descriptor.getObjectChangePolicy().isAttributeChangeTrackingPolicy()) {
            return new WeakUnitOfWorkIdentityMap(32, descriptor);
        }
        return new UnitOfWorkIdentityMap(32, descriptor);
    }

    public IdentityMap buildNewIdentityMap(ClassDescriptor descriptor) {
        if (this.session.isUnitOfWork()) {
            if (((UnitOfWorkImpl)this.session).getReferenceMode() == ReferenceMode.FORCE_WEAK) {
                return new WeakUnitOfWorkIdentityMap(32, descriptor);
            }
            if (((UnitOfWorkImpl)this.session).getReferenceMode() == ReferenceMode.WEAK && descriptor.getObjectChangePolicy().isAttributeChangeTrackingPolicy()) {
                return new WeakUnitOfWorkIdentityMap(32, descriptor);
            }
            return new UnitOfWorkIdentityMap(32, descriptor);
        }
        if (this.session.isRemoteSession()) {
            return this.buildNewIdentityMap(descriptor.getRemoteIdentityMapClass(), descriptor.getRemoteIdentityMapSize(), descriptor, true);
        }
        if (this.session.isServerSession()) {
            return this.buildNewIdentityMap(descriptor.getIdentityMapClass(), descriptor.getIdentityMapSize(), descriptor, false);
        }
        return this.buildNewIdentityMap(descriptor.getIdentityMapClass(), descriptor.getIdentityMapSize(), descriptor, true);
    }

    protected IdentityMap buildNewIdentityMap(Class identityMapClass, int size, ClassDescriptor descriptor, boolean isIsolated) throws DescriptorException {
        try {
            Constructor constructor = null;
            Class[] parameters = null;
            Object[] values = null;
            if (isIsolated) {
                parameters = new Class[]{ClassConstants.PINT, ClassDescriptor.class, Boolean.TYPE};
                values = new Object[]{size, descriptor, true};
            } else {
                parameters = new Class[]{ClassConstants.PINT, ClassDescriptor.class};
                values = new Object[]{size, descriptor};
            }
            if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                try {
                    constructor = (Constructor)AccessController.doPrivileged(new PrivilegedGetConstructorFor(identityMapClass, parameters, false));
                    IdentityMap map = (IdentityMap)AccessController.doPrivileged(new PrivilegedInvokeConstructor(constructor, values));
                    if (descriptor != null && descriptor.getCachePolicy().getCacheInterceptorClass() != null) {
                        constructor = (Constructor)AccessController.doPrivileged(new PrivilegedGetConstructorFor(descriptor.getCacheInterceptorClass(), new Class[]{IdentityMap.class, AbstractSession.class}, false));
                        Object[] params = new Object[]{map, this.session};
                        map = (IdentityMap)AccessController.doPrivileged(new PrivilegedInvokeConstructor(constructor, params));
                    }
                    return map;
                }
                catch (PrivilegedActionException exception) {
                    throw DescriptorException.invalidIdentityMap(descriptor, exception.getException());
                }
            }
            constructor = PrivilegedAccessHelper.getConstructorFor(identityMapClass, parameters, false);
            IdentityMap map = (IdentityMap)PrivilegedAccessHelper.invokeConstructor(constructor, values);
            if (descriptor != null && descriptor.getCacheInterceptorClass() != null) {
                constructor = PrivilegedAccessHelper.getConstructorFor(descriptor.getCacheInterceptorClass(), new Class[]{IdentityMap.class, AbstractSession.class}, false);
                Object[] params = new Object[]{map, this.session};
                map = (IdentityMap)PrivilegedAccessHelper.invokeConstructor(constructor, params);
            }
            return map;
        }
        catch (Exception exception) {
            throw DescriptorException.invalidIdentityMap(descriptor, exception);
        }
    }

    public void clearLastAccessedIdentityMap() {
        this.lastAccessedIdentityMap = null;
    }

    public Object clone() {
        IdentityMapManager manager = null;
        try {
            manager = (IdentityMapManager)super.clone();
            manager.setIdentityMaps(new ConcurrentHashMap());
            for (Map.Entry<Class, IdentityMap> entry : this.identityMaps.entrySet()) {
                manager.identityMaps.put(entry.getKey(), (IdentityMap)entry.getValue().clone());
            }
        }
        catch (CloneNotSupportedException exception) {
            throw new InternalError(exception.toString());
        }
        return manager;
    }

    public void clearQueryCache() {
        this.queryResults = new ConcurrentHashMap<Object, IdentityMap>();
    }

    public void clearCacheIndexes() {
        this.cacheIndexes = new ConcurrentHashMap<CacheIndex, IdentityMap>();
    }

    public void clearQueryCache(ReadQuery query) {
        if (query != null) {
            Object queryKey = query.getName();
            if (queryKey == null || ((String)queryKey).length() == 0) {
                queryKey = query;
            }
            this.queryResults.remove(queryKey);
        }
    }

    public boolean containsKey(Object key, Class theClass, ClassDescriptor descriptor) {
        if (key == null) {
            return false;
        }
        IdentityMap map = this.getIdentityMap(descriptor, true);
        if (map == null) {
            return false;
        }
        if (this.isCacheAccessPreCheckRequired) {
            this.session.startOperationProfile("Timer:Caching");
            this.acquireReadLock();
            try {
                boolean bl = map.containsKey(key);
                return bl;
            }
            finally {
                this.releaseReadLock();
                this.session.endOperationProfile("Timer:Caching");
            }
        }
        return map.containsKey(key);
    }

    public Vector getAllFromIdentityMap(Expression selectionCriteria, Class theClass, Record translationRow, int valueHolderPolicy, boolean shouldReturnInvalidatedObjects) {
        ClassDescriptor descriptor = this.session.getDescriptor(theClass);
        this.session.startOperationProfile("Timer:Caching");
        Vector<Object> objects = null;
        try {
            ExpressionBuilder builder;
            if (selectionCriteria != null && (builder = selectionCriteria.getBuilder()) != null && builder.getSession() == null) {
                builder.setSession(this.session.getRootSession(null));
                builder.setQueryClass(theClass);
            }
            objects = new Vector<Object>();
            IdentityMap map = this.getIdentityMap(descriptor, false);
            boolean readSubclassesOrNoInheritance = !descriptor.hasInheritance() || descriptor.getInheritancePolicy().shouldReadSubclasses();
            long currentTimeInMillis = System.currentTimeMillis();
            Enumeration cacheEnum = map.keys();
            while (cacheEnum.hasMoreElements()) {
                Object object;
                CacheKey key = (CacheKey)cacheEnum.nextElement();
                if (key.getObject() == null || !shouldReturnInvalidatedObjects && descriptor.getCacheInvalidationPolicy().isInvalidated(key, currentTimeInMillis) || (object = key.getObject()) == null || object.getClass() != theClass && (!readSubclassesOrNoInheritance || !theClass.isInstance(object))) continue;
                if (selectionCriteria == null) {
                    objects.add(object);
                    continue;
                }
                try {
                    if (!selectionCriteria.doesConform(object, this.session, (AbstractRecord)translationRow, valueHolderPolicy)) continue;
                    objects.add(object);
                }
                catch (QueryException queryException) {
                    if (queryException.getErrorCode() == 6092) {
                        if (valueHolderPolicy == 2) {
                            objects.add(object);
                            continue;
                        }
                        if (valueHolderPolicy != 0) continue;
                        throw queryException;
                    }
                    throw queryException;
                }
            }
        }
        finally {
            this.session.endOperationProfile("Timer:Caching");
        }
        return objects;
    }

    public Map<Object, Object> getAllFromIdentityMapWithEntityPK(Object[] pkList, ClassDescriptor descriptor, AbstractSession session) {
        return this.getIdentityMap(descriptor).getAllFromIdentityMapWithEntityPK(pkList, descriptor, session);
    }

    /*
     * Unable to fully structure code
     */
    public void invalidateObjects(Expression selectionCriteria, Class theClass, Record translationRow, boolean shouldInvalidateOnException) {
        block19: {
            block18: {
                descriptor = this.session.getDescriptor(theClass);
                this.session.startOperationProfile("Timer:Caching");
                map = this.getIdentityMap(descriptor, true);
                if (map == null) {
                    return;
                }
                isChildDescriptor = descriptor.isChildDescriptor();
                if (selectionCriteria != null) {
                    builder = selectionCriteria.getBuilder();
                    if (builder.getSession() == null) {
                        builder.setSession(this.session.getRootSession(null));
                        builder.setQueryClass(theClass);
                    }
                    cacheInvalidationPolicy = descriptor.getCacheInvalidationPolicy();
                    inMemoryQueryIndirectionPolicy = 3;
                    if (shouldInvalidateOnException) {
                        inMemoryQueryIndirectionPolicy = 2;
                    }
                    currentTimeInMillis = System.currentTimeMillis();
                    cacheEnum = map.keys(false);
                    while (cacheEnum.hasMoreElements()) {
                        key = (CacheKey)cacheEnum.nextElement();
                        object = key.getObject();
                        if (object == null || cacheInvalidationPolicy.isInvalidated(key, currentTimeInMillis) || isChildDescriptor && object.getClass() != theClass && !theClass.isInstance(object)) continue;
                        try {
                            if (!selectionCriteria.doesConform(object, this.session, (AbstractRecord)translationRow, inMemoryQueryIndirectionPolicy)) continue;
                            key.setInvalidationState(-1);
                            continue;
                        }
                        catch (QueryException queryException) {
                            if (queryException.getErrorCode() == 6074) {
                                if (shouldInvalidateOnException) {
                                    this.invalidateObjects(null, theClass, null, true);
                                    continue;
                                }
                                this.session.endOperationProfile("Timer:Caching");
                                return;
                            }
                            if (!shouldInvalidateOnException) continue;
                            key.setInvalidationState(-1);
                            continue;
                        }
                        catch (RuntimeException v0) {
                            if (!shouldInvalidateOnException) continue;
                            key.setInvalidationState(-1);
                        }
                        {
                        }
                    }
                }
                if (!isChildDescriptor) break block18;
                cacheEnum = map.keys(false);
lbl44:
                // 2 sources

                ** while (cacheEnum.hasMoreElements())
lbl45:
                // 1 sources

lbl46:
                // 1 sources

                key = (CacheKey)cacheEnum.nextElement();
                object = key.getObject();
                if (object != null && (object.getClass() == theClass || theClass.isInstance(object))) {
                    key.setInvalidationState(-1);
                }
                ** GOTO lbl44
            }
            cacheEnum = map.keys(false);
            while (cacheEnum.hasMoreElements()) {
                key = (CacheKey)cacheEnum.nextElement();
                key.setInvalidationState(-1);
            }
            break block19;
            finally {
                this.session.endOperationProfile("Timer:Caching");
            }
        }
    }

    public CacheKey getCacheKeyForObjectForLock(Object primaryKey, Class theClass, ClassDescriptor descriptor) {
        if (primaryKey == null) {
            return null;
        }
        IdentityMap map = this.getIdentityMap(descriptor, true);
        if (map == null) {
            return null;
        }
        CacheKey cacheKey = null;
        if (this.isCacheAccessPreCheckRequired) {
            this.session.startOperationProfile("Timer:Caching");
            this.acquireReadLock();
            try {
                cacheKey = map.getCacheKeyForLock(primaryKey);
            }
            finally {
                this.releaseReadLock();
                this.session.endOperationProfile("Timer:Caching");
            }
        } else {
            cacheKey = map.getCacheKeyForLock(primaryKey);
        }
        return cacheKey;
    }

    public CacheKey getCacheKeyForObject(Object primaryKey, Class theClass, ClassDescriptor descriptor, boolean forMerge) {
        if (primaryKey == null) {
            return null;
        }
        IdentityMap map = this.getIdentityMap(descriptor, true);
        if (map == null) {
            return null;
        }
        CacheKey cacheKey = null;
        if (this.isCacheAccessPreCheckRequired) {
            this.session.startOperationProfile("Timer:Caching");
            this.acquireReadLock();
            try {
                cacheKey = map.getCacheKey(primaryKey, forMerge);
            }
            finally {
                this.releaseReadLock();
                this.session.endOperationProfile("Timer:Caching");
            }
        } else {
            cacheKey = map.getCacheKey(primaryKey, forMerge);
        }
        return cacheKey;
    }

    public ConcurrencyManager getCacheMutex() {
        return this.cacheMutex;
    }

    public Vector getClassesRegistered() {
        Iterator<Class> classes = this.getIdentityMaps().keySet().iterator();
        Vector<String> results = new Vector<String>(this.getIdentityMaps().size());
        while (classes.hasNext()) {
            results.add(classes.next().getName());
        }
        return results;
    }

    public Object getFromIdentityMap(Object object) {
        ClassDescriptor descriptor = this.session.getDescriptor(object);
        Object primaryKey = descriptor.getObjectBuilder().extractPrimaryKeyFromObject(object, this.session);
        return this.getFromIdentityMap(primaryKey, object.getClass(), descriptor);
    }

    public Object getFromIdentityMap(Object key, Class theClass, ClassDescriptor descriptor) {
        return this.getFromIdentityMap(key, theClass, true, descriptor);
    }

    public Object getFromIdentityMap(Object key, Class theClass, boolean shouldReturnInvalidatedObjects, ClassDescriptor descriptor) {
        CacheKey cacheKey;
        if (key == null) {
            return null;
        }
        IdentityMap map = this.getIdentityMap(descriptor, true);
        if (map == null) {
            return null;
        }
        Object domainObject = null;
        if (this.isCacheAccessPreCheckRequired) {
            this.session.startOperationProfile("Timer:Caching");
            this.acquireReadLock();
            try {
                cacheKey = map.getCacheKey(key, false);
            }
            finally {
                this.releaseReadLock();
            }
        } else {
            cacheKey = map.getCacheKey(key, false);
        }
        if (cacheKey != null && (shouldReturnInvalidatedObjects || !descriptor.getCacheInvalidationPolicy().isInvalidated(cacheKey))) {
            domainObject = cacheKey.getObject();
            cacheKey.checkReadLock();
            domainObject = this.checkForInheritance(domainObject, theClass, descriptor);
        }
        if (this.isCacheAccessPreCheckRequired) {
            this.session.endOperationProfile("Timer:Caching");
        }
        return domainObject;
    }

    public Object getFromIdentityMap(Expression selectionCriteria, Class theClass, Record translationRow, int valueHolderPolicy, boolean conforming, boolean shouldReturnInvalidatedObjects, ClassDescriptor descriptor) {
        UnitOfWorkImpl unitOfWork = conforming ? (UnitOfWorkImpl)this.session : null;
        this.session.startOperationProfile("Timer:Caching");
        try {
            Enumeration cacheEnum;
            ExpressionBuilder builder;
            if (selectionCriteria != null && (builder = selectionCriteria.getBuilder()).getSession() == null) {
                builder.setSession(this.session.getRootSession(null));
                builder.setQueryClass(theClass);
            }
            IdentityMap map = this.getIdentityMap(descriptor, false);
            boolean copyKeyCollection = valueHolderPolicy == 1;
            Vector<CacheKey> cacheKeys = null;
            if (copyKeyCollection) {
                cacheKeys = new Vector<CacheKey>(map.getSize());
                cacheEnum = map.keys();
                while (cacheEnum.hasMoreElements()) {
                    CacheKey key = (CacheKey)cacheEnum.nextElement();
                    cacheKeys.add(key);
                }
            }
            cacheEnum = copyKeyCollection ? cacheKeys.elements() : map.keys();
            long currentTimeInMillis = System.currentTimeMillis();
            while (cacheEnum.hasMoreElements()) {
                Object object;
                CacheKey key = (CacheKey)cacheEnum.nextElement();
                if (!shouldReturnInvalidatedObjects && descriptor.getCacheInvalidationPolicy().isInvalidated(key, currentTimeInMillis) || (object = key.getObject()) == null || object.getClass() != theClass && !theClass.isInstance(object)) continue;
                if (!(selectionCriteria != null || conforming && unitOfWork.isObjectDeleted(object))) {
                    Object object2 = object;
                    return object2;
                }
                if (!selectionCriteria.doesConform(object, this.session, (AbstractRecord)translationRow, valueHolderPolicy) || conforming && unitOfWork.isObjectDeleted(object)) continue;
                Object object3 = object;
                return object3;
            }
        }
        finally {
            this.session.endOperationProfile("Timer:Caching");
        }
        return null;
    }

    public Object getFromIdentityMapWithDeferredLock(Object key, Class theClass, boolean shouldReturnInvalidatedObjects, ClassDescriptor descriptor) {
        CacheKey cacheKey;
        if (key == null) {
            return null;
        }
        IdentityMap map = this.getIdentityMap(descriptor, true);
        if (map == null) {
            return null;
        }
        Object domainObject = null;
        if (this.isCacheAccessPreCheckRequired) {
            this.session.startOperationProfile("Timer:Caching");
            this.acquireReadLock();
            try {
                cacheKey = map.getCacheKey(key, false);
            }
            finally {
                this.releaseReadLock();
            }
        } else {
            cacheKey = map.getCacheKey(key, false);
        }
        if (cacheKey != null && (shouldReturnInvalidatedObjects || !descriptor.getCacheInvalidationPolicy().isInvalidated(cacheKey))) {
            domainObject = cacheKey.getObject();
            cacheKey.checkDeferredLock();
            domainObject = this.checkForInheritance(domainObject, theClass, descriptor);
        }
        if (this.isCacheAccessPreCheckRequired) {
            this.session.endOperationProfile("Timer:Caching");
        }
        return domainObject;
    }

    public IdentityMap getIdentityMap(ClassDescriptor descriptor) {
        return this.getIdentityMap(descriptor, false);
    }

    public IdentityMap getIdentityMap(ClassDescriptor descriptor, boolean returnNullIfNoMap) {
        if (descriptor.hasInheritance()) {
            descriptor = descriptor.getInheritancePolicy().getRootParentDescriptor();
        }
        Class descriptorClass = descriptor.getJavaClass();
        IdentityMap tempMap = this.lastAccessedIdentityMap;
        if (tempMap != null && tempMap.getDescriptorClass() == descriptorClass) {
            return tempMap;
        }
        IdentityMap identityMap = this.identityMaps.get(descriptorClass);
        if (identityMap == null) {
            if (returnNullIfNoMap && descriptor.getCachePolicy().getCacheInterceptorClass() == null) {
                return null;
            }
            IdentityMap newIdentityMap = null;
            if (this.session.isUnitOfWork()) {
                newIdentityMap = this.buildNewIdentityMapForUnitOfWork((UnitOfWorkImpl)this.session, descriptor);
                identityMap = this.identityMaps.put(descriptorClass, newIdentityMap);
            } else if (this.session.isIsolatedClientSession()) {
                newIdentityMap = this.buildNewIdentityMap(descriptor);
                identityMap = this.identityMaps.put(descriptorClass, newIdentityMap);
            } else {
                newIdentityMap = this.buildNewIdentityMap(descriptor);
                identityMap = ((ConcurrentMap)this.identityMaps).putIfAbsent(descriptorClass, newIdentityMap);
            }
            if (identityMap == null) {
                identityMap = newIdentityMap;
            }
        }
        this.lastAccessedIdentityMap = identityMap;
        return identityMap;
    }

    protected Map<Class, IdentityMap> getIdentityMaps() {
        return this.identityMaps;
    }

    public Iterator getIdentityMapClasses() {
        return this.getIdentityMaps().keySet().iterator();
    }

    public Object getQueryResult(ReadQuery query, List parameters, boolean shouldCheckExpiry) {
        IdentityMap map;
        if (query.getQueryResultsCachePolicy() == null) {
            return null;
        }
        Object queryKey = query.getName();
        if (queryKey == null || ((String)queryKey).length() == 0) {
            queryKey = query;
        }
        if ((map = this.queryResults.get(queryKey)) == null) {
            return null;
        }
        CacheId lookupParameters = parameters == null ? new CacheId(new Object[0]) : new CacheId(parameters.toArray());
        CacheKey key = map.getCacheKey(lookupParameters, false);
        if (key == null || shouldCheckExpiry && query.getQueryResultsCachePolicy().getCacheInvalidationPolicy().isInvalidated(key)) {
            return null;
        }
        return key.getObject();
    }

    public CacheKey getCacheKeyByIndex(CacheIndex index, CacheId indexValues, boolean shouldCheckExpiry, ClassDescriptor descriptor) {
        if (this.cacheIndexes == null) {
            return null;
        }
        IdentityMap map = this.cacheIndexes.get(index);
        if (map == null) {
            return null;
        }
        CacheKey cacheKey = map.getCacheKey(indexValues, false);
        if (cacheKey == null) {
            return null;
        }
        if ((cacheKey = (CacheKey)cacheKey.getObject()) == null) {
            return null;
        }
        if (shouldCheckExpiry && descriptor.getCacheInvalidationPolicy().isInvalidated(cacheKey)) {
            return null;
        }
        return cacheKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putCacheKeyByIndex(CacheIndex index, CacheId indexValues, CacheKey cacheKey, ClassDescriptor descriptor) {
        if (this.cacheIndexes == null) {
            return;
        }
        if (indexValues == null) {
            return;
        }
        IdentityMap map = this.cacheIndexes.get(index);
        if (map == null) {
            Map<CacheIndex, IdentityMap> map2 = this.cacheIndexes;
            synchronized (map2) {
                map = this.cacheIndexes.get(index);
                if (map == null) {
                    map = this.buildNewIdentityMap(index.getCacheType(), index.getCacheSize(), null, false);
                    this.cacheIndexes.put(index, map);
                }
            }
        }
        map.put(indexValues, cacheKey, null, 0L);
    }

    protected AbstractSession getSession() {
        return this.session;
    }

    public Object getWrapper(Object primaryKey, Class theClass) {
        Object wrapper;
        ClassDescriptor descriptor = this.session.getDescriptor(theClass);
        IdentityMap map = this.getIdentityMap(descriptor, false);
        if (this.isCacheAccessPreCheckRequired) {
            this.session.startOperationProfile("Timer:Caching");
            this.acquireReadLock();
            try {
                wrapper = map.getWrapper(primaryKey);
            }
            finally {
                this.releaseReadLock();
            }
            this.session.endOperationProfile("Timer:Caching");
        } else {
            wrapper = map.getWrapper(primaryKey);
        }
        return wrapper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WriteLockManager getWriteLockManager() {
        IdentityMapManager identityMapManager = this;
        synchronized (identityMapManager) {
            if (this.writeLockManager == null) {
                this.writeLockManager = new WriteLockManager();
            }
        }
        return this.writeLockManager;
    }

    public Object getWriteLockValue(Object primaryKey, Class domainClass, ClassDescriptor descriptor) {
        Object value;
        if (primaryKey == null) {
            return null;
        }
        IdentityMap map = this.getIdentityMap(descriptor, false);
        if (this.isCacheAccessPreCheckRequired) {
            this.session.startOperationProfile("Timer:Caching");
            this.acquireReadLock();
            try {
                value = map.getWriteLockValue(primaryKey);
            }
            finally {
                this.releaseReadLock();
            }
            this.session.endOperationProfile("Timer:Caching");
        } else {
            value = map.getWriteLockValue(primaryKey);
        }
        return value;
    }

    public void initializeIdentityMap(Class theClass) throws EclipseLinkException {
        ClassDescriptor descriptor = this.session.getDescriptor(theClass);
        if (descriptor == null) {
            throw ValidationException.missingDescriptor(String.valueOf(theClass));
        }
        if (descriptor.isChildDescriptor()) {
            throw ValidationException.childDescriptorsDoNotHaveIdentityMap();
        }
        Class javaClass = descriptor.getJavaClass();
        IdentityMap identityMap = this.buildNewIdentityMap(descriptor);
        this.getIdentityMaps().put(javaClass, identityMap);
        this.clearLastAccessedIdentityMap();
    }

    public void initializeIdentityMaps() {
        this.clearLastAccessedIdentityMap();
        this.setIdentityMaps(new ConcurrentHashMap());
        this.clearQueryCache();
        this.clearCacheIndexes();
    }

    public void printIdentityMap(Class businessClass) {
        String cr = Helper.cr();
        ClassDescriptor descriptor = this.session.getDescriptor(businessClass);
        int cacheCounter = 0;
        StringWriter writer = new StringWriter();
        if (descriptor.isDescriptorTypeAggregate()) {
            return;
        }
        IdentityMap map = this.getIdentityMap(descriptor, true);
        if (map == null) {
            return;
        }
        writer.write(LoggingLocalization.buildMessage("identitymap_for", new Object[]{cr, Helper.getShortClassName(map.getClass()), Helper.getShortClassName(businessClass)}));
        if (descriptor.hasInheritance() && descriptor.getInheritancePolicy().isRootParentDescriptor()) {
            writer.write(LoggingLocalization.buildMessage("includes"));
            List<ClassDescriptor> childDescriptors = descriptor.getInheritancePolicy().getChildDescriptors();
            if (childDescriptors != null && childDescriptors.size() != 0) {
                Iterator<ClassDescriptor> iterator = childDescriptors.iterator();
                writer.write(Helper.getShortClassName(iterator.next().getJavaClass()));
                while (iterator.hasNext()) {
                    writer.write(", " + Helper.getShortClassName(iterator.next().getJavaClass()));
                }
            }
            writer.write(")");
        }
        Enumeration enumtr = map.keys();
        while (enumtr.hasMoreElements()) {
            CacheKey cacheKey = (CacheKey)enumtr.nextElement();
            Object object = cacheKey.getObject();
            if (!businessClass.isInstance(object)) continue;
            ++cacheCounter;
            Object key = cacheKey.getKey();
            if (object == null) {
                writer.write(LoggingLocalization.buildMessage("key_object_null", new Object[]{cr, key, "\t"}));
                continue;
            }
            String hashCode = String.valueOf(System.identityHashCode(object));
            if (descriptor.usesOptimisticLocking() && descriptor.usesVersionLocking()) {
                Object writeLockValue = descriptor.getOptimisticLockingPolicy().getWriteLockValue(object, key, this.session);
                String version = (String)this.session.getPlatform().convertObject(writeLockValue, String.class);
                writer.write(LoggingLocalization.buildMessage("key_version_identity_hash_code_object", new Object[]{cr, key, "\t", hashCode, object, version}));
                continue;
            }
            writer.write(LoggingLocalization.buildMessage("key_identity_hash_code_object", new Object[]{cr, key, "\t", hashCode, object}));
        }
        writer.write(LoggingLocalization.buildMessage("elements", new Object[]{cr, String.valueOf(cacheCounter)}));
        this.session.log(7, "cache", writer.toString(), null, null, false);
    }

    public void printIdentityMaps() {
        for (Class businessClass : this.session.getDescriptors().keySet()) {
            ClassDescriptor descriptor = this.session.getDescriptor(businessClass);
            if (descriptor.hasInheritance()) {
                if (!descriptor.getInheritancePolicy().isRootParentDescriptor()) continue;
                this.printIdentityMap(businessClass);
                continue;
            }
            this.printIdentityMap(businessClass);
        }
    }

    public void printLocks() {
        StringWriter writer = new StringWriter();
        HashMap threadCollection = new HashMap();
        writer.write(String.valueOf(TraceLocalization.buildMessage("lock_writer_header", null)) + Helper.cr());
        for (IdentityMap idenityMap : this.session.getIdentityMapAccessorInstance().getIdentityMapManager().getIdentityMaps().values()) {
            idenityMap.collectLocks(threadCollection);
        }
        Object[] parameters = new Object[1];
        for (Thread activeThread : threadCollection.keySet()) {
            parameters[0] = activeThread.getName();
            writer.write(String.valueOf(TraceLocalization.buildMessage("active_thread", parameters)) + Helper.cr());
            for (CacheKey cacheKey : (HashSet)threadCollection.get(activeThread)) {
                if (cacheKey.isAcquired() && cacheKey.getMutex().getActiveThread() == activeThread) {
                    parameters[0] = cacheKey.getObject();
                    writer.write(String.valueOf(TraceLocalization.buildMessage("locked_object", parameters)) + Helper.cr());
                    writer.write("PK: " + cacheKey.getKey() + Helper.cr());
                    parameters[0] = new Integer(cacheKey.getMutex().getDepth());
                    writer.write(String.valueOf(TraceLocalization.buildMessage("depth", parameters)) + Helper.cr());
                    Exception stack = cacheKey.getMutex().getStack();
                    if (stack == null) continue;
                    stack.printStackTrace(new PrintWriter(writer));
                    continue;
                }
                writer.write(TraceLocalization.buildMessage("cachekey_released", new Object[0]));
                parameters[0] = cacheKey.getObject();
                writer.write(String.valueOf(TraceLocalization.buildMessage("locked_object", parameters)) + Helper.cr());
                writer.write("PK: " + cacheKey.getKey() + Helper.cr());
            }
            DeferredLockManager deferredLockManager = ConcurrencyManager.getDeferredLockManager(activeThread);
            if (deferredLockManager == null) continue;
            for (ConcurrencyManager lock : deferredLockManager.getDeferredLocks()) {
                parameters[0] = lock.getOwnerCacheKey().getObject();
                writer.write(String.valueOf(TraceLocalization.buildMessage("deferred_locks", parameters)) + Helper.cr());
            }
        }
        writer.write(String.valueOf(Helper.cr()) + TraceLocalization.buildMessage("lock_writer_footer", null) + Helper.cr());
        this.session.log(7, "cache", writer.toString(), null, null, false);
    }

    public void printLocks(Class theClass) {
        ClassDescriptor descriptor = this.session.getDescriptor(theClass);
        StringWriter writer = new StringWriter();
        HashMap threadCollection = new HashMap();
        writer.write(String.valueOf(TraceLocalization.buildMessage("lock_writer_header", null)) + Helper.cr());
        IdentityMap identityMap = this.getIdentityMap(descriptor, false);
        identityMap.collectLocks(threadCollection);
        Object[] parameters = new Object[1];
        for (Thread activeThread : threadCollection.keySet()) {
            parameters[0] = activeThread.getName();
            writer.write(String.valueOf(TraceLocalization.buildMessage("active_thread", parameters)) + Helper.cr());
            for (CacheKey cacheKey : (HashSet)threadCollection.get(activeThread)) {
                parameters[0] = cacheKey.getObject();
                writer.write(String.valueOf(TraceLocalization.buildMessage("locked_object", parameters)) + Helper.cr());
                parameters[0] = cacheKey.getMutex().getDepth();
                writer.write(String.valueOf(TraceLocalization.buildMessage("depth", parameters)) + Helper.cr());
            }
            DeferredLockManager deferredLockManager = ConcurrencyManager.getDeferredLockManager(activeThread);
            if (deferredLockManager == null) continue;
            for (ConcurrencyManager lock : deferredLockManager.getDeferredLocks()) {
                parameters[0] = lock.getOwnerCacheKey().getObject();
                writer.write(String.valueOf(TraceLocalization.buildMessage("deferred_locks", parameters)) + Helper.cr());
            }
        }
        writer.write(String.valueOf(Helper.cr()) + TraceLocalization.buildMessage("lock_writer_footer", null) + Helper.cr());
        this.session.log(7, "cache", writer.toString(), null, null, false);
    }

    public CacheKey putInIdentityMap(Object domainObject, Object keys, Object writeLockValue, long readTime, ClassDescriptor descriptor) {
        CacheKey cacheKey;
        if (keys == null) {
            return null;
        }
        ObjectBuilder builder = descriptor.getObjectBuilder();
        Object implementation = builder.unwrapObject(domainObject, this.session);
        IdentityMap map = this.getIdentityMap(descriptor, false);
        if (this.isCacheAccessPreCheckRequired) {
            this.session.startOperationProfile("Timer:Caching");
            this.acquireReadLock();
            try {
                cacheKey = map.put(keys, implementation, writeLockValue, readTime);
            }
            finally {
                this.releaseReadLock();
            }
            this.session.endOperationProfile("Timer:Caching");
        } else {
            cacheKey = map.put(keys, implementation, writeLockValue, readTime);
        }
        return cacheKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putQueryResult(ReadQuery query, List parameters, Object results) {
        IdentityMap map;
        if ((results == null || results == InvalidObject.instance()) && query.getQueryResultsCachePolicy().isNullIgnored()) {
            return;
        }
        Object queryKey = query.getName();
        if (queryKey == null || ((String)queryKey).length() == 0) {
            queryKey = query;
        }
        if ((map = this.queryResults.get(queryKey)) == null) {
            Map<Object, IdentityMap> map2 = this.queryResults;
            synchronized (map2) {
                map = this.queryResults.get(queryKey);
                if (map == null) {
                    map = this.buildNewIdentityMap(query.getQueryResultsCachePolicy().getCacheType(), query.getQueryResultsCachePolicy().getMaximumCachedResults(), null, false);
                    this.queryResults.put(queryKey, map);
                }
            }
        }
        CacheId lookupParameters = parameters == null ? new CacheId(new Object[0]) : new CacheId(parameters.toArray());
        long queryTime = 0L;
        if (query.isObjectLevelReadQuery()) {
            queryTime = ((ObjectLevelReadQuery)query).getExecutionTime();
        }
        if (queryTime == 0L) {
            queryTime = System.currentTimeMillis();
        }
        if (results == null) {
            results = InvalidObject.instance();
        }
        map.put(lookupParameters, results, null, queryTime);
    }

    protected void releaseReadLock() {
        if (this.session.getDatasourceLogin().shouldSynchronizedReadOnWrite()) {
            this.getCacheMutex().releaseReadLock();
        }
    }

    public void releaseWriteLock() {
        if (this.session.getDatasourceLogin().shouldSynchronizedReadOnWrite() || this.session.getDatasourceLogin().shouldSynchronizeWrites()) {
            this.getCacheMutex().release();
        }
    }

    public Object removeFromIdentityMap(Object key, Class domainClass, ClassDescriptor descriptor, Object objectToRemove) {
        Object value;
        if (key == null) {
            return null;
        }
        IdentityMap map = this.getIdentityMap(descriptor, false);
        if (this.isCacheAccessPreCheckRequired) {
            this.session.startOperationProfile("Timer:Caching");
            this.acquireReadLock();
            try {
                value = map.remove(key, objectToRemove);
            }
            finally {
                this.releaseReadLock();
            }
            this.session.endOperationProfile("Timer:Caching");
        } else {
            value = map.remove(key, objectToRemove);
        }
        return value;
    }

    protected void setCacheMutex(ConcurrencyManager cacheMutex) {
        this.cacheMutex = cacheMutex;
    }

    public void setIdentityMaps(ConcurrentMap identityMaps) {
        this.clearLastAccessedIdentityMap();
        this.identityMaps = identityMaps;
    }

    protected void setSession(AbstractSession session) {
        this.session = session;
    }

    public void setWrapper(Object primaryKey, Class theClass, Object wrapper) {
        ClassDescriptor descriptor = this.session.getDescriptor(theClass);
        IdentityMap map = this.getIdentityMap(descriptor, false);
        if (this.isCacheAccessPreCheckRequired) {
            this.session.startOperationProfile("Timer:Caching");
            this.acquireReadLock();
            try {
                map.setWrapper(primaryKey, wrapper);
            }
            finally {
                this.releaseReadLock();
            }
            this.session.endOperationProfile("Timer:Caching");
        } else {
            map.setWrapper(primaryKey, wrapper);
        }
    }

    public void setWriteLockValue(Object primaryKey, Class theClass, Object writeLockValue) {
        if (primaryKey == null) {
            return;
        }
        ClassDescriptor descriptor = this.session.getDescriptor(theClass);
        IdentityMap map = this.getIdentityMap(descriptor, false);
        if (this.isCacheAccessPreCheckRequired) {
            this.session.startOperationProfile("Timer:Caching");
            this.acquireReadLock();
            try {
                map.setWriteLockValue(primaryKey, writeLockValue);
            }
            finally {
                this.releaseReadLock();
            }
            this.session.endOperationProfile("Timer:Caching");
        } else {
            map.setWriteLockValue(primaryKey, writeLockValue);
        }
    }

    protected Object checkForInheritance(Object domainObject, Class superClass, ClassDescriptor descriptor) {
        if (domainObject != null && domainObject.getClass() != superClass && !superClass.isInstance(domainObject)) {
            if (descriptor.hasInheritance() && descriptor.getInheritancePolicy().getUseDescriptorsToValidateInheritedObjects()) {
                if (descriptor.getInheritancePolicy().getSubclassDescriptor(domainObject.getClass()) == null) {
                    return null;
                }
                return domainObject;
            }
            return null;
        }
        return domainObject;
    }
}

