/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.eis;

import java.util.List;
import java.util.Vector;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.DescriptorQueryManager;
import org.eclipse.persistence.descriptors.InheritancePolicy;
import org.eclipse.persistence.eis.mappings.EISCompositeObjectMapping;
import org.eclipse.persistence.eis.mappings.EISDirectMapping;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.exceptions.QueryException;
import org.eclipse.persistence.internal.databaseaccess.DatabaseCall;
import org.eclipse.persistence.internal.expressions.SQLStatement;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.DatabaseTable;
import org.eclipse.persistence.internal.oxm.QNameInheritancePolicy;
import org.eclipse.persistence.internal.oxm.XMLObjectBuilder;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.mappings.AggregateMapping;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.foundation.AbstractDirectMapping;
import org.eclipse.persistence.oxm.NamespaceResolver;
import org.eclipse.persistence.oxm.XMLField;
import org.eclipse.persistence.oxm.record.XMLRecord;
import org.eclipse.persistence.sessions.DatabaseRecord;

public class EISDescriptor
extends ClassDescriptor {
    protected String dataFormat;
    public static final String MAPPED = "mapped";
    public static final String INDEXED = "indexed";
    public static final String XML = "xml";
    protected NamespaceResolver namespaceResolver;

    public EISDescriptor() {
        this.shouldOrderMappings = false;
        this.dataFormat = XML;
    }

    protected void validateMappingType(DatabaseMapping mapping) {
        if (!mapping.isEISMapping()) {
            throw DescriptorException.invalidMappingType(mapping);
        }
    }

    public void setDataTypeName(String dataTypeName) throws DescriptorException {
        this.setTableName(dataTypeName);
    }

    public NamespaceResolver getNamespaceResolver() {
        return this.namespaceResolver;
    }

    public InheritancePolicy getInheritancePolicy() {
        if (this.inheritancePolicy == null) {
            if (this.getDataFormat() == XML) {
                this.setInheritancePolicy(new QNameInheritancePolicy(this));
            } else {
                this.setInheritancePolicy(new InheritancePolicy(this));
            }
        }
        return this.inheritancePolicy;
    }

    public void setNamespaceResolver(NamespaceResolver namespaceResolver) {
        this.namespaceResolver = namespaceResolver;
    }

    public void setQueryManager(DescriptorQueryManager queryManager) {
        this.queryManager = queryManager;
        if (queryManager != null) {
            queryManager.setDescriptor(this);
        }
    }

    public void preInitialize(AbstractSession session) {
        if (this.isInitialized(1)) {
            return;
        }
        if (this.dataFormat.equals(XML)) {
            this.setObjectBuilder(new XMLObjectBuilder(this));
            if (this.hasInheritance()) {
                ((QNameInheritancePolicy)this.getInheritancePolicy()).setNamespaceResolver(this.namespaceResolver);
            }
        }
        super.preInitialize(session);
    }

    public String getDataFormat() {
        return this.dataFormat;
    }

    public String getDataTypeName() throws DescriptorException {
        return this.getTableName();
    }

    public void setDataFormat(String dataFormat) {
        this.dataFormat = dataFormat;
    }

    public void useMappedRecordFormat() {
        this.setDataFormat(MAPPED);
    }

    public void useIndexedRecordFormat() {
        this.setDataFormat(INDEXED);
    }

    public void useXMLRecordFormat() {
        this.setDataFormat(XML);
    }

    public AbstractRecord buildNestedRowFromFieldValue(Object fieldValue) {
        if (!this.getDataFormat().equals(XML)) {
            if (!(fieldValue instanceof List)) {
                return new DatabaseRecord(1);
            }
            List nestedRows = (List)fieldValue;
            if (nestedRows.isEmpty()) {
                return new DatabaseRecord(1);
            }
            if (!(nestedRows.get(0) instanceof AbstractRecord)) {
                return new DatabaseRecord(1);
            }
            return (AbstractRecord)nestedRows.get(0);
        }
        if (fieldValue instanceof XMLRecord) {
            return (XMLRecord)fieldValue;
        }
        if (!(fieldValue instanceof Vector)) {
            return this.getObjectBuilder().createRecord(null);
        }
        Vector nestedRows = (Vector)fieldValue;
        if (nestedRows.isEmpty()) {
            return this.getObjectBuilder().createRecord(null);
        }
        if (!(nestedRows.firstElement() instanceof XMLRecord)) {
            return this.getObjectBuilder().createRecord(null);
        }
        return (XMLRecord)nestedRows.firstElement();
    }

    public Vector buildNestedRowsFromFieldValue(Object fieldValue, AbstractSession session) {
        if (!this.getDataFormat().equals(XML)) {
            if (!(fieldValue instanceof List)) {
                return new Vector();
            }
            return new Vector((List)fieldValue);
        }
        if (!(fieldValue instanceof Vector)) {
            return new Vector(0);
        }
        return (Vector)fieldValue;
    }

    public Vector buildDirectValuesFromFieldValue(Object fieldValue) {
        if (!this.getDataFormat().equals(XML)) {
            return super.buildDirectValuesFromFieldValue(fieldValue);
        }
        if (!(fieldValue instanceof Vector)) {
            Vector<Object> fieldValues = new Vector<Object>(1);
            fieldValues.add(fieldValue);
            return fieldValues;
        }
        return (Vector)fieldValue;
    }

    public Object buildFieldValueFromDirectValues(Vector directValues, String elementDataTypeName, AbstractSession session) {
        if (!this.getDataFormat().equals(XML)) {
            return super.buildFieldValueFromDirectValues(directValues, elementDataTypeName, session);
        }
        return directValues;
    }

    public Object buildFieldValueFromNestedRow(AbstractRecord nestedRow, AbstractSession session) throws DatabaseException {
        Vector<AbstractRecord> nestedRows = new Vector<AbstractRecord>(1);
        nestedRows.addElement(nestedRow);
        return this.buildFieldValueFromNestedRows(nestedRows, "", session);
    }

    public Object buildFieldValueFromNestedRows(Vector nestedRows, String structureName, AbstractSession session) throws DatabaseException {
        return nestedRows;
    }

    public DatabaseField buildField(String fieldName) {
        if (this.getDataFormat().equals(XML)) {
            XMLField xmlField = new XMLField(fieldName);
            xmlField.setNamespaceResolver(this.getNamespaceResolver());
            xmlField.initialize();
            return xmlField;
        }
        return super.buildField(fieldName);
    }

    public DatabaseField buildField(DatabaseField field) {
        if (this.getDataFormat().equals(XML)) {
            if (!(field instanceof XMLField)) {
                field = new XMLField(field.getName());
            }
            ((XMLField)field).setNamespaceResolver(this.getNamespaceResolver());
            ((XMLField)field).initialize();
        }
        return super.buildField(field);
    }

    public AbstractDirectMapping newDirectMapping() {
        return new EISDirectMapping();
    }

    public AggregateMapping newAggregateMapping() {
        return new EISCompositeObjectMapping();
    }

    public DatabaseMapping addDirectMapping(String attributeName, String fieldName) {
        EISDirectMapping mapping = new EISDirectMapping();
        mapping.setAttributeName(attributeName);
        if (this.getDataFormat() == XML) {
            mapping.setXPath(fieldName);
        } else {
            mapping.setFieldName(fieldName);
        }
        return this.addMapping(mapping);
    }

    public DatabaseMapping addDirectMapping(String attributeName, String getMethodName, String setMethodName, String fieldName) {
        EISDirectMapping mapping = new EISDirectMapping();
        mapping.setAttributeName(attributeName);
        mapping.setSetMethodName(setMethodName);
        mapping.setGetMethodName(getMethodName);
        if (this.getDataFormat() == XML) {
            mapping.setXPath(fieldName);
        } else {
            mapping.setFieldName(fieldName);
        }
        return this.addMapping(mapping);
    }

    public void addPrimaryKeyFieldName(String fieldName) {
        if (this.getDataFormat() == XML) {
            this.addPrimaryKeyField(new XMLField(fieldName));
        } else {
            super.addPrimaryKeyFieldName(fieldName);
        }
    }

    public void setSequenceNumberFieldName(String fieldName) {
        super.setSequenceNumberFieldName(fieldName);
    }

    public DatabaseCall buildCallFromStatement(SQLStatement statement, AbstractSession session) {
        throw QueryException.noCallOrInteractionSpecified();
    }

    public void initialize(AbstractSession session) throws DescriptorException {
        if (this.getDataFormat().equals(XML)) {
            int x = 0;
            int primaryKeyFieldsSize = this.primaryKeyFields.size();
            while (x < primaryKeyFieldsSize) {
                XMLField pkField = (XMLField)this.primaryKeyFields.get(x);
                pkField.setNamespaceResolver(this.namespaceResolver);
                pkField.initialize();
                ++x;
            }
        }
        super.initialize(session);
    }

    public void initializeAggregateInheritancePolicy(AbstractSession session) {
    }

    public boolean requiresInitialization() {
        return !this.isDescriptorForInterface();
    }

    protected DatabaseTable extractDefaultTable() {
        if (this.isAggregateDescriptor()) {
            return new DatabaseTable();
        }
        return super.extractDefaultTable();
    }

    public boolean isReturnTypeRequiredForReturningPolicy() {
        return false;
    }

    public boolean shouldUseFullChangeSetsForNewObjects() {
        return true;
    }
}

