/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.db.sdo;

import com.sun.xml.ws.db.sdo.SAX2StaxContentHandler;
import com.sun.xml.ws.db.sdo.SDOAttachmentMarshaller;
import com.sun.xml.ws.db.sdo.SDOAttachmentUnmarshaller;
import com.sun.xml.ws.db.sdo.SDOContextWrapper;
import com.sun.xml.ws.db.sdo.SDODatabindingException;
import com.sun.xml.ws.db.sdo.SDOUtils;
import com.sun.xml.ws.spi.db.BindingContext;
import com.sun.xml.ws.spi.db.TypeInfo;
import com.sun.xml.ws.spi.db.XMLBridge;
import com.sun.xml.ws.util.xml.StAXSource;
import commonj.sdo.DataObject;
import commonj.sdo.Type;
import commonj.sdo.helper.DataFactory;
import commonj.sdo.helper.HelperContext;
import commonj.sdo.helper.XMLDocument;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXBException;
import javax.xml.bind.attachment.AttachmentMarshaller;
import javax.xml.bind.attachment.AttachmentUnmarshaller;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.eclipse.persistence.sdo.helper.SDODataHelper;
import org.eclipse.persistence.sdo.helper.SDOXMLHelper;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.ContentHandler;

public class SDOBond<T>
implements XMLBridge<T> {
    private static final String CLASSNAME = SDOBond.class.getName();
    private static final Logger logger = Logger.getLogger(CLASSNAME);
    private TypeInfo ti;
    private QName xmlTag = null;
    private Class<T> javaType = null;
    private Type theType = null;
    private SDOContextWrapper parent;

    public SDOBond(SDOContextWrapper parent, TypeInfo ti) {
        this.parent = parent;
        this.ti = ti;
        this.javaType = (Class)ti.type;
        this.xmlTag = ti.tagName;
        HelperContext context = parent.getHelperContext();
        this.theType = context.getTypeHelper().getType(this.javaType);
    }

    public SDOBond(Class<T> type, QName xml) {
        logger.entering("SDOBond", "constructor");
        this.javaType = type;
        this.xmlTag = xml;
        HelperContext context = this.parent.getHelperContext();
        this.theType = context.getTypeHelper().getType(this.javaType);
    }

    public QName getXmlTag() {
        return this.xmlTag;
    }

    public Class<T> getJavaType() {
        return this.javaType;
    }

    private T deserialize(Source src, AttachmentUnmarshaller au) {
        try {
            HelperContext context = this.parent.getHelperContext();
            SDOAttachmentUnmarshaller unmarshaller = null;
            if (au != null) {
                unmarshaller = new SDOAttachmentUnmarshaller(au);
            }
            DataFactory dataFactory = context.getDataFactory();
            DataObject loadOptions = dataFactory.create("org.eclipse.persistence.sdo", "LoadOptions");
            loadOptions.set("type", (Object)this.theType);
            if (unmarshaller != null) {
                loadOptions.set("attachmentUnmarshaller", (Object)unmarshaller);
            }
            XMLDocument xdoc = context.getXMLHelper().load(src, null, (Object)loadOptions);
            DataObject obj = xdoc.getRootObject();
            Object o = SDOUtils.unwrapPrimitives(obj);
            return (T)o;
        }
        catch (Exception e) {
            throw new SDODatabindingException(e);
        }
    }

    private String serializePrimitive(Object obj, Class<?> contentClass) {
        HelperContext context;
        Type type;
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("Primitive class to be serialized ==> " + contentClass);
        }
        if ((type = (context = this.parent.getHelperContext()).getTypeHelper().getType(contentClass)) != null) {
            return ((SDODataHelper)context.getDataHelper()).convertToStringValue(obj, type);
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Invalid SDO primitive type: " + contentClass.getClass().getName());
        }
        throw new SDODatabindingException("Invalid SDO primitive type: " + contentClass.getClass().getName());
    }

    private void serializeToResult(String value, Result result) {
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document doc = db.newDocument();
            Element elt = doc.createElementNS(this.xmlTag.getNamespaceURI(), "ns1:" + this.xmlTag.getLocalPart());
            doc.appendChild(elt);
            elt.appendChild(doc.createTextNode(value));
            DOMSource ds = new DOMSource(elt);
            TransformerFactory tf = TransformerFactory.newInstance();
            Transformer t = tf.newTransformer();
            t.transform(ds, result);
        }
        catch (Exception e) {
            throw new SDODatabindingException(e.getMessage());
        }
    }

    public BindingContext context() {
        return this.parent;
    }

    private void serializeDataObject(DataObject java, Result result, AttachmentMarshaller am) {
        logger.entering(CLASSNAME, "serializeDataObject");
        try {
            HelperContext context = this.parent.getHelperContext();
            SDOAttachmentMarshaller marshaller = null;
            if (am != null) {
                marshaller = new SDOAttachmentMarshaller(am);
            }
            SDOXMLHelper sdoXMLHelper = (SDOXMLHelper)context.getXMLHelper();
            sdoXMLHelper.setTimeZoneQualified(true);
            XMLDocument xmlDoc = sdoXMLHelper.createDocument(java, this.xmlTag.getNamespaceURI(), this.xmlTag.getLocalPart());
            if (xmlDoc == null) {
                return;
            }
            xmlDoc.setXMLDeclaration(false);
            DataObject saveOptions = null;
            if (marshaller != null) {
                DataFactory dataFactory = this.parent.getHelperContext().getDataFactory();
                saveOptions = dataFactory.create("org.eclipse.persistence.sdo", "LoadOptions");
                saveOptions.set("attachmentMarshaller", (Object)marshaller);
            }
            sdoXMLHelper.save(xmlDoc, result, saveOptions);
        }
        catch (Exception e) {
            throw new SDODatabindingException(e);
        }
    }

    public void marshal(T object, XMLStreamWriter output, AttachmentMarshaller am) throws JAXBException {
        try {
            output.flush();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        SAX2StaxContentHandler handler = new SAX2StaxContentHandler(output);
        if (object instanceof DataObject) {
            this.serializeDataObject((DataObject)object, new SAXResult(handler), am);
            return;
        }
        try {
            String value = this.serializePrimitive(object, this.javaType);
            String prefix = output.getPrefix(this.xmlTag.getNamespaceURI());
            if (this.xmlTag.getNamespaceURI().equals("")) {
                output.writeStartElement("", this.xmlTag.getLocalPart(), this.xmlTag.getNamespaceURI());
            } else if (prefix == null) {
                output.writeStartElement(this.xmlTag.getNamespaceURI(), this.xmlTag.getLocalPart());
            } else {
                output.writeStartElement(prefix, this.xmlTag.getLocalPart(), this.xmlTag.getNamespaceURI());
            }
            output.writeCharacters(value);
            output.writeEndElement();
        }
        catch (XMLStreamException e) {
            throw new SDODatabindingException(e);
        }
    }

    public void marshal(T object, OutputStream output, NamespaceContext nsContext, AttachmentMarshaller am) throws JAXBException {
        if (object instanceof DataObject) {
            this.serializeDataObject((DataObject)object, new StreamResult(output), am);
            return;
        }
        try {
            String value = this.serializePrimitive(object, this.javaType);
            String prefix = nsContext.getPrefix(this.xmlTag.getNamespaceURI());
            StringBuilder sb = new StringBuilder();
            if ("".equals(prefix)) {
                sb.append("<").append(this.xmlTag.getLocalPart()).append(">");
                sb.append(value);
                sb.append("</").append(this.xmlTag.getLocalPart()).append(">");
            } else if (prefix != null) {
                sb.append("<").append(prefix).append(":").append(this.xmlTag.getLocalPart()).append(">");
                sb.append(value);
                sb.append("</").append(prefix).append(":").append(this.xmlTag.getLocalPart()).append(">");
            } else {
                prefix = "ns1";
                sb.append("<ns1:").append(this.xmlTag.getLocalPart()).append(" xmlns:ns1=\"").append(this.xmlTag.getNamespaceURI()).append("\"").append(">");
                sb.append(value);
                sb.append("</ns1:").append(this.xmlTag.getLocalPart()).append(">");
            }
        }
        catch (Exception e) {
            throw new SDODatabindingException(e);
        }
    }

    public void marshal(T object, Node output) throws JAXBException {
        DOMResult res = new DOMResult(output);
        if (object instanceof DataObject) {
            this.serializeDataObject((DataObject)object, res, null);
            return;
        }
        String value = this.serializePrimitive(object, this.javaType);
        this.serializeToResult(value, res);
    }

    public void marshal(T object, ContentHandler contentHandler, AttachmentMarshaller am) throws JAXBException {
        SAXResult res = new SAXResult(contentHandler);
        if (object instanceof DataObject) {
            this.serializeDataObject((DataObject)object, res, null);
            return;
        }
        String value = this.serializePrimitive(object, this.javaType);
        this.serializeToResult(value, res);
    }

    public void marshal(T object, Result result) throws JAXBException {
        if (object instanceof DataObject) {
            this.serializeDataObject((DataObject)object, result, null);
            return;
        }
        String value = this.serializePrimitive(object, this.javaType);
        this.serializeToResult(value, result);
    }

    public T unmarshal(XMLStreamReader in, AttachmentUnmarshaller au) throws JAXBException {
        return this.deserialize((Source)new StAXSource(in, false), au);
    }

    public T unmarshal(Source in, AttachmentUnmarshaller au) throws JAXBException {
        return this.deserialize(in, au);
    }

    public T unmarshal(InputStream in) throws JAXBException {
        return this.deserialize(new StreamSource(in), null);
    }

    public T unmarshal(Node n, AttachmentUnmarshaller au) throws JAXBException {
        return this.deserialize(new DOMSource(n), au);
    }

    public TypeInfo getTypeInfo() {
        return this.ti;
    }

    public boolean supportOutputStream() {
        return true;
    }

    private String getExceptionStackTrace(Throwable t) {
        StringWriter sw = new StringWriter();
        t.printStackTrace(new PrintWriter(sw));
        return sw.toString();
    }
}

