/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.jxc.maven2;

import com.sun.tools.jxc.maven2.Schema;
import com.sun.tools.jxc.maven2.SchemaGenAdapter;
import java.io.File;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DefaultArtifact;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.apache.tools.ant.types.Path;

public class SchemaGenMojo
extends AbstractMojo {
    protected File srcdir;
    protected File destdir;
    protected String[] includes;
    protected String[] excludes;
    private final String JAXB_API_JAR_IDENTIFIER = "javax.xml.bind:jaxb-api";
    private List pluginArtifacts;
    protected boolean verbose;
    private Schema[] schemas;
    protected MavenProject project;

    public void execute() throws MojoExecutionException {
        if (this.verbose) {
            this.logSettings();
        }
        if (this.destdir != null && !this.destdir.exists()) {
            this.destdir.mkdirs();
        }
        SchemaGenAdapter schemaGenAdapter = new SchemaGenAdapter(this.getLog());
        if (this.destdir != null) {
            schemaGenAdapter.setDestdir(this.destdir);
        }
        schemaGenAdapter.setSrcdir(this.srcdir);
        if (this.project != null) {
            this.project.addCompileSourceRoot(this.destdir.getPath());
        }
        schemaGenAdapter.setIncludeExclude(this.includes, this.excludes);
        this.addSchemaGenClasspath(schemaGenAdapter);
        this.addUserDefinedJars(schemaGenAdapter);
        schemaGenAdapter.addSchemas(this.schemas);
        schemaGenAdapter.execute();
    }

    private void addSchemaGenClasspath(SchemaGenAdapter schemaGenAdapter) throws MojoExecutionException {
        for (DefaultArtifact df : this.pluginArtifacts) {
            String tmpName = df.getGroupId() + ":" + df.getArtifactId();
            if (!tmpName.equals("javax.xml.bind:jaxb-api")) continue;
            String tmpS = df.getFile().getAbsolutePath();
            this.getLog().info((CharSequence)("jaxb-schemagen classpath addition: " + tmpS));
            schemaGenAdapter.setClasspath(new Path(schemaGenAdapter.getProject(), tmpS));
            return;
        }
        this.getLog().info((CharSequence)"jaxb-api.jar reference not found in maven-jaxb-schemagen-plugin artifacts");
        throw new MojoExecutionException("jaxb-api.jar is required and was not found.");
    }

    private void addUserDefinedJars(SchemaGenAdapter schemaGenAdapter) {
        for (Artifact df : this.project.getArtifacts()) {
            if (df.getFile() == null) continue;
            this.getLog().info((CharSequence)("jaxb-schemagen classpath addition: " + df.getFile().getAbsolutePath()));
            schemaGenAdapter.setClasspath(new Path(schemaGenAdapter.getProject(), df.getFile().getAbsolutePath()));
        }
    }

    private void checkArtifacts() {
        Set tmpS = this.project.getArtifacts();
        Set tmpP = this.project.getPluginArtifacts();
        Set tmpDa = this.project.getDependencyArtifacts();
        Set tmpEx = this.project.getExtensionArtifacts();
        for (DefaultArtifact df : tmpS) {
            System.out.println("checkArtifacts: tmpS: " + df);
        }
        for (DefaultArtifact df : tmpP) {
            System.out.println("checkArtifacts: tmpP: " + df);
        }
        for (DefaultArtifact df : tmpDa) {
            System.out.println("checkArtifacts: tmpDa: " + df.getFile().toString());
        }
        for (DefaultArtifact df : tmpEx) {
            System.out.println("checkArtifacts: tmpEx: " + df);
        }
        try {
            List tmpRt = this.project.getRuntimeClasspathElements();
            Iterator itl = tmpRt.iterator();
            while (itl.hasNext()) {
                System.out.println("checkArtifacts: tmpRt: " + (String)itl.next());
            }
        }
        catch (DependencyResolutionRequiredException e) {
            System.out.println("checkArtifacts: tmpRt: " + (Object)((Object)e));
        }
    }

    private void logSettings() {
        this.getLog().info((CharSequence)("srcdir: " + this.srcdir));
        this.getLog().info((CharSequence)("destdir: " + this.destdir));
        if (this.includes != null) {
            for (String string : this.includes) {
                this.getLog().info((CharSequence)("include: " + (String)string));
            }
        }
        if (this.excludes != null) {
            for (String string : this.excludes) {
                this.getLog().info((CharSequence)("exclude: " + (String)string));
            }
        }
        if (this.schemas != null) {
            for (Schema schema : this.schemas) {
                this.getLog().info((CharSequence)("schema: " + schema));
            }
        }
    }
}

