/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.server.impl.model.method;

import com.sun.jersey.api.model.AbstractResourceMethod;
import com.sun.jersey.api.uri.UriTemplate;
import com.sun.jersey.impl.ImplMessages;
import com.sun.jersey.server.impl.application.ResourceMethodDispatcherFactory;
import com.sun.jersey.server.impl.container.filter.FilterFactory;
import com.sun.jersey.server.impl.model.method.ResourceMethod;
import com.sun.jersey.spi.container.ResourceFilter;
import com.sun.jersey.spi.inject.Errors;
import java.lang.reflect.Method;
import java.util.List;

public final class ResourceHttpMethod
extends ResourceMethod {
    private final AbstractResourceMethod arm;

    public ResourceHttpMethod(ResourceMethodDispatcherFactory df, FilterFactory ff, AbstractResourceMethod arm) {
        this(df, ff, UriTemplate.EMPTY, arm);
    }

    public ResourceHttpMethod(ResourceMethodDispatcherFactory df, FilterFactory ff, UriTemplate template, AbstractResourceMethod arm) {
        this(df, ff, ff.getResourceFilters(arm), template, arm);
    }

    public ResourceHttpMethod(ResourceMethodDispatcherFactory df, FilterFactory ff, List<ResourceFilter> resourceFilters, UriTemplate template, AbstractResourceMethod arm) {
        super(arm.getHttpMethod(), template, arm.getSupportedInputTypes(), arm.getSupportedOutputTypes(), arm.areOutputTypesDeclared(), df.getDispatcher(arm), FilterFactory.getRequestFilters(resourceFilters), FilterFactory.getResponseFilters(resourceFilters));
        this.arm = arm;
        if (this.getDispatcher() == null) {
            Method m = arm.getMethod();
            String msg = ImplMessages.NOT_VALID_HTTPMETHOD((Object)m, (Object)arm.getHttpMethod(), m.getDeclaringClass());
            Errors.error((String)msg);
        }
    }

    @Override
    public AbstractResourceMethod getAbstractResourceMethod() {
        return this.arm;
    }

    public String toString() {
        Method m = this.arm.getMethod();
        return ImplMessages.RESOURCE_METHOD(m.getDeclaringClass(), (Object)m.getName());
    }
}

