/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.util;

import com.sun.faces.io.FastStringWriter;
import com.sun.faces.renderkit.RenderKitUtils;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.el.ValueExpression;
import javax.faces.component.UIComponent;
import javax.faces.component.UISelectOne;
import javax.faces.component.ValueHolder;
import javax.faces.context.FacesContext;
import javax.faces.model.SelectItem;

public class DebugUtil {
    private static boolean keepWaiting = true;
    private static int curDepth = 0;

    public DebugUtil() {
        this.init();
    }

    protected void init() {
    }

    public static void setKeepWaiting(boolean keepWaiting) {
        DebugUtil.keepWaiting = keepWaiting;
    }

    public static void waitForDebugger() {
        while (keepWaiting) {
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException e) {
                System.out.println("DebugUtil.waitForDebugger(): Exception: " + e.getMessage());
            }
        }
    }

    private static void indentPrintln(Writer out, String str) {
        try {
            for (int i = 0; i < curDepth; ++i) {
                out.write("  ");
            }
            out.write(str + "\n");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static String printTree(UIComponent root) {
        FastStringWriter writer = new FastStringWriter(1024);
        DebugUtil.printTree(root, (Writer)writer);
        return ((Object)writer).toString();
    }

    public static void printTree(UIComponent root, PrintStream out) {
        PrintWriter writer = new PrintWriter(out);
        DebugUtil.printTree(root, (Writer)writer);
        writer.flush();
    }

    public static void printTree(UIComponent root, Logger logger, Level level) {
        StringWriter sw = new StringWriter();
        DebugUtil.printTree(root, (Writer)sw);
        logger.log(level, sw.toString());
    }

    public static void printTree(UIComponent root, Writer out) {
        if (null == root) {
            return;
        }
        Object value = null;
        DebugUtil.indentPrintln(out, "id:" + root.getId());
        DebugUtil.indentPrintln(out, "type:" + root.getClass().getName());
        if (root instanceof UISelectOne) {
            Iterator<SelectItem> items = null;
            try {
                items = RenderKitUtils.getSelectItems(FacesContext.getCurrentInstance(), root);
            }
            catch (Exception e) {
                DebugUtil.indentPrintln(out, " { SelectItem(s) not resolvable at this point in time }");
            }
            if (items != null) {
                DebugUtil.indentPrintln(out, " {");
                while (items.hasNext()) {
                    SelectItem curItem = items.next();
                    DebugUtil.indentPrintln(out, "\t value = " + curItem.getValue() + ", label = " + curItem.getLabel() + ", description = " + curItem.getDescription());
                }
                DebugUtil.indentPrintln(out, " }");
            }
        } else {
            ValueExpression ve = null;
            if (root instanceof ValueHolder) {
                ve = root.getValueExpression("value");
                try {
                    value = ((ValueHolder)root).getValue();
                }
                catch (Exception e) {
                    value = "UNAVAILABLE";
                }
            }
            if (ve != null) {
                DebugUtil.indentPrintln(out, "expression/value = " + ve.getExpressionString() + " : " + value);
            } else {
                DebugUtil.indentPrintln(out, "value = " + value);
            }
            Iterator it = root.getAttributes().keySet().iterator();
            if (it != null) {
                while (it.hasNext()) {
                    String val;
                    String attrName = (String)it.next();
                    ve = root.getValueExpression(attrName);
                    String expr = null;
                    if (ve != null) {
                        expr = ve.getExpressionString();
                    }
                    try {
                        val = root.getAttributes().get(attrName).toString();
                    }
                    catch (Exception e) {
                        val = "UNAVAILABLE";
                    }
                    if (expr != null) {
                        DebugUtil.indentPrintln(out, "attr = " + attrName + " : [" + expr + " : " + val + " ]");
                        continue;
                    }
                    DebugUtil.indentPrintln(out, "attr = " + attrName + " : " + val);
                }
            }
        }
        ++curDepth;
        Iterator it = root.getChildren().iterator();
        for (UIComponent uiComponent : root.getFacets().values()) {
            DebugUtil.printTree(uiComponent, out);
        }
        while (it.hasNext()) {
            DebugUtil.printTree((UIComponent)it.next(), out);
        }
        --curDepth;
    }

    public static void simplePrintTree(UIComponent root, String duplicateId, Writer out) {
        if (null == root) {
            return;
        }
        if (duplicateId.equals(root.getId())) {
            DebugUtil.indentPrintln(out, "+id: " + root.getId() + "  <===============");
        } else {
            DebugUtil.indentPrintln(out, "+id: " + root.getId());
        }
        DebugUtil.indentPrintln(out, " type: " + root.toString());
        ++curDepth;
        for (UIComponent uiComponent : root.getFacets().values()) {
            DebugUtil.simplePrintTree(uiComponent, duplicateId, out);
        }
        for (UIComponent uiComponent : root.getChildren()) {
            DebugUtil.simplePrintTree(uiComponent, duplicateId, out);
        }
        --curDepth;
    }

    public static void printTree(Object[] root, Writer out) {
        if (null == root) {
            DebugUtil.indentPrintln(out, "null");
            return;
        }
        boolean foundBottom = false;
        Object[] myState = root;
        while (!foundBottom) {
            Object state = myState[0];
            foundBottom = !state.getClass().isArray();
            if (foundBottom) continue;
            myState = (Object[])state;
        }
        DebugUtil.indentPrintln(out, "type:" + myState[8]);
        ++curDepth;
        root = (Object[])root[1];
        for (int i = 0; i < root.length; ++i) {
            DebugUtil.printTree((Object[])root[i], out);
        }
        --curDepth;
    }
}

