/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.network.protocol.http.command;

import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.serialization.serializer.OStringSerializerHelper;
import com.orientechnologies.orient.server.OServer;
import com.orientechnologies.orient.server.network.protocol.http.OHttpRequest;
import com.orientechnologies.orient.server.network.protocol.http.OHttpRequestException;
import com.orientechnologies.orient.server.network.protocol.http.OHttpResponse;
import com.orientechnologies.orient.server.network.protocol.http.command.OServerCommand;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.List;

public abstract class OServerCommandAbstract
implements OServerCommand {
    protected OServer server;

    @Override
    public boolean beforeExecute(OHttpRequest iRequest, OHttpResponse iResponse) throws IOException {
        this.setNoCache(iResponse);
        return true;
    }

    @Override
    public boolean afterExecute(OHttpRequest iRequest, OHttpResponse iResponse) throws IOException {
        return true;
    }

    protected String[] checkSyntax(String iURL, int iArgumentCount, String iSyntax) {
        List parts = OStringSerializerHelper.smartSplit((String)iURL, (char[])OHttpResponse.URL_SEPARATOR, (int)1, (int)-1, (boolean)true, (boolean)true, (boolean)false, (boolean)false, (char[])new char[0]);
        try {
            for (int i = 0; i < parts.size(); ++i) {
                parts.set(i, URLDecoder.decode((String)parts.get(i), "UTF-8"));
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new OHttpRequestException(e);
        }
        if (parts.size() < iArgumentCount) {
            throw new OHttpRequestException(iSyntax);
        }
        return parts.toArray(new String[parts.size()]);
    }

    public OServer getServer() {
        return this.server;
    }

    @Override
    public void configure(OServer server) {
        this.server = server;
    }

    protected void setNoCache(OHttpResponse iResponse) {
        iResponse.setHeader("Cache-Control: no-cache, no-store, max-age=0, must-revalidate\r\nPragma: no-cache");
    }

    protected boolean isJsonResponse(OHttpResponse response) {
        return response.jsonErrorResponse;
    }

    protected void sendJsonError(OHttpResponse iResponse, int iCode, String iReason, String iContentType, Object iContent, String iHeaders) throws IOException {
        ODocument response = new ODocument();
        ODocument error = new ODocument();
        error.field("code", (Object)iCode);
        error.field("reason", (Object)iReason);
        error.field("content", iContent);
        ArrayList<ODocument> errors = new ArrayList<ODocument>();
        errors.add(error);
        response.field("errors", errors);
        iResponse.send(iCode, iReason, "application/json", response.toJSON("prettyPrint"), iHeaders);
    }
}

