/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.lucene.shape;

import com.orientechnologies.lucene.shape.OPointShapeFactory;
import com.orientechnologies.lucene.shape.OPolygonShapeFactory;
import com.orientechnologies.lucene.shape.ORectangleShapeFactory;
import com.orientechnologies.lucene.shape.OShapeFactory;
import com.orientechnologies.orient.core.index.OCompositeKey;
import com.spatial4j.core.context.SpatialContext;
import com.spatial4j.core.shape.Point;
import com.spatial4j.core.shape.Rectangle;
import com.spatial4j.core.shape.Shape;
import java.util.HashMap;
import java.util.Map;

public class OShapeFactoryImpl
implements OShapeFactory {
    private Map<Class<? extends Shape>, OShapeFactory> factories = new HashMap<Class<? extends Shape>, OShapeFactory>();
    public static OShapeFactoryImpl INSTANCE = new OShapeFactoryImpl();

    protected OShapeFactoryImpl() {
        this.registerFactory(Point.class, new OPointShapeFactory());
        this.registerFactory(Rectangle.class, new ORectangleShapeFactory());
        this.registerFactory(Shape.class, new OPolygonShapeFactory());
    }

    @Override
    public Shape makeShape(OCompositeKey key, SpatialContext ctx) {
        for (OShapeFactory f : this.factories.values()) {
            if (!f.canHandle(key)) continue;
            return f.makeShape(key, ctx);
        }
        return null;
    }

    @Override
    public boolean canHandle(OCompositeKey key) {
        return false;
    }

    public void registerFactory(Class<? extends Shape> clazz, OShapeFactory factory) {
        this.factories.put(clazz, factory);
    }
}

