/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.lucene.operator;

import com.orientechnologies.lucene.collections.OFullTextCompositeKey;
import com.orientechnologies.lucene.index.OLuceneFullTextIndex;
import com.orientechnologies.lucene.operator.OLuceneOperatorUtil;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.ODatabase;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.index.OIndexCursor;
import com.orientechnologies.orient.core.index.OIndexCursorCollectionValue;
import com.orientechnologies.orient.core.index.OIndexCursorSingleValue;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.OIndexSearchResult;
import com.orientechnologies.orient.core.sql.filter.OSQLFilterCondition;
import com.orientechnologies.orient.core.sql.filter.OSQLFilterItemField;
import com.orientechnologies.orient.core.sql.operator.OIndexReuseType;
import com.orientechnologies.orient.core.sql.operator.OQueryTargetOperator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.memory.MemoryIndex;
import org.apache.lucene.search.Query;

public class OLuceneTextOperator
extends OQueryTargetOperator {
    public OLuceneTextOperator() {
        this("LUCENE", 5, false);
    }

    public OLuceneTextOperator(String iKeyword, int iPrecedence, boolean iLogical) {
        super(iKeyword, iPrecedence, iLogical);
    }

    public OIndexCursor executeIndexQuery(OCommandContext iContext, OIndex<?> index, List<Object> keyParams, boolean ascSortOrder) {
        Object indexResult = index.get((Object)new OFullTextCompositeKey(keyParams).setContext(iContext));
        Object cursor = indexResult == null || indexResult instanceof OIdentifiable ? new OIndexCursorSingleValue((OIdentifiable)indexResult, (Object)new OFullTextCompositeKey(keyParams)) : new OIndexCursorCollectionValue(((Collection)indexResult).iterator(), (Object)new OFullTextCompositeKey(keyParams));
        iContext.setVariable("$luceneIndex", (Object)true);
        return cursor;
    }

    public OIndexReuseType getIndexReuseType(Object iLeft, Object iRight) {
        return OIndexReuseType.INDEX_OPERATOR;
    }

    public ORID getBeginRidRange(Object iLeft, Object iRight) {
        return null;
    }

    public ORID getEndRidRange(Object iLeft, Object iRight) {
        return null;
    }

    public OIndexSearchResult getOIndexSearchResult(OClass iSchemaClass, OSQLFilterCondition iCondition, List<OIndexSearchResult> iIndexSearchResults, OCommandContext context) {
        return OLuceneOperatorUtil.buildOIndexSearchResult(iSchemaClass, iCondition, iIndexSearchResults, context);
    }

    public Collection<OIdentifiable> filterRecords(ODatabase<?> iRecord, List<String> iTargetClasses, OSQLFilterCondition iCondition, Object iLeft, Object iRight) {
        return null;
    }

    public Object evaluateRecord(OIdentifiable iRecord, ODocument iCurrentResult, OSQLFilterCondition iCondition, Object iLeft, Object iRight, OCommandContext iContext) {
        OLuceneFullTextIndex index = this.involvedIndex(iRecord, iCurrentResult, iCondition, iLeft, iRight);
        if (index == null) {
            throw new OCommandExecutionException("Cannot evaluate lucene condition without index configuration.");
        }
        MemoryIndex memoryIndex = (MemoryIndex)iContext.getVariable("_memoryIndex");
        if (memoryIndex == null) {
            memoryIndex = new MemoryIndex();
            iContext.setVariable("_memoryIndex", (Object)memoryIndex);
        }
        memoryIndex.reset();
        Document doc = index.buildDocument(iLeft);
        for (IndexableField field : doc.getFields()) {
            memoryIndex.addField(field.name(), field.stringValue(), index.analyzer(field.name()));
        }
        Query query = null;
        try {
            query = index.buildQuery(iRight);
        }
        catch (Exception e) {
            throw new OCommandExecutionException("Error executing lucene query.", (Throwable)e);
        }
        return memoryIndex.search(query) > 0.0f;
    }

    protected OLuceneFullTextIndex involvedIndex(OIdentifiable iRecord, ODocument iCurrentResult, OSQLFilterCondition iCondition, Object iLeft, Object iRight) {
        Object left = iCondition.getLeft();
        ODocument doc = (ODocument)iRecord.getRecord();
        OClass cls = OLuceneTextOperator.getDatabase().getMetadata().getSchema().getClass(doc.getClassName());
        if (this.isChained(iCondition.getLeft())) {
            OSQLFilterItemField chained = (OSQLFilterItemField)left;
            OSQLFilterItemField.FieldChain fieldChain = chained.getFieldChain();
            OClass oClass = cls;
            for (int i = 0; i < fieldChain.getItemCount() - 1; ++i) {
                oClass = oClass.getProperty(fieldChain.getItemName(i)).getLinkedClass();
            }
            if (oClass != null) {
                cls = oClass;
            }
        }
        Set classInvolvedIndexes = cls.getInvolvedIndexes(this.fields(iCondition));
        OLuceneFullTextIndex idx = null;
        for (OIndex classInvolvedIndex : classInvolvedIndexes) {
            if (!(classInvolvedIndex.getInternal() instanceof OLuceneFullTextIndex)) continue;
            idx = (OLuceneFullTextIndex)classInvolvedIndex.getInternal();
            break;
        }
        return idx;
    }

    private boolean isChained(Object left) {
        if (left instanceof OSQLFilterItemField) {
            OSQLFilterItemField field = (OSQLFilterItemField)left;
            return field.isFieldChain();
        }
        return false;
    }

    protected static ODatabaseDocumentInternal getDatabase() {
        return ODatabaseRecordThreadLocal.INSTANCE.get();
    }

    protected Collection<String> fields(OSQLFilterCondition iCondition) {
        Object left = iCondition.getLeft();
        if (left instanceof String) {
            String fName = (String)left;
            return Arrays.asList(fName);
        }
        if (left instanceof Collection) {
            Collection f = (Collection)left;
            ArrayList<String> fields = new ArrayList<String>();
            for (OSQLFilterItemField field : f) {
                fields.add(field.toString());
            }
            return fields;
        }
        if (left instanceof OSQLFilterItemField) {
            OSQLFilterItemField fName = (OSQLFilterItemField)left;
            if (fName.isFieldChain()) {
                int itemCount = fName.getFieldChain().getItemCount();
                return Arrays.asList(fName.getFieldChain().getItemName(itemCount - 1));
            }
            return Arrays.asList(fName.toString());
        }
        return Collections.emptyList();
    }
}

