/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.lucene.hook;

import com.orientechnologies.lucene.OLuceneIndex;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.db.record.OMultiValueChangeEvent;
import com.orientechnologies.orient.core.db.record.OMultiValueChangeTimeLine;
import com.orientechnologies.orient.core.db.record.ORecordElement;
import com.orientechnologies.orient.core.db.record.OTrackedMultiValue;
import com.orientechnologies.orient.core.exception.OConcurrentModificationException;
import com.orientechnologies.orient.core.exception.OFastConcurrentModificationException;
import com.orientechnologies.orient.core.exception.ORecordNotFoundException;
import com.orientechnologies.orient.core.hook.ODocumentHookAbstract;
import com.orientechnologies.orient.core.hook.ORecordHook;
import com.orientechnologies.orient.core.index.OCompositeIndexDefinition;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.index.OIndexDefinition;
import com.orientechnologies.orient.core.index.OIndexDefinitionMultiValue;
import com.orientechnologies.orient.core.index.OIndexException;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.version.ORecordVersion;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class OLuceneClassIndexManager
extends ODocumentHookAbstract {
    public ORecordHook.DISTRIBUTED_EXECUTION_MODE getDistributedExecutionMode() {
        return ORecordHook.DISTRIBUTED_EXECUTION_MODE.TARGET_NODE;
    }

    public ORecordHook.RESULT onRecordBeforeCreate(ODocument iDocument) {
        this.checkIndexes(iDocument, ORecordHook.TYPE.BEFORE_CREATE);
        return ORecordHook.RESULT.RECORD_NOT_CHANGED;
    }

    public void onRecordAfterCreate(ODocument iDocument) {
        this.addIndexesEntries(iDocument);
    }

    private void addIndexesEntries(ODocument document) {
        ODocument rid = (document = OLuceneClassIndexManager.checkForLoading(document)).getIdentity().isPersistent() ? document.placeholder() : document;
        OClass cls = document.getSchemaClass();
        if (cls != null) {
            Set indexes = cls.getIndexes();
            for (OIndex index : indexes) {
                Object key = index.getDefinition().getDocumentValueToIndex(document);
                if (key instanceof Collection) {
                    for (Object keyItem : (Collection)key) {
                        if (keyItem == null) continue;
                        index.put(keyItem, (OIdentifiable)rid);
                    }
                    continue;
                }
                if (key == null) continue;
                index.put(key, (OIdentifiable)rid);
            }
        }
    }

    public void onRecordCreateFailed(ODocument iDocument) {
    }

    public void onRecordCreateReplicated(ODocument iDocument) {
    }

    public ORecordHook.RESULT onRecordBeforeUpdate(ODocument iDocument) {
        this.checkIndexes(iDocument, ORecordHook.TYPE.BEFORE_UPDATE);
        return ORecordHook.RESULT.RECORD_NOT_CHANGED;
    }

    public void onRecordAfterUpdate(ODocument iDocument) {
        this.updateIndexEntries(iDocument);
    }

    private void updateIndexEntries(ODocument iDocument) {
        HashSet<String> dirtyFields;
        OClass cls = (iDocument = OLuceneClassIndexManager.checkForLoading(iDocument)).getSchemaClass();
        if (cls == null) {
            return;
        }
        Collection indexes = this.getDatabase().getMetadata().getIndexManager().getIndexes();
        if (!indexes.isEmpty() && !(dirtyFields = new HashSet<String>(Arrays.asList(iDocument.getDirtyFields()))).isEmpty()) {
            for (OIndex index : indexes) {
                if (!(index.getInternal() instanceof OLuceneIndex) || index.getConfiguration().field("metadata") == null) continue;
                if (index.getDefinition() instanceof OCompositeIndexDefinition) {
                    OLuceneClassIndexManager.processCompositeIndexUpdate(index, dirtyFields, iDocument);
                } else {
                    OLuceneClassIndexManager.processSingleIndexUpdate(index, dirtyFields, iDocument);
                }
                if (!iDocument.isTrackingChanges()) continue;
                iDocument.setTrackingChanges(false);
                iDocument.setTrackingChanges(true);
            }
        }
    }

    public void onRecordUpdateFailed(ODocument iDocument) {
    }

    public void onRecordUpdateReplicated(ODocument iDocument) {
    }

    public ORecordHook.RESULT onRecordBeforeDelete(ODocument iDocument) {
        ORecordVersion version = iDocument.getRecordVersion();
        if (iDocument.fields() == 0) {
            iDocument.reload();
            if (version.getCounter() > -1 && iDocument.getRecordVersion().compareTo((Object)version) != 0) {
                if (OFastConcurrentModificationException.enabled()) {
                    throw OFastConcurrentModificationException.instance();
                }
                throw new OConcurrentModificationException(iDocument.getIdentity(), iDocument.getRecordVersion(), version, 2);
            }
        }
        return ORecordHook.RESULT.RECORD_NOT_CHANGED;
    }

    public void onRecordAfterDelete(ODocument iDocument) {
        this.deleteIndexEntries(iDocument);
    }

    private void deleteIndexEntries(ODocument iDocument) {
        OClass cls = iDocument.getSchemaClass();
        if (cls == null) {
            return;
        }
        ArrayList indexes = new ArrayList(cls.getIndexes());
        if (!indexes.isEmpty()) {
            HashSet<String> dirtyFields = new HashSet<String>(Arrays.asList(iDocument.getDirtyFields()));
            if (!dirtyFields.isEmpty()) {
                Iterator indexIterator = indexes.iterator();
                while (indexIterator.hasNext()) {
                    OIndex index = (OIndex)indexIterator.next();
                    boolean result = index.getDefinition() instanceof OCompositeIndexDefinition ? OLuceneClassIndexManager.processCompositeIndexDelete(index, dirtyFields, iDocument) : OLuceneClassIndexManager.processSingleIndexDelete(index, dirtyFields, iDocument);
                    if (!result) continue;
                    indexIterator.remove();
                }
            }
            for (OIndex index : indexes) {
                Object key = index.getDefinition().getDocumentValueToIndex(iDocument);
                OLuceneClassIndexManager.deleteIndexKey(index, iDocument, key);
            }
        }
        if (iDocument.isTrackingChanges()) {
            iDocument.setTrackingChanges(false);
            iDocument.setTrackingChanges(true);
        }
    }

    public void onRecordDeleteFailed(ODocument iDocument) {
    }

    public void onRecordDeleteReplicated(ODocument iDocument) {
    }

    private static void processCompositeIndexUpdate(OIndex<?> index, Set<String> dirtyFields, ODocument iRecord) {
        OCompositeIndexDefinition indexDefinition = (OCompositeIndexDefinition)index.getDefinition();
        List indexFields = indexDefinition.getFields();
        String multiValueField = indexDefinition.getMultiValueField();
        for (String indexField : indexFields) {
            if (!dirtyFields.contains(indexField)) continue;
            ArrayList<Object> origValues = new ArrayList<Object>(indexFields.size());
            for (String field : indexFields) {
                if (field.equals(multiValueField)) continue;
                if (dirtyFields.contains(field)) {
                    origValues.add(iRecord.getOriginalValue(field));
                    continue;
                }
                origValues.add(iRecord.field(field));
            }
            if (multiValueField == null) {
                Object origValue = indexDefinition.createValue(origValues);
                Object newValue = indexDefinition.getDocumentValueToIndex(iRecord);
                if (origValue != null) {
                    index.remove(origValue, (OIdentifiable)iRecord);
                }
                if (newValue != null) {
                    index.put(newValue, (OIdentifiable)iRecord.placeholder());
                }
            } else {
                OMultiValueChangeTimeLine multiValueChangeTimeLine = iRecord.getCollectionTimeLine(multiValueField);
                if (multiValueChangeTimeLine == null) {
                    if (dirtyFields.contains(multiValueField)) {
                        origValues.add(indexDefinition.getMultiValueDefinitionIndex(), iRecord.getOriginalValue(multiValueField));
                    } else {
                        origValues.add(indexDefinition.getMultiValueDefinitionIndex(), iRecord.field(multiValueField));
                    }
                    Object origValue = indexDefinition.createValue(origValues);
                    Object newValue = indexDefinition.getDocumentValueToIndex(iRecord);
                    OLuceneClassIndexManager.processIndexUpdateFieldAssignment(index, iRecord, origValue, newValue);
                } else if (dirtyFields.size() == 1) {
                    HashMap keysToAdd = new HashMap();
                    HashMap keysToRemove = new HashMap();
                    for (OMultiValueChangeEvent changeEvent : multiValueChangeTimeLine.getMultiValueChangeEvents()) {
                        indexDefinition.processChangeEvent(changeEvent, keysToAdd, keysToRemove, origValues.toArray());
                    }
                    for (Object keyToRemove : keysToRemove.keySet()) {
                        index.remove(keyToRemove, (OIdentifiable)iRecord);
                    }
                    for (Object keyToAdd : keysToAdd.keySet()) {
                        index.put(keyToAdd, (OIdentifiable)iRecord.placeholder());
                    }
                } else {
                    OTrackedMultiValue fieldValue = (OTrackedMultiValue)iRecord.field(multiValueField);
                    Object restoredMultiValue = fieldValue.returnOriginalState(multiValueChangeTimeLine.getMultiValueChangeEvents());
                    origValues.add(indexDefinition.getMultiValueDefinitionIndex(), restoredMultiValue);
                    Object origValue = indexDefinition.createValue(origValues);
                    Object newValue = indexDefinition.getDocumentValueToIndex(iRecord);
                    OLuceneClassIndexManager.processIndexUpdateFieldAssignment(index, iRecord, origValue, newValue);
                }
            }
            return;
        }
    }

    private static void processSingleIndexUpdate(OIndex<?> index, Set<String> dirtyFields, ODocument iRecord) {
        OIndexDefinition indexDefinition = index.getDefinition();
        List indexFields = indexDefinition.getFields();
        if (indexFields.isEmpty()) {
            return;
        }
        String indexField = (String)indexFields.get(0);
        if (!dirtyFields.contains(indexField)) {
            return;
        }
        OMultiValueChangeTimeLine multiValueChangeTimeLine = iRecord.getCollectionTimeLine(indexField);
        if (multiValueChangeTimeLine != null) {
            OIndexDefinitionMultiValue indexDefinitionMultiValue = (OIndexDefinitionMultiValue)indexDefinition;
            HashMap keysToAdd = new HashMap();
            HashMap keysToRemove = new HashMap();
            for (OMultiValueChangeEvent changeEvent : multiValueChangeTimeLine.getMultiValueChangeEvents()) {
                indexDefinitionMultiValue.processChangeEvent(changeEvent, keysToAdd, keysToRemove);
            }
            for (Object keyToRemove : keysToRemove.keySet()) {
                index.remove(keyToRemove, (OIdentifiable)iRecord);
            }
            for (Object keyToAdd : keysToAdd.keySet()) {
                index.put(keyToAdd, (OIdentifiable)iRecord.placeholder());
            }
        } else {
            Object origValue = indexDefinition.createValue(new Object[]{iRecord.getOriginalValue(indexField)});
            Object newValue = indexDefinition.getDocumentValueToIndex(iRecord);
            OLuceneClassIndexManager.processIndexUpdateFieldAssignment(index, iRecord, origValue, newValue);
        }
    }

    private static void processIndexUpdateFieldAssignment(OIndex<?> index, ODocument iRecord, Object origValue, Object newValue) {
        if (origValue instanceof Collection && newValue instanceof Collection) {
            HashSet valuesToRemove = new HashSet((Collection)origValue);
            HashSet valuesToAdd = new HashSet((Collection)newValue);
            valuesToRemove.removeAll((Collection)newValue);
            valuesToAdd.removeAll((Collection)origValue);
            for (Object valueToRemove : valuesToRemove) {
                if (valueToRemove == null) continue;
                index.remove(valueToRemove, (OIdentifiable)iRecord);
            }
            for (Object valueToAdd : valuesToAdd) {
                if (valueToAdd == null) continue;
                index.put(valueToAdd, (OIdentifiable)iRecord);
            }
        } else {
            OLuceneClassIndexManager.deleteIndexKey(index, iRecord, origValue);
            if (newValue instanceof Collection) {
                for (Object newValueItem : (Collection)newValue) {
                    index.put(newValueItem, (OIdentifiable)iRecord.placeholder());
                }
            } else if (newValue != null) {
                index.put(newValue, (OIdentifiable)iRecord.placeholder());
            }
        }
    }

    private static boolean processCompositeIndexDelete(OIndex<?> index, Set<String> dirtyFields, ODocument iRecord) {
        OCompositeIndexDefinition indexDefinition = (OCompositeIndexDefinition)index.getDefinition();
        String multiValueField = indexDefinition.getMultiValueField();
        List indexFields = indexDefinition.getFields();
        for (String indexField : indexFields) {
            if (!dirtyFields.contains(indexField)) continue;
            ArrayList<Object> origValues = new ArrayList<Object>(indexFields.size());
            for (String field : indexFields) {
                if (field.equals(multiValueField)) continue;
                if (dirtyFields.contains(field)) {
                    origValues.add(iRecord.getOriginalValue(field));
                    continue;
                }
                origValues.add(iRecord.field(field));
            }
            if (multiValueField != null) {
                OMultiValueChangeTimeLine multiValueChangeTimeLine = iRecord.getCollectionTimeLine(multiValueField);
                if (multiValueChangeTimeLine != null) {
                    OTrackedMultiValue fieldValue = (OTrackedMultiValue)iRecord.field(multiValueField);
                    Object restoredMultiValue = fieldValue.returnOriginalState(multiValueChangeTimeLine.getMultiValueChangeEvents());
                    origValues.add(indexDefinition.getMultiValueDefinitionIndex(), restoredMultiValue);
                } else if (dirtyFields.contains(multiValueField)) {
                    origValues.add(indexDefinition.getMultiValueDefinitionIndex(), iRecord.getOriginalValue(multiValueField));
                } else {
                    origValues.add(indexDefinition.getMultiValueDefinitionIndex(), iRecord.field(multiValueField));
                }
            }
            Object origValue = indexDefinition.createValue(origValues);
            OLuceneClassIndexManager.deleteIndexKey(index, iRecord, origValue);
            return true;
        }
        return false;
    }

    private static void deleteIndexKey(OIndex<?> index, ODocument iRecord, Object origValue) {
        if (origValue instanceof Collection) {
            for (Object valueItem : (Collection)origValue) {
                if (valueItem == null) continue;
                index.remove(valueItem, (OIdentifiable)iRecord);
            }
        } else if (origValue != null) {
            index.remove(origValue, (OIdentifiable)iRecord);
        }
    }

    private static boolean processSingleIndexDelete(OIndex<?> index, Set<String> dirtyFields, ODocument iRecord) {
        OIndexDefinition indexDefinition = index.getDefinition();
        List indexFields = indexDefinition.getFields();
        if (indexFields.isEmpty()) {
            return false;
        }
        String indexField = (String)indexFields.iterator().next();
        if (dirtyFields.contains(indexField)) {
            Object origValue;
            OMultiValueChangeTimeLine multiValueChangeTimeLine = iRecord.getCollectionTimeLine(indexField);
            if (multiValueChangeTimeLine != null) {
                OTrackedMultiValue fieldValue = (OTrackedMultiValue)iRecord.field(indexField);
                Object restoredMultiValue = fieldValue.returnOriginalState(multiValueChangeTimeLine.getMultiValueChangeEvents());
                origValue = indexDefinition.createValue(new Object[]{restoredMultiValue});
            } else {
                origValue = indexDefinition.createValue(new Object[]{iRecord.getOriginalValue(indexField)});
            }
            OLuceneClassIndexManager.deleteIndexKey(index, iRecord, origValue);
            return true;
        }
        return false;
    }

    private void checkIndexes(ODocument document, ORecordHook.TYPE hookType) {
        OClass cls = (document = OLuceneClassIndexManager.checkForLoading(document)).getSchemaClass();
        if (cls != null) {
            Set indexes = cls.getIndexes();
            switch (hookType) {
                case BEFORE_CREATE: {
                    OLuceneClassIndexManager.checkIndexedPropertiesOnCreation(document, indexes);
                    break;
                }
                case BEFORE_UPDATE: {
                    OLuceneClassIndexManager.checkIndexedPropertiesOnUpdate(document, indexes);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid hook type: " + hookType);
                }
            }
        }
    }

    private static void checkIndexedPropertiesOnCreation(ODocument iRecord, Collection<OIndex<?>> iIndexes) {
        for (OIndex<?> index : iIndexes) {
            Object key = index.getDefinition().getDocumentValueToIndex(iRecord);
            if (key instanceof Collection) {
                for (Object keyItem : (Collection)key) {
                    if (keyItem == null) continue;
                    index.checkEntry((OIdentifiable)iRecord, keyItem);
                }
                continue;
            }
            if (key == null) continue;
            index.checkEntry((OIdentifiable)iRecord, key);
        }
    }

    private static void checkIndexedPropertiesOnUpdate(ODocument iRecord, Collection<OIndex<?>> iIndexes) {
        HashSet<String> dirtyFields = new HashSet<String>(Arrays.asList(iRecord.getDirtyFields()));
        if (dirtyFields.isEmpty()) {
            return;
        }
        block0: for (OIndex<?> index : iIndexes) {
            OIndexDefinition indexDefinition = index.getDefinition();
            List indexFields = indexDefinition.getFields();
            for (String indexField : indexFields) {
                if (!dirtyFields.contains(indexField)) continue;
                Object key = index.getDefinition().getDocumentValueToIndex(iRecord);
                if (key instanceof Collection) {
                    for (Object keyItem : (Collection)key) {
                        if (keyItem == null) continue;
                        index.checkEntry((OIdentifiable)iRecord, keyItem);
                    }
                    continue block0;
                }
                if (key == null) continue block0;
                index.checkEntry((OIdentifiable)iRecord, key);
                continue block0;
            }
        }
    }

    private static ODocument checkForLoading(ODocument iRecord) {
        if (iRecord.getInternalStatus() == ORecordElement.STATUS.NOT_LOADED) {
            try {
                return (ODocument)iRecord.load();
            }
            catch (ORecordNotFoundException e) {
                throw new OIndexException("Error during loading of record with id : " + iRecord.getIdentity());
            }
        }
        return iRecord;
    }

    private ODatabaseDocumentInternal getDatabase() {
        return ODatabaseRecordThreadLocal.INSTANCE.get();
    }
}

