/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.lucene.functions;

import com.orientechnologies.lucene.collections.OSpatialCompositeKey;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.sql.functions.coll.OSQLFunctionMultiValueAbstract;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class OLuceneNearFunction
extends OSQLFunctionMultiValueAbstract<Set<Object>> {
    public static final String NAME = "near";

    public OLuceneNearFunction() {
        super(NAME, 5, 6);
    }

    public Object execute(Object iThis, OIdentifiable iCurrentRecord, Object iCurrentResult, Object[] iParams, OCommandContext iContext) {
        String clazz = (String)iParams[0];
        String latField = (String)iParams[1];
        String lngField = (String)iParams[2];
        ODatabaseDocumentInternal databaseRecord = ODatabaseRecordThreadLocal.INSTANCE.get();
        Set indexes = databaseRecord.getMetadata().getSchema().getClass(clazz).getInvolvedIndexes(new String[]{latField, lngField});
        for (OIndex i : indexes) {
            if (!OClass.INDEX_TYPE.SPATIAL.toString().equals(i.getInternal().getType())) continue;
            ArrayList<Object> params = new ArrayList<Object>();
            params.add(iParams[3]);
            params.add(iParams[4]);
            double distance = iParams.length > 5 ? ((Number)iParams[5]).doubleValue() : 0.0;
            Object ret = i.get((Object)new OSpatialCompositeKey(params).setMaxDistance(distance));
            if (ret instanceof Collection) {
                if (this.context == null) {
                    this.context = new HashSet();
                }
                ((Set)this.context).addAll((Collection)ret);
            }
            return ret;
        }
        return null;
    }

    public String getSyntax() {
        return "near(<class>,<field-x>,<field-y>,<x-value>,<y-value>[,<maxDistance>])";
    }
}

