/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.lucene;

import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.index.OCompositeKey;
import com.orientechnologies.orient.core.index.OIndexDefinition;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.DoubleField;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FloatField;
import org.apache.lucene.document.IntField;
import org.apache.lucene.document.LongField;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryparser.classic.MultiFieldQueryParser;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.NumericRangeQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.util.Version;

public class OLuceneIndexType {
    public static Field createField(String fieldName, Object value, Field.Store store, Field.Index analyzed) {
        Object field = null;
        if (value instanceof Number) {
            Number number = (Number)value;
            field = value instanceof Long ? new LongField(fieldName, number.longValue(), store) : (value instanceof Float ? new FloatField(fieldName, number.floatValue(), store) : (value instanceof Double ? new DoubleField(fieldName, number.doubleValue(), store) : new IntField(fieldName, number.intValue(), store)));
        } else {
            field = value instanceof Date ? new LongField(fieldName, ((Date)value).getTime(), store) : new Field(fieldName, value.toString(), store, analyzed);
        }
        return field;
    }

    public static Query createExactQuery(OIndexDefinition index, Object key) {
        BooleanQuery query = null;
        if (key instanceof String) {
            BooleanQuery booleanQ = new BooleanQuery();
            if (index.getFields().size() > 0) {
                for (String idx : index.getFields()) {
                    booleanQ.add((Query)new TermQuery(new Term(idx, key.toString())), BooleanClause.Occur.SHOULD);
                }
            } else {
                booleanQ.add((Query)new TermQuery(new Term("KEY", key.toString())), BooleanClause.Occur.SHOULD);
            }
            query = booleanQ;
        } else if (key instanceof OCompositeKey) {
            BooleanQuery booleanQ = new BooleanQuery();
            int i = 0;
            OCompositeKey keys = (OCompositeKey)key;
            for (String idx : index.getFields()) {
                String val = (String)keys.getKeys().get(i);
                booleanQ.add((Query)new TermQuery(new Term(idx, val)), BooleanClause.Occur.MUST);
                ++i;
            }
            query = booleanQ;
        }
        return query;
    }

    public static Query createQueryId(OIdentifiable value) {
        return new TermQuery(new Term("RID", value.toString()));
    }

    public static Query createDeleteQuery(OIdentifiable value, List<String> fields, Object key) {
        BooleanQuery booleanQuery = new BooleanQuery();
        booleanQuery.add((Query)new TermQuery(new Term("RID", value.toString())), BooleanClause.Occur.MUST);
        HashMap<String, String> values = new HashMap<String, String>();
        if (!(key instanceof OCompositeKey)) {
            values.put(fields.iterator().next(), key.toString());
        }
        for (String s : values.keySet()) {
            booleanQuery.add((Query)new TermQuery(new Term(s + "_STORED", (String)values.get(s))), BooleanClause.Occur.MUST);
        }
        return booleanQuery;
    }

    public static Query createFullQuery(OIndexDefinition index, Object key, Analyzer analyzer, Version version) throws ParseException {
        String query = "";
        if (key instanceof OCompositeKey) {
            Object params = ((OCompositeKey)key).getKeys().get(0);
            if (params instanceof Map) {
                Object q = ((Map)params).get("q");
                if (q != null) {
                    query = q.toString();
                }
            } else {
                query = params.toString();
            }
        } else {
            query = key.toString();
        }
        return OLuceneIndexType.getQueryParser(index, query, analyzer, version);
    }

    protected static Query getQueryParser(OIndexDefinition index, String key, Analyzer analyzer, Version version) throws ParseException {
        QueryParser queryParser;
        if (key.startsWith("(")) {
            queryParser = new QueryParser(version, "", analyzer);
        } else {
            String[] fields = null;
            if (index.isAutomatic()) {
                fields = index.getFields().toArray(new String[index.getFields().size()]);
            } else {
                int length = index.getTypes().length;
                fields = new String[length];
                for (int i = 0; i < length; ++i) {
                    fields[i] = "k" + i;
                }
            }
            queryParser = new MultiFieldQueryParser(version, fields, analyzer);
        }
        return queryParser.parse(key);
    }

    public static Sort sort(Query query, OIndexDefinition index, boolean ascSortOrder) {
        String key = (String)index.getFields().iterator().next();
        Number number = ((NumericRangeQuery)query).getMin();
        number = number != null ? (Number)number : (Number)((NumericRangeQuery)query).getMax();
        SortField.Type fieldType = SortField.Type.INT;
        if (number instanceof Long) {
            fieldType = SortField.Type.LONG;
        } else if (number instanceof Float) {
            fieldType = SortField.Type.FLOAT;
        } else if (number instanceof Double) {
            fieldType = SortField.Type.DOUBLE;
        }
        return new Sort(new SortField(key, fieldType, ascSortOrder));
    }
}

