/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.jdbc;

import java.sql.ParameterMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

class OrientJdbcParameterMetadata
implements ParameterMetaData {
    private final List<ParameterDefinition> definitions = new ArrayList<ParameterDefinition>();

    @Override
    public int getParameterCount() throws SQLException {
        return this.definitions.size();
    }

    @Override
    public int isNullable(int param) throws SQLException {
        this.checkIndex(param);
        return this.definitions.get((int)param).nullable;
    }

    @Override
    public boolean isSigned(int param) throws SQLException {
        this.checkIndex(param);
        return this.definitions.get((int)param).signed;
    }

    @Override
    public int getPrecision(int param) throws SQLException {
        this.checkIndex(param);
        return this.definitions.get((int)param).precision;
    }

    @Override
    public int getScale(int param) throws SQLException {
        this.checkIndex(param);
        return this.definitions.get((int)param).scale;
    }

    @Override
    public int getParameterType(int param) throws SQLException {
        this.checkIndex(param);
        return this.definitions.get((int)param).type;
    }

    @Override
    public String getParameterTypeName(int param) throws SQLException {
        this.checkIndex(param);
        return this.definitions.get((int)param).typeName;
    }

    @Override
    public String getParameterClassName(int param) throws SQLException {
        this.checkIndex(param);
        return this.definitions.get((int)param).className;
    }

    @Override
    public int getParameterMode(int param) throws SQLException {
        this.checkIndex(param);
        return this.definitions.get((int)param).mode;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        throw new SQLException("No object wrapper for class : " + iface);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return false;
    }

    private void checkIndex(int index) throws SQLException {
        if (index < 0 || index >= this.definitions.size()) {
            throw new SQLException("Parameter number " + index + " does not exist.");
        }
    }

    public boolean add(ParameterDefinition parameterDefinition) {
        return this.definitions.add(parameterDefinition);
    }

    static class ParameterDefinition {
        public int nullable = 2;
        public boolean signed = true;
        public int precision = 0;
        public int scale = 0;
        public int type = 1111;
        public String typeName = "String";
        public String className = "java.lang.String";
        public int mode = 0;

        ParameterDefinition() {
        }
    }
}

