/*
 * Decompiled with CFR 0.152.
 */
package com.openhtmltopdf.pdfboxout;

import com.openhtmltopdf.bidi.BidiReorderer;
import com.openhtmltopdf.bidi.BidiSplitterFactory;
import com.openhtmltopdf.bidi.SimpleBidiReorderer;
import com.openhtmltopdf.context.StyleReference;
import com.openhtmltopdf.css.constants.IdentValue;
import com.openhtmltopdf.css.style.CssContext;
import com.openhtmltopdf.extend.FSDOMMutator;
import com.openhtmltopdf.extend.FontContext;
import com.openhtmltopdf.extend.FontResolver;
import com.openhtmltopdf.extend.NamespaceHandler;
import com.openhtmltopdf.extend.OutputDevice;
import com.openhtmltopdf.extend.ReplacedElementFactory;
import com.openhtmltopdf.extend.SVGDrawer;
import com.openhtmltopdf.extend.TextRenderer;
import com.openhtmltopdf.extend.UserAgentCallback;
import com.openhtmltopdf.extend.UserInterface;
import com.openhtmltopdf.layout.BoxBuilder;
import com.openhtmltopdf.layout.Layer;
import com.openhtmltopdf.layout.LayoutContext;
import com.openhtmltopdf.layout.SharedContext;
import com.openhtmltopdf.outputdevice.helper.BaseDocument;
import com.openhtmltopdf.outputdevice.helper.PageDimensions;
import com.openhtmltopdf.outputdevice.helper.UnicodeImplementation;
import com.openhtmltopdf.pdfboxout.PDFCreationListener;
import com.openhtmltopdf.pdfboxout.PagePosition;
import com.openhtmltopdf.pdfboxout.PageSupplier;
import com.openhtmltopdf.pdfboxout.PdfBoxFastOutputDevice;
import com.openhtmltopdf.pdfboxout.PdfBoxFontContext;
import com.openhtmltopdf.pdfboxout.PdfBoxFontResolver;
import com.openhtmltopdf.pdfboxout.PdfBoxOutputDevice;
import com.openhtmltopdf.pdfboxout.PdfBoxReplacedElementFactory;
import com.openhtmltopdf.pdfboxout.PdfBoxSlowOutputDevice;
import com.openhtmltopdf.pdfboxout.PdfBoxTextRenderer;
import com.openhtmltopdf.pdfboxout.PdfBoxUserAgent;
import com.openhtmltopdf.pdfboxout.PdfRendererBuilder;
import com.openhtmltopdf.pdfboxout.PdfRendererBuilderState;
import com.openhtmltopdf.render.BlockBox;
import com.openhtmltopdf.render.Box;
import com.openhtmltopdf.render.PageBox;
import com.openhtmltopdf.render.RenderingContext;
import com.openhtmltopdf.render.ViewportBox;
import com.openhtmltopdf.render.displaylist.DisplayListCollector;
import com.openhtmltopdf.render.displaylist.DisplayListContainer;
import com.openhtmltopdf.render.displaylist.DisplayListPainter;
import com.openhtmltopdf.resource.XMLResource;
import com.openhtmltopdf.simple.extend.XhtmlNamespaceHandler;
import com.openhtmltopdf.util.Configuration;
import com.openhtmltopdf.util.ThreadCtx;
import com.openhtmltopdf.util.XRLog;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Calendar;
import java.util.List;
import java.util.logging.Level;
import java.util.regex.Pattern;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDDocumentCatalog;
import org.apache.pdfbox.pdmodel.PDDocumentInformation;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.common.PDMetadata;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.documentinterchange.logicalstructure.PDMarkInfo;
import org.apache.pdfbox.pdmodel.encryption.PDEncryption;
import org.apache.pdfbox.pdmodel.graphics.color.PDOutputIntent;
import org.apache.pdfbox.pdmodel.interactive.viewerpreferences.PDViewerPreferences;
import org.apache.xmpbox.XMPMetadata;
import org.apache.xmpbox.schema.AdobePDFSchema;
import org.apache.xmpbox.schema.DublinCoreSchema;
import org.apache.xmpbox.schema.PDFAIdentificationSchema;
import org.apache.xmpbox.schema.XMPBasicSchema;
import org.apache.xmpbox.schema.XMPSchema;
import org.apache.xmpbox.type.AbstractField;
import org.apache.xmpbox.type.BadFieldValueException;
import org.apache.xmpbox.xml.XmpSerializer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public class PdfBoxRenderer
implements Closeable,
PageSupplier {
    private static final float DEFAULT_DOTS_PER_POINT = 26.666666f;
    private static final int DEFAULT_DOTS_PER_PIXEL = 20;
    private static final int DEFAULT_PDF_POINTS_PER_INCH = 72;
    private final SharedContext _sharedContext;
    private final PdfBoxOutputDevice _outputDevice;
    private final List<FSDOMMutator> _domMutators;
    private Document _doc;
    private BlockBox _root;
    private final float _dotsPerPoint;
    private PDDocument _pdfDoc;
    private PDEncryption _pdfEncryption;
    private String _producer;
    private float _pdfVersion;
    private PdfRendererBuilder.PdfAConformance _pdfAConformance;
    private boolean _pdfUaConformance;
    private byte[] _colorProfile;
    private boolean _testMode;
    private PDFCreationListener _listener;
    private OutputStream _os;
    private SVGDrawer _svgImpl;
    private SVGDrawer _mathmlImpl;
    private BidiSplitterFactory _splitterFactory;
    private byte _defaultTextDirection = 0;
    private BidiReorderer _reorderer;
    private final boolean _useFastMode;
    private PageSupplier _pageSupplier;

    PdfBoxRenderer(BaseDocument doc, UnicodeImplementation unicode, PageDimensions pageSize, PdfRendererBuilderState state) {
        this._pdfDoc = state.pddocument != null ? state.pddocument : new PDDocument();
        this._pdfDoc.setVersion(state._pdfVersion);
        this._producer = state._producer;
        this._pageSupplier = state._pageSupplier != null ? state._pageSupplier : this;
        this._svgImpl = state._svgImpl;
        this._mathmlImpl = state._mathmlImpl;
        this._pdfAConformance = state._pdfAConformance;
        this._pdfUaConformance = state._pdfUaConform;
        this._colorProfile = state._colorProfile;
        this._dotsPerPoint = 26.666666f;
        this._testMode = state._testMode;
        this._useFastMode = state._useFastRenderer;
        this._outputDevice = state._useFastRenderer ? new PdfBoxFastOutputDevice(26.666666f, this._testMode, state._pdfUaConform || state._pdfAConformance.getConformanceValue().equals("A"), state._pdfAConformance != PdfRendererBuilder.PdfAConformance.NONE) : new PdfBoxSlowOutputDevice(26.666666f, this._testMode);
        this._outputDevice.setWriter(this._pdfDoc);
        this._outputDevice.setStartPageNo(this._pdfDoc.getNumberOfPages());
        PdfBoxUserAgent userAgent = new PdfBoxUserAgent(this._outputDevice);
        userAgent.setProtocolsStreamFactory(state._streamFactoryMap);
        if (state._resolver != null) {
            userAgent.setUriResolver(state._resolver);
        }
        this._sharedContext = new SharedContext();
        this._sharedContext.registerWithThread();
        this._sharedContext._preferredTransformerFactoryImplementationClass = state._preferredTransformerFactoryImplementationClass;
        this._sharedContext._preferredDocumentBuilderFactoryImplementationClass = state._preferredDocumentBuilderFactoryImplementationClass;
        this._sharedContext.setUserAgentCallback((UserAgentCallback)userAgent);
        this._sharedContext.setCss(new StyleReference((UserAgentCallback)userAgent));
        userAgent.setSharedContext(this._sharedContext);
        this._outputDevice.setSharedContext(this._sharedContext);
        PdfBoxFontResolver fontResolver = new PdfBoxFontResolver(this._sharedContext, this._pdfDoc, state._caches.get((Object)PdfRendererBuilder.CacheStore.PDF_FONT_METRICS), state._pdfAConformance, state._pdfUaConform);
        this._sharedContext.setFontResolver((FontResolver)fontResolver);
        PdfBoxReplacedElementFactory replacedElementFactory = new PdfBoxReplacedElementFactory(this._outputDevice, state._svgImpl, state._objectDrawerFactory, state._mathmlImpl);
        this._sharedContext.setReplacedElementFactory((ReplacedElementFactory)replacedElementFactory);
        this._sharedContext.setTextRenderer((TextRenderer)new PdfBoxTextRenderer());
        this._sharedContext.setDPI(72.0f * this._dotsPerPoint);
        this._sharedContext.setDotsPerPixel(20);
        this._sharedContext.setPrint(true);
        this._sharedContext.setInteractive(false);
        this.getSharedContext().setDefaultPageSize(pageSize.w, pageSize.h, pageSize.isSizeInches);
        if (state._replacementText != null) {
            this.getSharedContext().setReplacementText(state._replacementText);
        }
        if (unicode.splitterFactory != null) {
            this._splitterFactory = unicode.splitterFactory;
        }
        if (unicode.reorderer != null) {
            this._reorderer = unicode.reorderer;
            this._outputDevice.setBidiReorderer(this._reorderer);
        }
        if (unicode.lineBreaker != null) {
            this._sharedContext.setLineBreaker(unicode.lineBreaker);
        }
        if (unicode.charBreaker != null) {
            this._sharedContext.setCharacterBreaker(unicode.charBreaker);
        }
        if (unicode.toLowerTransformer != null) {
            this._sharedContext.setUnicodeToLowerTransformer(unicode.toLowerTransformer);
        }
        if (unicode.toUpperTransformer != null) {
            this._sharedContext.setUnicodeToUpperTransformer(unicode.toUpperTransformer);
        }
        if (unicode.toTitleTransformer != null) {
            this._sharedContext.setUnicodeToTitleTransformer(unicode.toTitleTransformer);
        }
        this._defaultTextDirection = unicode.textDirection ? (byte)1 : 0;
        this._domMutators = state._domMutators;
        if (doc.html != null) {
            this.setDocumentFromStringP(doc.html, doc.baseUri);
        } else if (doc.document != null) {
            this.setDocumentP(doc.document, doc.baseUri);
        } else if (doc.uri != null) {
            this.setDocumentP(doc.uri);
        } else if (doc.file != null) {
            try {
                this.setDocumentP(doc.file);
            }
            catch (IOException e) {
                XRLog.exception((String)"Problem trying to read input XHTML file", (Throwable)e);
                throw new RuntimeException("File IO problem", e);
            }
        }
        this._os = state._os;
    }

    public Document getDocument() {
        return this._doc;
    }

    public PDDocument getPdfDocument() {
        return this._pdfDoc;
    }

    public PdfBoxFontResolver getFontResolver() {
        return (PdfBoxFontResolver)this._sharedContext.getFontResolver();
    }

    private Document loadDocument(String uri) {
        return this._sharedContext.getUserAgentCallback().getXMLResource(uri).getDocument();
    }

    private void setDocumentP(String uri) {
        this.setDocumentP(this.loadDocument(uri), uri);
    }

    private void setDocumentP(Document doc, String url) {
        this.setDocumentP(doc, url, (NamespaceHandler)new XhtmlNamespaceHandler());
    }

    private void setDocumentP(File file) throws IOException {
        File parent = file.getAbsoluteFile().getParentFile();
        this.setDocumentP(this.loadDocument(file.toURI().toURL().toExternalForm()), parent == null ? "" : parent.toURI().toURL().toExternalForm());
    }

    private void setDocumentFromStringP(String content, String baseUrl) {
        InputSource is = new InputSource(new BufferedReader(new StringReader(content)));
        Document dom = XMLResource.load((InputSource)is).getDocument();
        this.setDocumentP(dom, baseUrl);
    }

    private void setDocumentP(Document doc, String url, NamespaceHandler nsh) {
        this._doc = doc;
        for (FSDOMMutator domMutator : this._domMutators) {
            domMutator.mutateDocument(doc);
        }
        this.getFontResolver().flushFontFaceFonts();
        if (Configuration.isTrue((String)"xr.cache.stylesheets", (boolean)true)) {
            this._sharedContext.getCss().flushStyleSheets();
        } else {
            this._sharedContext.getCss().flushAllStyleSheets();
        }
        this._sharedContext.setBaseURL(url);
        this._sharedContext.setNamespaceHandler(nsh);
        this._sharedContext.getCss().setDocumentContext(this._sharedContext, this._sharedContext.getNamespaceHandler(), doc, (UserInterface)new NullUserInterface());
        this.getFontResolver().importFontFaces(this._sharedContext.getCss().getFontFaceRules());
        if (this._svgImpl != null) {
            this._svgImpl.importFontFaceRules(this._sharedContext.getCss().getFontFaceRules(), this._sharedContext);
        }
        if (this._mathmlImpl != null) {
            this._mathmlImpl.importFontFaceRules(this._sharedContext.getCss().getFontFaceRules(), this._sharedContext);
        }
    }

    public float getPDFVersion() {
        return this._pdfVersion == 0.0f ? 1.7f : this._pdfVersion;
    }

    public void layout() {
        LayoutContext c = this.newLayoutContext();
        BlockBox root = BoxBuilder.createRootBox((LayoutContext)c, (Document)this._doc);
        root.setContainingBlock((Box)new ViewportBox(this.getInitialExtents(c)));
        root.layout(c);
        Dimension dim = root.getLayer().getPaintingDimension(c);
        root.getLayer().trimEmptyPages((CssContext)c, dim.height);
        root.getLayer().layoutPages(c);
        this._root = root;
    }

    private Rectangle getInitialExtents(LayoutContext c) {
        PageBox first = Layer.createPageBox((CssContext)c, (String)"first");
        return new Rectangle(0, 0, first.getContentWidth((CssContext)c), first.getContentHeight((CssContext)c));
    }

    private RenderingContext newRenderingContext() {
        RenderingContext result = this._sharedContext.newRenderingContextInstance();
        result.setFontContext((FontContext)new PdfBoxFontContext());
        result.setOutputDevice((OutputDevice)this._outputDevice);
        if (this._reorderer != null) {
            result.setBidiReorderer(this._reorderer);
        }
        this._outputDevice.setRenderingContext(result);
        this._sharedContext.getTextRenderer().setup(result.getFontContext());
        result.setRootLayer(this._root.getLayer());
        return result;
    }

    private LayoutContext newLayoutContext() {
        LayoutContext result = this._sharedContext.newLayoutContextInstance();
        result.setFontContext((FontContext)new PdfBoxFontContext());
        if (this._splitterFactory != null) {
            result.setBidiSplitterFactory(this._splitterFactory);
        }
        if (this._reorderer != null) {
            result.setBidiReorderer(this._reorderer);
        }
        result.setDefaultTextDirection(this._defaultTextDirection);
        ((PdfBoxTextRenderer)this._sharedContext.getTextRenderer()).setup(result.getFontContext(), (BidiReorderer)(this._reorderer != null ? this._reorderer : new SimpleBidiReorderer()));
        return result;
    }

    public void createPDF() throws IOException {
        this.createPDF(this._os);
    }

    public void createPDFWithoutClosing() throws IOException {
        this.createPDF(this._os, false, 0);
    }

    @Deprecated
    public void createPDF(OutputStream os) throws IOException {
        this.createPDF(os, true, 0);
    }

    @Deprecated
    public void writeNextDocument() throws IOException {
        this.writeNextDocument(0);
    }

    @Deprecated
    public void writeNextDocument(int initialPageNo) throws IOException {
        List pages = this._root.getLayer().getPages();
        RenderingContext c = this.newRenderingContext();
        c.setInitialPageNo(initialPageNo);
        PageBox firstPage = (PageBox)pages.get(0);
        Rectangle2D.Float firstPageSize = new Rectangle2D.Float(0.0f, 0.0f, (float)firstPage.getWidth((CssContext)c) / this._dotsPerPoint, (float)firstPage.getHeight((CssContext)c) / this._dotsPerPoint);
        this._outputDevice.setStartPageNo(this._pdfDoc.getNumberOfPages());
        this.writePDF(pages, c, firstPageSize, this._pdfDoc);
    }

    @Deprecated
    public void finishPDF() throws IOException {
        if (this._pdfDoc != null) {
            this.fireOnClose();
            this._pdfDoc.close();
        }
    }

    @Deprecated
    public void createPDF(OutputStream os, boolean finish) throws IOException {
        this.createPDF(os, finish, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public void createPDF(OutputStream os, boolean finish, int initialPageNo) throws IOException {
        if (this._useFastMode) {
            this.createPdfFast(finish);
            return;
        }
        boolean success = false;
        try {
            if (this._root == null) {
                this.layout();
            }
            List pages = this._root.getLayer().getPages();
            RenderingContext c = this.newRenderingContext();
            c.setInitialPageNo(initialPageNo);
            PageBox firstPage = (PageBox)pages.get(0);
            Rectangle2D.Float firstPageSize = new Rectangle2D.Float(0.0f, 0.0f, (float)firstPage.getWidth((CssContext)c) / this._dotsPerPoint, (float)firstPage.getHeight((CssContext)c) / this._dotsPerPoint);
            if (this._pdfVersion != 0.0f) {
                this._pdfDoc.setVersion(this._pdfVersion);
            }
            if (this._pdfEncryption != null) {
                this._pdfDoc.setEncryptionDictionary(this._pdfEncryption);
            }
            this.firePreOpen();
            this.writePDF(pages, c, firstPageSize, this._pdfDoc);
            success = true;
        }
        finally {
            if (finish) {
                this.fireOnClose();
                if (success) {
                    this._pdfDoc.save(os);
                }
                this._pdfDoc.close();
                this._pdfDoc = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createPdfFast(boolean finish) throws IOException {
        boolean success = false;
        XRLog.general((Level)Level.INFO, (String)"Using fast-mode renderer. Prepare to fly.");
        try {
            if (this._root == null) {
                this.layout();
            }
            List pages = this._root.getLayer().getPages();
            RenderingContext c = this.newRenderingContext();
            c.setInitialPageNo(0);
            c.setFastRenderer(true);
            PageBox firstPage = (PageBox)pages.get(0);
            Rectangle2D.Float firstPageSize = new Rectangle2D.Float(0.0f, 0.0f, (float)firstPage.getWidth((CssContext)c) / this._dotsPerPoint, (float)firstPage.getHeight((CssContext)c) / this._dotsPerPoint);
            if (this._pdfVersion != 0.0f) {
                this._pdfDoc.setVersion(this._pdfVersion);
            }
            if (this._pdfEncryption != null) {
                this._pdfDoc.setEncryptionDictionary(this._pdfEncryption);
            }
            this.firePreOpen();
            this.writePDFFast(pages, c, firstPageSize, this._pdfDoc);
            success = true;
        }
        finally {
            if (finish) {
                this.fireOnClose();
                if (success) {
                    this._pdfDoc.save(this._os);
                }
                this._pdfDoc.close();
                this._pdfDoc = null;
            }
        }
    }

    private void firePreOpen() {
        if (this._listener != null) {
            this._listener.preOpen(this);
        }
    }

    private void firePreWrite(int pageCount) {
        if (this._listener != null) {
            this._listener.preWrite(this, pageCount);
        }
    }

    private void fireOnClose() {
        if (this._listener != null) {
            this._listener.onClose(this);
        }
    }

    private void writePDFFast(List<PageBox> pages, RenderingContext c, Rectangle2D firstPageSize, PDDocument doc) throws IOException {
        this._outputDevice.setRoot((Box)this._root);
        this._outputDevice.start(this._doc);
        PDPage page = this._pageSupplier.requestPage(doc, (float)firstPageSize.getWidth(), (float)firstPageSize.getHeight(), 0, -1);
        PDPageContentStream cs = new PDPageContentStream(doc, page, PDPageContentStream.AppendMode.APPEND, !this._testMode);
        this._outputDevice.initializePage(cs, page, (float)firstPageSize.getHeight());
        this._root.getLayer().assignPagePaintingPositions((CssContext)c, (short)2);
        int pageCount = this._root.getLayer().getPages().size();
        c.setPageCount(pageCount);
        this.firePreWrite(pageCount);
        this.setDidValues(doc);
        if (this._pdfUaConformance) {
            this.addPdfUaXMPSchema(doc);
        } else if (this._pdfAConformance != PdfRendererBuilder.PdfAConformance.NONE) {
            this.addPdfASchema(doc, this._pdfAConformance.getPart(), this._pdfAConformance.getConformanceValue());
        }
        DisplayListCollector dlCollector = new DisplayListCollector(this._root.getLayer().getPages());
        DisplayListContainer dlPages = dlCollector.collectRoot(c, this._root.getLayer());
        int pdfPageIndex = 0;
        for (int i = 0; i < pageCount; ++i) {
            PageBox currentPage = pages.get(i);
            currentPage.setBasePagePdfPageIndex(pdfPageIndex);
            DisplayListContainer.DisplayListPageContainer pageOperations = dlPages.getPageInstructions(i);
            c.setPage(i, currentPage);
            c.setShadowPageNumber(-1);
            this.paintPageFast(c, currentPage, pageOperations, 0);
            this._outputDevice.finishPage();
            ++pdfPageIndex;
            if (!pageOperations.shadowPages().isEmpty()) {
                currentPage.setShadowPageCount(pageOperations.shadowPages().size());
                int shadowPageIndex = 0;
                int pageContentWidth = currentPage.getContentWidth((CssContext)c);
                int translateX = pageContentWidth * (currentPage.getCutOffPageDirection() == IdentValue.LTR ? 1 : -1);
                for (DisplayListContainer.DisplayListPageContainer shadowPage : pageOperations.shadowPages()) {
                    PDPage shadowPdPage = this._pageSupplier.requestPage(doc, (float)currentPage.getWidth((CssContext)c) / this._dotsPerPoint, (float)currentPage.getHeight((CssContext)c) / this._dotsPerPoint, i, shadowPageIndex);
                    PDPageContentStream shadowCs = new PDPageContentStream(doc, shadowPdPage, PDPageContentStream.AppendMode.APPEND, !this._testMode);
                    this._outputDevice.initializePage(shadowCs, shadowPdPage, (float)currentPage.getHeight((CssContext)c) / this._dotsPerPoint);
                    c.setShadowPageNumber(shadowPageIndex);
                    this.paintPageFast(c, currentPage, shadowPage, -translateX);
                    this._outputDevice.finishPage();
                    translateX += pageContentWidth * (currentPage.getCutOffPageDirection() == IdentValue.LTR ? 1 : -1);
                    ++pdfPageIndex;
                    ++shadowPageIndex;
                }
            }
            if (i == pageCount - 1) continue;
            PageBox nextPage = pages.get(i + 1);
            Rectangle2D.Float nextPageSize = new Rectangle2D.Float(0.0f, 0.0f, (float)nextPage.getWidth((CssContext)c) / this._dotsPerPoint, (float)nextPage.getHeight((CssContext)c) / this._dotsPerPoint);
            PDPage pageNext = this._pageSupplier.requestPage(doc, (float)((RectangularShape)nextPageSize).getWidth(), (float)((RectangularShape)nextPageSize).getHeight(), i + 1, -1);
            PDPageContentStream csNext = new PDPageContentStream(doc, pageNext, PDPageContentStream.AppendMode.APPEND, !this._testMode);
            this._outputDevice.initializePage(csNext, pageNext, (float)((RectangularShape)nextPageSize).getHeight());
        }
        this._outputDevice.finish(c, (Box)this._root);
    }

    private void writePDF(List<PageBox> pages, RenderingContext c, Rectangle2D firstPageSize, PDDocument doc) throws IOException {
        this._outputDevice.setRoot((Box)this._root);
        this._outputDevice.start(this._doc);
        PDPage page = this._pageSupplier.requestPage(doc, (float)firstPageSize.getWidth(), (float)firstPageSize.getHeight(), 0, -1);
        PDPageContentStream cs = new PDPageContentStream(doc, page, PDPageContentStream.AppendMode.APPEND, !this._testMode);
        this._outputDevice.initializePage(cs, page, (float)firstPageSize.getHeight());
        this._root.getLayer().assignPagePaintingPositions((CssContext)c, (short)2);
        int pageCount = this._root.getLayer().getPages().size();
        c.setPageCount(pageCount);
        this.firePreWrite(pageCount);
        this.setDidValues(doc);
        if (this._pdfAConformance != PdfRendererBuilder.PdfAConformance.NONE) {
            this.addPdfASchema(doc, this._pdfAConformance.getPart(), this._pdfAConformance.getConformanceValue());
        }
        for (int i = 0; i < pageCount; ++i) {
            PageBox currentPage = pages.get(i);
            c.setPage(i, currentPage);
            this.paintPage(c, currentPage);
            this._outputDevice.finishPage();
            if (i == pageCount - 1) continue;
            PageBox nextPage = pages.get(i + 1);
            Rectangle2D.Float nextPageSize = new Rectangle2D.Float(0.0f, 0.0f, (float)nextPage.getWidth((CssContext)c) / this._dotsPerPoint, (float)nextPage.getHeight((CssContext)c) / this._dotsPerPoint);
            PDPage pageNext = this._pageSupplier.requestPage(doc, (float)((RectangularShape)nextPageSize).getWidth(), (float)((RectangularShape)nextPageSize).getHeight(), i + 1, -1);
            PDPageContentStream csNext = new PDPageContentStream(doc, pageNext, PDPageContentStream.AppendMode.APPEND, !this._testMode);
            this._outputDevice.initializePage(csNext, pageNext, (float)((RectangularShape)nextPageSize).getHeight());
        }
        this._outputDevice.finish(c, (Box)this._root);
    }

    private void addPdfUaXMPSchema(PDDocument doc) {
        try {
            String title;
            PDDocumentCatalog catalog = doc.getDocumentCatalog();
            String lang = this._doc.getDocumentElement().getAttribute("lang");
            catalog.setLanguage(!lang.isEmpty() ? lang : "EN-US");
            catalog.setViewerPreferences(new PDViewerPreferences(new COSDictionary()));
            catalog.getViewerPreferences().setDisplayDocTitle(true);
            PDMarkInfo markInfo = new PDMarkInfo();
            markInfo.setMarked(true);
            catalog.setMarkInfo(markInfo);
            PDDocumentInformation info = doc.getDocumentInformation();
            String string = title = info.getTitle() != null ? info.getTitle() : "";
            if (title.isEmpty()) {
                XRLog.general((Level)Level.WARNING, (String)"No document title provided. Document will not be PDF/UA compliant.");
            }
            XMPMetadata xmp = XMPMetadata.createXMPMetadata();
            xmp.createAndAddDublinCoreSchema();
            xmp.getDublinCoreSchema().setTitle(title);
            String metaDescription = this._outputDevice.getMetadataByName("description");
            xmp.getDublinCoreSchema().setDescription(metaDescription != null ? metaDescription : title);
            xmp.createAndAddPDFAExtensionSchemaWithDefaultNS();
            xmp.getPDFExtensionSchema().addNamespace("http://www.aiim.org/pdfa/ns/schema#", "pdfaSchema");
            xmp.getPDFExtensionSchema().addNamespace("http://www.aiim.org/pdfa/ns/property#", "pdfaProperty");
            xmp.getPDFExtensionSchema().addNamespace("http://www.aiim.org/pdfua/ns/id/", "pdfuaid");
            XMPSchema uaSchema = new XMPSchema(XMPMetadata.createXMPMetadata(), "pdfaSchema", "pdfaSchema", "pdfaSchema");
            uaSchema.setTextPropertyValue("schema", "PDF/UA Universal Accessibility Schema");
            uaSchema.setTextPropertyValue("namespaceURI", "http://www.aiim.org/pdfua/ns/id/");
            uaSchema.setTextPropertyValue("prefix", "pdfuaid");
            XMPSchema uaProp = new XMPSchema(XMPMetadata.createXMPMetadata(), "pdfaProperty", "pdfaProperty", "pdfaProperty");
            uaProp.setTextPropertyValue("name", "part");
            uaProp.setTextPropertyValue("valueType", "Integer");
            uaProp.setTextPropertyValue("category", "internal");
            uaProp.setTextPropertyValue("description", "Indicates, which part of ISO 14289 standard is followed");
            uaSchema.addUnqualifiedSequenceValue("property", (AbstractField)uaProp);
            xmp.getPDFExtensionSchema().addBagValue("schemas", (AbstractField)uaSchema);
            xmp.getPDFExtensionSchema().setPrefix("pdfuaid");
            xmp.getPDFExtensionSchema().setTextPropertyValue("part", "1");
            XmpSerializer serializer = new XmpSerializer();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            serializer.serialize(xmp, (OutputStream)baos, true);
            PDMetadata metadata = new PDMetadata(doc);
            metadata.importXMPMetadata(baos.toByteArray());
            doc.getDocumentCatalog().setMetadata(metadata);
        }
        catch (IOException | TransformerException e) {
            throw new RuntimeException(e);
        }
    }

    private void addPdfASchema(PDDocument document, int part, String conformance) {
        PDDocumentInformation information = document.getDocumentInformation();
        XMPMetadata metadata = XMPMetadata.createXMPMetadata();
        try {
            String title = information.getTitle();
            String author = information.getAuthor();
            String subject = information.getSubject();
            String keywords = information.getKeywords();
            String producer = information.getProducer();
            PDFAIdentificationSchema pdfaid = metadata.createAndAddPFAIdentificationSchema();
            pdfaid.setConformance(conformance);
            pdfaid.setPart(Integer.valueOf(part));
            AdobePDFSchema pdfSchema = metadata.createAndAddAdobePDFSchema();
            if (keywords != null) {
                pdfSchema.setKeywords(keywords);
            }
            if (producer != null) {
                pdfSchema.setProducer(producer);
            }
            XMPBasicSchema xmpBasicSchema = metadata.createAndAddXMPBasicSchema();
            xmpBasicSchema.setCreateDate(information.getCreationDate());
            DublinCoreSchema dc = metadata.createAndAddDublinCoreSchema();
            if (author != null) {
                dc.addCreator(author);
            }
            if (title != null) {
                dc.setTitle(title);
            }
            if (subject != null) {
                dc.setDescription(subject);
            }
            PDMetadata metadataStream = new PDMetadata(document);
            PDMarkInfo markInfo = new PDMarkInfo();
            markInfo.setMarked(true);
            PDDocumentCatalog catalog = document.getDocumentCatalog();
            catalog.setMetadata(metadataStream);
            catalog.setMarkInfo(markInfo);
            String lang = this._doc.getDocumentElement().getAttribute("lang");
            catalog.setLanguage(!lang.isEmpty() ? lang : "EN-US");
            catalog.setViewerPreferences(new PDViewerPreferences(new COSDictionary()));
            catalog.getViewerPreferences().setDisplayDocTitle(true);
            XmpSerializer serializer = new XmpSerializer();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            serializer.serialize(metadata, (OutputStream)baos, true);
            metadataStream.importXMPMetadata(baos.toByteArray());
            if (this._colorProfile != null) {
                ByteArrayInputStream colorProfile = new ByteArrayInputStream(this._colorProfile);
                PDOutputIntent oi = new PDOutputIntent(document, (InputStream)colorProfile);
                oi.setInfo("sRGB IEC61966-2.1");
                oi.setOutputCondition("sRGB IEC61966-2.1");
                oi.setOutputConditionIdentifier("sRGB IEC61966-2.1");
                oi.setRegistryName("http://www.color.org");
                catalog.addOutputIntent(oi);
            }
        }
        catch (BadFieldValueException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (TransformerException e) {
            throw new RuntimeException(e);
        }
    }

    private void setDidValues(PDDocument doc) {
        PDDocumentInformation info = new PDDocumentInformation();
        info.setCreationDate(Calendar.getInstance());
        if (this._producer == null) {
            info.setProducer("openhtmltopdf.com");
        } else {
            info.setProducer(this._producer);
        }
        for (PdfBoxSlowOutputDevice.Metadata metadata : this._outputDevice.getMetadata()) {
            String content;
            String name = metadata.getName();
            if (name.isEmpty() || (content = metadata.getContent()) == null) continue;
            if (name.equals("title")) {
                info.setTitle(content);
                continue;
            }
            if (name.equals("author")) {
                info.setAuthor(content);
                continue;
            }
            if (name.equals("subject")) {
                info.setSubject(content);
                continue;
            }
            if (name.equals("keywords")) {
                info.setKeywords(content);
                continue;
            }
            info.setCustomMetadataValue(name, content);
        }
        doc.setDocumentInformation(info);
    }

    private void paintPageFast(RenderingContext c, PageBox page, DisplayListContainer.DisplayListPageContainer pageOperations, int additionalTranslateX) {
        page.paintBackground(c, 0, (short)2);
        c.setInPageMargins(true);
        page.paintMarginAreas(c, 0, (short)2);
        c.setInPageMargins(false);
        page.paintBorder(c, 0, (short)2);
        Rectangle content = page.getPrintClippingBounds((CssContext)c);
        this._outputDevice.pushClip(content);
        int top = -page.getPaintingTop() + page.getMarginBorderPadding((CssContext)c, 3);
        int left = page.getMarginBorderPadding((CssContext)c, 1);
        int translateX = left + additionalTranslateX;
        this._outputDevice.translate(translateX, top);
        DisplayListPainter painter = new DisplayListPainter();
        painter.paint(c, pageOperations);
        this._outputDevice.translate(-translateX, -top);
        this._outputDevice.popClip();
    }

    private void paintPage(RenderingContext c, PageBox page) {
        page.paintBackground(c, 0, (short)2);
        page.paintMarginAreas(c, 0, (short)2);
        page.paintBorder(c, 0, (short)2);
        Shape working = this._outputDevice.getClip();
        Rectangle content = page.getPrintClippingBounds((CssContext)c);
        this._outputDevice.clip(content);
        int top = -page.getPaintingTop() + page.getMarginBorderPadding((CssContext)c, 3);
        int left = page.getMarginBorderPadding((CssContext)c, 1);
        this._outputDevice.translate(left, top);
        this._root.getLayer().paint(c);
        this._outputDevice.translate(-left, -top);
        this._outputDevice.setClip(working);
    }

    private String stringfyMetadata(Element element) {
        Element target = PdfBoxRenderer.getFirstChildElement(element);
        if (target == null) {
            return null;
        }
        try {
            TransformerFactory factory = TransformerFactory.newInstance();
            Transformer transformer = factory.newTransformer();
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            StringWriter output = new StringWriter();
            transformer.transform(new DOMSource(target), new StreamResult(output));
            return output.toString();
        }
        catch (TransformerConfigurationException e) {
            throw new RuntimeException(e);
        }
        catch (TransformerException e) {
            throw new RuntimeException(e);
        }
    }

    private static Element getFirstChildElement(Element element) {
        for (Node n = element.getFirstChild(); n != null; n = n.getNextSibling()) {
            if (n.getNodeType() != 1) continue;
            return (Element)n;
        }
        return null;
    }

    private String createXPacket(String metadata) {
        StringBuilder result = new StringBuilder(metadata.length() + 50);
        result.append("<?xpacket begin='\ufeff' id='W5M0MpCehiHzreSzNTczkc9d'?>\n");
        result.append(metadata);
        result.append("\n<?xpacket end='r'?>");
        return result.toString();
    }

    public PdfBoxOutputDevice getOutputDevice() {
        return this._outputDevice;
    }

    public SharedContext getSharedContext() {
        return this._sharedContext;
    }

    @Deprecated
    public void exportText(Writer writer) throws IOException {
        RenderingContext c = this.newRenderingContext();
        c.setPageCount(this._root.getLayer().getPages().size());
        this._root.exportText(c, writer);
    }

    public BlockBox getRootBox() {
        return this._root;
    }

    public float getDotsPerPoint() {
        return this._dotsPerPoint;
    }

    public List<PagePosition> findPagePositionsByID(Pattern pattern) {
        return this._outputDevice.findPagePositionsByID((CssContext)this.newLayoutContext(), pattern);
    }

    public PDFCreationListener getListener() {
        return this._listener;
    }

    public void setListener(PDFCreationListener listener) {
        this._listener = listener;
    }

    @Deprecated
    public void cleanup() {
        this._outputDevice.close();
        this._sharedContext.removeFromThread();
        ThreadCtx.cleanup();
        ((PdfBoxFontResolver)this.getSharedContext().getFontResolver()).close();
        if (this._svgImpl != null) {
            try {
                this._svgImpl.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this._mathmlImpl != null) {
            try {
                this._mathmlImpl.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Override
    public void close() {
        this.cleanup();
    }

    @Override
    public PDPage requestPage(PDDocument doc, float pageWidth, float pageHeight, int pageNumber, int shadowPageNumber) {
        PDPage page = new PDPage(new PDRectangle(pageWidth, pageHeight));
        doc.addPage(page);
        return page;
    }

    private static final class NullUserInterface
    implements UserInterface {
        private NullUserInterface() {
        }

        public boolean isHover(Element e) {
            return false;
        }

        public boolean isActive(Element e) {
            return false;
        }

        public boolean isFocus(Element e) {
            return false;
        }
    }
}

