/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.arjuna.tools.osb.mbean.common;

import com.arjuna.ats.arjuna.tools.osb.annotation.MXBeanPropertyDescription;
import com.arjuna.ats.arjuna.tools.osb.mbean.common.BasicBeanMBean;
import com.arjuna.ats.arjuna.tools.osb.util.JMXServer;
import javax.management.ObjectInstance;

public class BasicBean
implements BasicBeanMBean {
    protected String type;
    protected BasicBean parent;
    protected boolean marked = true;
    protected StringBuilder errorMessages = new StringBuilder();

    public BasicBean() {
    }

    public BasicBean(BasicBean parent, String type) {
        this.type = type;
        this.parent = parent;
    }

    public String getDescription() {
        return "";
    }

    public String getObjectName() {
        throw new RuntimeException("ObjectName is not implemented");
    }

    public BasicBean getParent() {
        return this.parent;
    }

    @Override
    @MXBeanPropertyDescription(value="Record of any errors whilst populating mbean properties")
    public String getMessages() {
        return this.errorMessages.toString();
    }

    protected void clearErrors() {
        this.errorMessages.delete(0, this.errorMessages.length());
    }

    protected void addError(String message) {
        this.errorMessages.append(message).append(System.getProperty("line.separator", "\n"));
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public void refresh() {
        this.clearErrors();
        this.unregisterDependents(true);
        this.register();
    }

    public ObjectInstance register() {
        return JMXServer.getAgent().registerMBean(this);
    }

    public boolean unregister() {
        return JMXServer.getAgent().unregisterMBean(this.getObjectName());
    }

    public void unregisterDependents(boolean markOnly) {
    }

    public boolean equals(Object obj) {
        if (obj instanceof BasicBean) {
            BasicBean bb = (BasicBean)obj;
            return this.getObjectName().equals(bb.getObjectName());
        }
        return false;
    }

    public int hashCode() {
        return this.getObjectName().hashCode();
    }

    public String toString() {
        return this.getObjectName();
    }

    public boolean isMarked() {
        return this.marked;
    }

    public void mark() {
        this.marked = true;
    }
}

