/*
 * Decompiled with CFR 0.152.
 */
package com.jurismarches.vradi.services;

import com.jurismarches.vradi.VradiConstants;
import com.jurismarches.vradi.VradiServiceConfiguration;
import com.jurismarches.vradi.beans.FormPagedResult;
import com.jurismarches.vradi.beans.QueryBean;
import com.jurismarches.vradi.beans.QueryParameters;
import com.jurismarches.vradi.entities.Client;
import com.jurismarches.vradi.entities.Form;
import com.jurismarches.vradi.entities.Group;
import com.jurismarches.vradi.entities.RootThesaurus;
import com.jurismarches.vradi.entities.Sending;
import com.jurismarches.vradi.entities.Session;
import com.jurismarches.vradi.entities.Status;
import com.jurismarches.vradi.entities.Thesaurus;
import com.jurismarches.vradi.entities.User;
import com.jurismarches.vradi.entities.WebHarvestStream;
import com.jurismarches.vradi.entities.XmlFieldBinding;
import com.jurismarches.vradi.entities.XmlStream;
import com.jurismarches.vradi.services.VradiDataService;
import com.jurismarches.vradi.services.VradiException;
import com.jurismarches.vradi.services.managers.BindingManager;
import com.jurismarches.vradi.services.managers.ClientManager;
import com.jurismarches.vradi.services.managers.FormManager;
import com.jurismarches.vradi.services.managers.FormTypeManager;
import com.jurismarches.vradi.services.managers.SearchManager;
import com.jurismarches.vradi.services.managers.ThesaurusManager;
import com.jurismarches.vradi.services.search.UnsupportedQueryException;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.wikitty.BusinessEntity;
import org.nuiton.wikitty.Criteria;
import org.nuiton.wikitty.FieldType;
import org.nuiton.wikitty.PagedResult;
import org.nuiton.wikitty.WikittyExtension;
import org.nuiton.wikitty.WikittyProxy;
import org.nuiton.wikitty.search.Element;
import org.nuiton.wikitty.search.Search;

public class VradiDataServiceImpl
implements VradiDataService {
    private static final Log log = LogFactory.getLog(VradiDataServiceImpl.class);
    protected WikittyProxy wikittyProxy;
    protected ThesaurusManager thesaurusManager;
    protected SearchManager searchManager;
    protected FormManager formManager;
    protected FormTypeManager formTypeManager;
    protected BindingManager bindingManager;
    protected ClientManager clientManager;

    public VradiDataServiceImpl(WikittyProxy wikittyProxy) {
        this.wikittyProxy = wikittyProxy;
        this.initManagers();
    }

    protected void initManagers() {
        this.thesaurusManager = new ThesaurusManager(this.wikittyProxy);
        this.searchManager = new SearchManager(this.wikittyProxy, this.thesaurusManager);
        this.formManager = new FormManager(this.wikittyProxy, this.thesaurusManager, this.searchManager);
        this.formTypeManager = new FormTypeManager(this.wikittyProxy);
        this.clientManager = new ClientManager(this.wikittyProxy);
        this.bindingManager = new BindingManager(this.wikittyProxy, this.formTypeManager, this.formManager);
    }

    protected <T extends BusinessEntity> List<T> findAllByExtension(Class<T> type, String extension, String ... sortFields) {
        Search search = Search.query().eq(Element.ELT_EXTENSION, extension);
        Criteria criteria = search.criteria();
        for (String sortField : sortFields) {
            criteria.addSortAscending(sortField);
        }
        PagedResult findAllByCriteria = this.wikittyProxy.findAllByCriteria(type, criteria);
        List results = findAllByCriteria.getAll();
        return new ArrayList(results);
    }

    @Override
    public List<Client> findAllClients() {
        return this.findAllByExtension(Client.class, "Client", "Client.name");
    }

    @Override
    public List<User> findAllUsers() {
        Search search = Search.query().eq("User.client", "*");
        Criteria criteria = search.criteria();
        PagedResult users = this.wikittyProxy.findAllByCriteria(User.class, criteria);
        return new ArrayList<User>(users.getAll());
    }

    @Override
    public List<Group> findAllGroups() {
        return this.findAllByExtension(Group.class, "Group", "Group.name");
    }

    @Override
    public List<Status> findAllStatus() {
        return this.findAllByExtension(Status.class, "Status", "Status.name");
    }

    @Override
    public List<Group> getGroupsForUser(String userId) throws VradiException {
        Search search = Search.query().eq("Group.user", userId);
        PagedResult groups = this.wikittyProxy.findAllByCriteria(Group.class, search.criteria());
        return groups.getAll();
    }

    @Override
    public boolean deleteStatus(List<String> statusIds) throws VradiException {
        return this.formManager.deleteStatuses(statusIds);
    }

    @Override
    public Status getStatus(VradiConstants.FormStatus formStatus) throws VradiException {
        List<Status> statuses = this.createDefaultStatuses();
        for (Status status : statuses) {
            if (!status.getName().equals(formStatus.getName())) continue;
            return status;
        }
        return null;
    }

    @Override
    public Session getSessionOfSending(String sendingId) throws VradiException {
        return this.formManager.getSessionOfSending(sendingId);
    }

    @Override
    public void deleteClient(String clientId) throws VradiException {
        this.clientManager.deleteClient(clientId);
    }

    @Override
    public void deleteUser(String userId) throws VradiException {
        this.clientManager.deleteUser(userId);
    }

    @Override
    public void deleteGroup(String groupId) throws VradiException {
        this.clientManager.deleteGroup(groupId);
    }

    @Override
    public void deleteXmlStream(String id) throws VradiException {
        this.wikittyProxy.delete(id);
    }

    @Override
    public Map<Group, List<QueryBean>> findQueriesReturningForm(String formId) throws VradiException {
        return this.searchManager.findQueriesReturningForm(formId);
    }

    @Override
    public Map<Group, List<QueryBean>> findQueriesReturningForm(List<Group> groups, String formId) throws VradiException {
        return this.searchManager.findQueriesReturningForm(groups, formId);
    }

    @Override
    public Map<String, FieldType> getFormTypeFields(String name) throws VradiException {
        return this.formTypeManager.getFormTypeFields(name);
    }

    @Override
    public List<Status> createDefaultStatuses() throws VradiException {
        return this.formManager.createDefaultStatuses();
    }

    @Override
    public List<WebHarvestStream> findAllWebHarvest() {
        return this.findAllByExtension(WebHarvestStream.class, "WebHarvestStream", "XmlStream.name");
    }

    @Override
    public List<XmlStream> findAllXmlStreams() {
        return this.findAllByExtension(XmlStream.class, "XmlStream", "XmlStream.name");
    }

    @Override
    public List<User> findClientUsers(String clientId) {
        Search search = Search.query().eq("User.client", clientId);
        Criteria criteria = search.criteria();
        criteria.addSortAscending("User.name");
        PagedResult usersResult = this.wikittyProxy.findAllByCriteria(User.class, criteria);
        List users = usersResult.getAll();
        return users;
    }

    @Override
    public List<Group> findUserGroups(String userId) {
        Search search = Search.query().eq("Group.user", userId);
        Criteria criteria = search.criteria();
        PagedResult groupsResult = this.wikittyProxy.findAllByCriteria(Group.class, criteria);
        List groups = groupsResult.getAll();
        if (log.isDebugEnabled()) {
            log.debug((Object)(groups.size() + " groups found for user " + userId));
        }
        return groups;
    }

    @Override
    public WikittyExtension getFormType(String name) throws VradiException {
        return this.formTypeManager.getFormType(name);
    }

    @Override
    public WikittyExtension updateFormType(String name, Map<String, FieldType> fields, String requires, Map<String, String> tagValues) throws VradiException {
        return this.formTypeManager.updateFormType(name, fields, requires, tagValues);
    }

    @Override
    public WikittyExtension updateFormType(WikittyExtension extension) throws VradiException {
        return this.formTypeManager.updateFormType(extension, null);
    }

    @Override
    public Collection<String> getTemplateFilenames(WikittyExtension extension) {
        return this.formTypeManager.getTemplateFilenames(extension);
    }

    @Override
    public WikittyExtension updateFormType(WikittyExtension extension, String templateName) throws VradiException {
        return this.formTypeManager.updateFormType(extension, templateName);
    }

    @Override
    public FormPagedResult findForms(QueryParameters queryParameters, FormPagedResult formPagedResult) throws UnsupportedQueryException, VradiException {
        FormPagedResult result = this.searchManager.findForms(queryParameters, formPagedResult);
        return result;
    }

    @Override
    public Map<Thesaurus, Integer> getChildrenCartography(String thesaurusId, QueryParameters queryParameters) throws VradiException, UnsupportedQueryException {
        Map<Thesaurus, Integer> thesaurusCartography = this.searchManager.getChildrenCartography(thesaurusId, queryParameters);
        return thesaurusCartography;
    }

    @Override
    public Map<Group, List<QueryBean>> getQueriesToModifyAfterThesaurusModification(String rootThesaurusName, String thesaurusName) {
        return this.thesaurusManager.getQueriesToModifyAfterThesaurusModification(rootThesaurusName, thesaurusName);
    }

    @Override
    public List<XmlFieldBinding> updateXmlFieldBindings(List<XmlFieldBinding> bindings) throws VradiException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"updateXmlFieldBindings(bindings)");
        }
        try {
            ArrayList<XmlFieldBinding> list = new ArrayList<XmlFieldBinding>();
            if (bindings != null) {
                bindings = this.wikittyProxy.store(bindings);
                list.addAll(bindings);
            }
            return list;
        }
        catch (Exception eee) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Can't update xml field bindings", (Throwable)eee);
            }
            throw new VradiException("Can't update xml field bindings", eee);
        }
    }

    @Override
    public List<WikittyExtension> getAllFormTypes() throws VradiException {
        ArrayList<WikittyExtension> extensions = new ArrayList<WikittyExtension>();
        List allExtensionIds = this.wikittyProxy.getAllExtensionsRequires("Form");
        HashMap<String, WikittyExtension> lastVersions = new HashMap<String, WikittyExtension>();
        for (String extensionId : allExtensionIds) {
            String extensionName = WikittyExtension.computeName((String)extensionId);
            if (lastVersions.get(extensionName) != null) continue;
            WikittyExtension extension = this.wikittyProxy.restoreExtensionLastVersion(extensionName);
            extension = this.computeExtension(extension);
            lastVersions.put(extensionName, extension);
        }
        extensions.addAll(lastVersions.values());
        return extensions;
    }

    protected WikittyExtension computeExtension(WikittyExtension extension) {
        String key;
        int i;
        Collection fieldNames = extension.getFieldNames();
        ArrayList<String> fieldOrder = new ArrayList<String>();
        ArrayList<String> orderlessFields = new ArrayList<String>();
        for (String fieldName : fieldNames) {
            FieldType fieldType = extension.getFieldType(fieldName);
            try {
                Integer.valueOf(fieldType.getTagValue("rank"));
                fieldOrder.add(fieldName);
            }
            catch (Exception eee) {
                orderlessFields.add(fieldName);
            }
        }
        LinkedHashMap<String, FieldType> fields = new LinkedHashMap<String, FieldType>();
        int size = fieldOrder.size();
        for (i = 0; i < size; ++i) {
            key = (String)fieldOrder.get(i);
            fields.put(key, extension.getFieldType(key));
        }
        size = orderlessFields.size();
        for (i = 0; i < size; ++i) {
            key = (String)orderlessFields.get(i);
            fields.put(key, extension.getFieldType(key));
        }
        WikittyExtension fieldOrderedExtension = new WikittyExtension(extension.getName(), extension.getVersion(), extension.getRequires(), fields);
        fieldOrderedExtension.setTagValues(extension.getTagValues());
        return fieldOrderedExtension;
    }

    @Override
    public List<Thesaurus> proposeThesaurus(String formId) throws VradiException {
        return this.thesaurusManager.proposeThesaurus(formId);
    }

    @Override
    public List<RootThesaurus> getRootThesaurus() throws VradiException {
        return this.thesaurusManager.getRootThesaurus();
    }

    @Override
    public int getNbFormsForThesaurus(String thesaurusId) throws VradiException {
        return this.thesaurusManager.getNbFormsForThesaurus(thesaurusId);
    }

    @Override
    public List<Thesaurus> getThesaurusAttachedToForm(Form form) {
        return this.thesaurusManager.getThesaurusAttachedToForm(form);
    }

    @Override
    public List<Thesaurus> getChildrenThesaurus(String thesaurusId) throws VradiException {
        return this.thesaurusManager.getChildrenThesaurus(thesaurusId);
    }

    @Override
    public RootThesaurus createRootThesaurus(String rootThesaurusName) throws VradiException {
        return this.thesaurusManager.createRootThesaurus(rootThesaurusName);
    }

    @Override
    public List<String> deleteThesaurus(String thesaurusId) throws VradiException {
        return this.thesaurusManager.deleteThesaurus(thesaurusId);
    }

    @Override
    public void deleteAllThesaurus() throws VradiException {
        this.thesaurusManager.deleteAllThesaurus();
    }

    @Override
    public boolean isThesaurusNameExistsInRootThesaurus(RootThesaurus rootThesaurus, String thesaurusName) {
        return this.thesaurusManager.isThesaurusNameExistsInRootThesaurus(rootThesaurus, thesaurusName);
    }

    @Override
    public boolean isThesaurusNameExistsInRootThesaurus(RootThesaurus rootThesaurus, String thesaurusName, String exceptedThesaurusId) {
        return this.thesaurusManager.isThesaurusNameExistsInRootThesaurus(rootThesaurus, thesaurusName, exceptedThesaurusId);
    }

    @Override
    public boolean isRootThesaurusNameExists(String rootThesaurusName) {
        return this.thesaurusManager.isRootThesaurusNameExists(rootThesaurusName);
    }

    @Override
    public boolean isRootThesaurusNameExists(String rootThesaurusName, String exceptedRootThesaurusId) {
        return this.thesaurusManager.isRootThesaurusNameExists(rootThesaurusName, exceptedRootThesaurusId);
    }

    @Override
    public boolean isFormTypeExists(String formTypeName) throws VradiException {
        return this.formTypeManager.isFormTypeExists(formTypeName);
    }

    @Override
    public WikittyExtension createFormType(String formTypeName) throws VradiException {
        return this.formTypeManager.createFormType(formTypeName);
    }

    @Override
    public boolean checkUserEmail(Sending sending) {
        String emailUser;
        String userId = sending.getUser();
        User user = (User)this.wikittyProxy.restore(User.class, userId);
        return user != null && StringUtils.isBlank((String)(emailUser = user.getEmail()));
    }

    @Override
    public Session getSessionBySending(String sendingId) {
        Search query = Search.query();
        query.eq(Element.ELT_EXTENSION, "Session");
        query.contains("Session.sending", sendingId);
        Criteria criteria = query.criteria();
        Session session = (Session)this.wikittyProxy.findByCriteria(Session.class, criteria);
        return session;
    }

    @Override
    public List<Session> getSessions(Date sessionDate) throws VradiException {
        return this.formManager.getSessions(sessionDate);
    }

    @Override
    public Session getLastCloseSession() throws VradiException {
        return this.formManager.getLastCloseSession();
    }

    @Override
    public Session getLastOpenSession() throws VradiException {
        return this.formManager.getLastOpenSession();
    }

    @Override
    public List<String> getAllWebHarvestScripts() {
        File scriptDir = VradiServiceConfiguration.getInstance(new String[0]).getWebHarvestScriptDir();
        ArrayList<String> files = new ArrayList<String>();
        for (File file : scriptDir.listFiles()) {
            if (!file.isFile()) continue;
            files.add(file.getName());
        }
        return files;
    }

    @Override
    public String getWebHarvestPreviewURL(WebHarvestStream stream) throws VradiException {
        return this.bindingManager.getWebHarvestPreviewUrlAsString(stream);
    }
}

