package com.jurismarches.vradi.services.dto;

import com.jurismarches.vradi.entities.XmlFieldBinding;
import com.jurismarches.vradi.entities.XmlFieldBindingBean;

import java.util.HashSet;

/**
 * User: chemit
 * Date: 29 oct. 2009
 * Time: 22:33:15
 */
public class VradiXmlFieldBindingDTO extends XmlFieldBindingBean implements VradiDTO<XmlFieldBinding> {

    private static final long serialVersionUID = 1L;

    public VradiXmlFieldBindingDTO() {
        XmlFieldBinding$xmlField = new HashSet<String>();
    }

    @Override
    public void fromWikitty(XmlFieldBinding wikitty) {
        if (wikitty == null) {
            reset();
        } else {
            setWikittyId(wikitty.getWikittyId());
            setFormField(wikitty.getFormField());
            XmlFieldBinding$xmlField = wikitty.getXmlField();
        }
    }

    @Override
    public void reset() {
        setWikittyId(null);
        setFormField(null);
        XmlFieldBinding$xmlField = new HashSet<String>();
    }

    @Override
    public void toWikitty(XmlFieldBinding wikitty) {

        wikitty.setFormField(getFormField());
        wikitty.clearXmlField();
        for (String xmlField : getXmlField()) {
            wikitty.addXmlField(xmlField);
        }
    }

    public void setWikittyId(String id) {
        String old = this.id;
        this.id = id;
        propertyChange.firePropertyChange("wikittyId", old, id);
    }
}