package com.jurismarches.vradi.services.dto;

import org.sharengo.wikitty.BusinessEntity;

import java.beans.PropertyChangeListener;

/**
 * User: chemit
 * Date: 29 oct. 2009
 * Time: 22:15:58
 */
public interface VradiDTO<E> {//extends BusinessEntity {

    /**
     * Remplit le bean à partir d'un wikitty.
     *
     * @param wikitty le wikitty source
     */
    void fromWikitty(E wikitty);

    /**
     * Remplit le wikitty à partir du bean.
     *
     * @param wikitty le wikitty a remplir
     */
    void toWikitty(E wikitty);

    /**
     * Vide le dto
     */
    void reset();

    /**
     * Ajoute un listener gloable
     *
     * @param listener le listener à ajouter
     */
    void addPropertyChangeListener(PropertyChangeListener listener);

    /**
     * Supprime un listener globable.
     *
     * @param listener le listener à supprimer
     */
    void removePropertyChangeListener(PropertyChangeListener listener);

    /**
     * Ajoute un listener sur la propriété {@code propertyName}
     *
     * @param propertyName le nom de la propriété
     * @param listener     le listener à ajouter
     */
    void addPropertyChangeListener(String propertyName, PropertyChangeListener listener);

    /**
     * Supprime un listener sur la propriété {@code propertyName}
     *
     * @param propertyName le nom de la propriété
     * @param listener     le listener à supprimer
     */
    void removePropertyChangeListener(String propertyName, PropertyChangeListener listener);


}
