package com.jurismarches.vradi.services;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;

/**
 * @author morin
 */
public class XmlStreamServiceImpl implements XmlStreamService {

    static private final Log log = LogFactory.getLog(VradiStorageServiceImpl.class);

    protected static String item = "item";
    protected static String channel = "channel";

    @Override
    public List<String> getRSSFields(String url) {
        if (log.isDebugEnabled()) {
            log.debug("getRSSFields");
        }
        List<String> result = new ArrayList<String>();
        try {
            SAXBuilder sxb = new SAXBuilder();
            URL rssUrl = new URL(url);
            Document document = sxb.build(rssUrl);
            Element racine = document.getRootElement();
            Element itemElt = racine.getChild(channel).getChild(item);
            for (Element elt : (List<Element>) itemElt.getChildren()) {
                result.add(elt.getName());
            }
        } catch (Exception eee) {
            eee.printStackTrace();
        }
        return result;
    }

    public void test(String url) {
        if (log.isDebugEnabled()) {
            log.debug("test");
        }
        try {
            SAXBuilder sxb = new SAXBuilder();
//"http://www.oecd.org/RSS_channel/0,3045,fr_21571361_33635822_33699151_1_1_1_1,00.xml"
            URL rssUrl = new URL(url);
            Document document = sxb.build(rssUrl);
            Element racine = document.getRootElement();
            //Element chan = racine.getChild(channel);

            for (Element elt : (List<Element>) racine.getChildren()) {
                browseRSS(elt.getChildren());
            }
        } catch (Exception e) {
            System.out.println(e);
        }
    }

    protected void browseRSS(List<Element> list) {
        if (log.isDebugEnabled()) {
            log.debug("browseRSS");
        }
        for (Element aList : list) {
            Element e = aList;
            if (!e.getTextTrim().isEmpty()) {
                //TODO utiliser une logger plutôt !
                System.out.println(e.getQualifiedName() + " " + e.getTextTrim());
            }
            browseRSS(e.getChildren());
        }
        System.out.println("");
    }

}
