/*
 * Decompiled with CFR 0.152.
 */
package com.jolbox.bonecp.spring;

import java.lang.reflect.Method;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import org.springframework.jdbc.support.nativejdbc.NativeJdbcExtractorAdapter;
import org.springframework.util.ReflectionUtils;

public class BoneCPNativeJdbcExtractor
extends NativeJdbcExtractorAdapter {
    private final Class<?> connectionHandleClass;
    private final Class<?> statementHandleClass;
    private final Method getInternalConnectionMethod;
    private final Method getInternalStatementMethod;

    public BoneCPNativeJdbcExtractor() {
        ClassLoader cl = ((Object)((Object)this)).getClass().getClassLoader();
        try {
            this.connectionHandleClass = cl.loadClass("com.jolbox.bonecp.ConnectionHandle");
            this.statementHandleClass = cl.loadClass("com.jolbox.bonecp.StatementHandle");
            this.getInternalConnectionMethod = this.connectionHandleClass.getMethod("getInternalConnection", new Class[0]);
            this.getInternalStatementMethod = this.statementHandleClass.getMethod("getInternalStatement", new Class[0]);
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to initialize because BoneCP API classes are not available", e);
        }
    }

    protected Connection doGetNativeConnection(Connection conn) throws SQLException {
        if (this.connectionHandleClass.isAssignableFrom(conn.getClass())) {
            return (Connection)ReflectionUtils.invokeJdbcMethod((Method)this.getInternalConnectionMethod, (Object)conn);
        }
        return conn;
    }

    public Statement getNativeStatement(Statement stmt) throws SQLException {
        if (this.statementHandleClass.isAssignableFrom(stmt.getClass())) {
            return (Statement)ReflectionUtils.invokeJdbcMethod((Method)this.getInternalStatementMethod, (Object)stmt);
        }
        return stmt;
    }

    public PreparedStatement getNativePreparedStatement(PreparedStatement ps) throws SQLException {
        return (PreparedStatement)this.getNativeStatement(ps);
    }

    public CallableStatement getNativeCallableStatement(CallableStatement cs) throws SQLException {
        return (CallableStatement)this.getNativeStatement(cs);
    }
}

