/*
 * Decompiled with CFR 0.152.
 */
package com.jerolba.carpet.impl.write;

import com.jerolba.carpet.model.BigDecimalType;
import com.jerolba.carpet.model.BinaryLogicalType;
import com.jerolba.carpet.model.BinaryType;
import com.jerolba.carpet.model.BooleanType;
import com.jerolba.carpet.model.ByteType;
import com.jerolba.carpet.model.DoubleType;
import com.jerolba.carpet.model.EnumType;
import com.jerolba.carpet.model.FieldType;
import com.jerolba.carpet.model.FloatType;
import com.jerolba.carpet.model.InstantType;
import com.jerolba.carpet.model.IntegerType;
import com.jerolba.carpet.model.ListType;
import com.jerolba.carpet.model.LocalDateTimeType;
import com.jerolba.carpet.model.LocalDateType;
import com.jerolba.carpet.model.LocalTimeType;
import com.jerolba.carpet.model.LongType;
import com.jerolba.carpet.model.MapType;
import com.jerolba.carpet.model.SetType;
import com.jerolba.carpet.model.ShortType;
import com.jerolba.carpet.model.StringType;
import com.jerolba.carpet.model.UuidType;
import com.jerolba.carpet.model.WriteRecordModelType;

class FieldTypeInspect {
    private final FieldType fieldType;

    public FieldTypeInspect(FieldType fieldType) {
        this.fieldType = fieldType;
    }

    public boolean isInteger() {
        return this.fieldType instanceof IntegerType;
    }

    public boolean isLong() {
        return this.fieldType instanceof LongType;
    }

    public boolean isShort() {
        return this.fieldType instanceof ShortType;
    }

    public boolean isByte() {
        return this.fieldType instanceof ByteType;
    }

    public boolean isDouble() {
        return this.fieldType instanceof DoubleType;
    }

    public boolean isFloat() {
        return this.fieldType instanceof FloatType;
    }

    public boolean isBoolean() {
        return this.fieldType instanceof BooleanType;
    }

    public boolean isString() {
        return this.fieldType instanceof StringType;
    }

    public boolean isBinary() {
        return this.fieldType instanceof BinaryType;
    }

    public boolean isEnum() {
        return this.fieldType instanceof EnumType;
    }

    public boolean isUuid() {
        return this.fieldType instanceof UuidType;
    }

    public boolean isBigDecimal() {
        return this.fieldType instanceof BigDecimalType;
    }

    public boolean isLocalDate() {
        return this.fieldType instanceof LocalDateType;
    }

    public boolean isLocalTime() {
        return this.fieldType instanceof LocalTimeType;
    }

    public boolean isLocalDateTime() {
        return this.fieldType instanceof LocalDateTimeType;
    }

    public boolean isInstant() {
        return this.fieldType instanceof InstantType;
    }

    public boolean isRecord() {
        return this.fieldType instanceof WriteRecordModelType;
    }

    public boolean isCollection() {
        return this.fieldType instanceof ListType || this.fieldType instanceof SetType;
    }

    public boolean isMap() {
        return this.fieldType instanceof MapType;
    }

    public BinaryLogicalType binaryLogicalType() {
        FieldType fieldType = this.fieldType;
        if (fieldType instanceof BinaryType) {
            BinaryType binary = (BinaryType)fieldType;
            return binary.logicalType();
        }
        fieldType = this.fieldType;
        if (fieldType instanceof StringType) {
            StringType string = (StringType)fieldType;
            return string.logicalType();
        }
        fieldType = this.fieldType;
        if (fieldType instanceof EnumType) {
            EnumType enumType = (EnumType)fieldType;
            return enumType.logicalType();
        }
        throw new IllegalStateException("Field type is not a binary type");
    }
}

