/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.local.shared.access.sqlite;

import com.almworks.sqlite4java.SQLiteException;
import com.almworks.sqlite4java.SQLiteStatement;
import com.amazonaws.services.dynamodbv2.local.shared.access.sqlite.AmazonDynamoDBOfflineSQLiteJob;
import com.amazonaws.services.dynamodbv2.local.shared.access.sqlite.SQLiteDBAccess;
import com.amazonaws.services.dynamodbv2.local.shared.access.sqlite.TableSchemaInfo;
import com.amazonaws.services.dynamodbv2.local.shared.exceptions.LocalDBAccessException;
import com.amazonaws.services.dynamodbv2.local.shared.exceptions.LocalDBAccessExceptionType;
import com.amazonaws.services.dynamodbv2.local.shared.mapper.DynamoDBObjectMapper;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import java.io.IOException;

public abstract class SQLiteDBAccessJob<T>
extends AmazonDynamoDBOfflineSQLiteJob<T> {
    private static final DynamoDBObjectMapper MAPPER = new DynamoDBObjectMapper();

    protected TableSchemaInfo getTableSchemaInfo(String tableName) throws SQLiteException, JsonParseException, JsonMappingException, IOException {
        String sql = String.format("SELECT %s FROM %s WHERE %s = %s;", "TableInfo", "dm", "TableName", SQLiteDBAccess.escapedTableName(tableName));
        SQLiteStatement statement = this.getPreparedStatement(sql);
        if (!statement.step()) {
            throw new LocalDBAccessException(LocalDBAccessExceptionType.TABLE_NOT_FOUND);
        }
        return (TableSchemaInfo)MAPPER.readValue(statement.columnBlob(0), TableSchemaInfo.class);
    }
}

