/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.maven.plugins.android;

import com.android.SdkConstants;
import com.android.sdklib.AndroidTargetHash;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.BuildToolInfo;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.SdkManager;
import com.android.utils.ILogger;
import com.android.utils.NullLogger;
import com.jayway.maven.plugins.android.InvalidConfigurationException;
import com.jayway.maven.plugins.android.InvalidSdkException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import org.apache.maven.plugin.MojoExecutionException;

public class AndroidSdk {
    private static final String SOURCE_PROPERTIES_FILENAME = "source.properties";
    private static final String SDK_TOOLS_REVISION_PROPERTY = "Pkg.Revision";
    private static final String PLATFORMS_FOLDER_NAME = "platforms";
    private static final String PARAMETER_MESSAGE = "Please provide a proper Android SDK directory path as configuration parameter <sdk><path>...</path></sdk> in the plugin <configuration/>. As an alternative, you may add the parameter to commandline: -Dandroid.sdk.path=... or set environment variable ANDROID_HOME.";
    private final File sdkPath;
    private File platformToolsPath;
    private File toolsPath;
    private IAndroidTarget androidTarget;
    private SdkManager sdkManager;
    private int sdkMajorVersion;

    public AndroidSdk(File sdkPath, String apiLevel) {
        this.sdkPath = sdkPath;
        if (sdkPath != null) {
            this.sdkManager = SdkManager.createManager((String)sdkPath.getPath(), (ILogger)new NullLogger());
            this.platformToolsPath = new File(sdkPath, "platform-tools");
            this.toolsPath = new File(sdkPath, "tools");
            if (this.sdkManager == null) {
                throw this.invalidSdkException(sdkPath, apiLevel);
            }
        }
        this.loadSDKToolsMajorVersion();
        if (apiLevel == null) {
            throw new InvalidConfigurationException(" No Android API Level has been configured.  Add e.g. <sdk><platform>17</platform></sdk> to the plugin configuration.");
        }
        this.androidTarget = this.findPlatformByApiLevel(apiLevel);
        if (this.androidTarget == null) {
            throw this.invalidSdkException(sdkPath, apiLevel);
        }
    }

    private InvalidSdkException invalidSdkException(File sdkPath, String platformOrApiLevel) {
        throw new InvalidSdkException("Invalid SDK: Platform/API level " + platformOrApiLevel + " not available. This command should give you all you need:\n" + sdkPath.getAbsolutePath() + File.separator + "tools" + File.separator + "android update sdk --no-ui --obsolete --force");
    }

    private IAndroidTarget findPlatformByApiLevel(String apiLevel) {
        AndroidVersion version = null;
        try {
            version = new AndroidVersion(apiLevel);
            String hashString = AndroidTargetHash.getPlatformHashString((AndroidVersion)version);
            IAndroidTarget target = this.sdkManager.getTargetFromHashString(hashString);
            if (target != null) {
                return target;
            }
        }
        catch (AndroidVersion.AndroidVersionException ignore) {
            throw new InvalidSdkException("Error AndroidVersion: " + ignore.getMessage());
        }
        for (IAndroidTarget t : this.sdkManager.getTargets()) {
            if (!t.isPlatform() || !t.getVersionName().equals(apiLevel)) continue;
            return t;
        }
        return null;
    }

    private void assertPathIsDirectory(File path) {
        if (path == null) {
            throw new InvalidSdkException(PARAMETER_MESSAGE);
        }
        if (!path.isDirectory()) {
            throw new InvalidSdkException("Path \"" + path + "\" is not a directory. " + PARAMETER_MESSAGE);
        }
    }

    public String getAaptPath() {
        return this.getPathForBuildTool(BuildToolInfo.PathId.AAPT);
    }

    public String getAidlPath() {
        return this.getPathForBuildTool(BuildToolInfo.PathId.AIDL);
    }

    public String getDxJarPath() {
        return this.getPathForBuildTool(BuildToolInfo.PathId.DX_JAR);
    }

    public String getAdbPath() {
        return this.getPathForPlatformTool(SdkConstants.FN_ADB);
    }

    public String getZipalignPath() {
        return this.getPathForTool(SdkConstants.FN_ZIPALIGN);
    }

    public String getLintPath() {
        return this.getPathForTool("lint" + AndroidSdk.ext(".bat", ""));
    }

    public String getMonkeyRunnerPath() {
        return this.getPathForTool("monkeyrunner" + AndroidSdk.ext(".bat", ""));
    }

    public String getApkBuilderPath() {
        return this.getPathForTool("apkbuilder" + AndroidSdk.ext(".bat", ""));
    }

    public String getAndroidPath() {
        return this.getPathForTool(SdkConstants.androidCmdName());
    }

    public File getToolsPath() {
        return this.toolsPath;
    }

    private String getPathForBuildTool(BuildToolInfo.PathId pathId) {
        if (this.androidTarget != null) {
            return this.androidTarget.getBuildToolInfo().getPath(pathId);
        }
        return this.sdkManager.getLatestBuildTool().getPath(pathId);
    }

    private String getPathForPlatformTool(String tool) {
        return new File(this.platformToolsPath, tool).getAbsolutePath();
    }

    private String getPathForTool(String tool) {
        return new File(this.toolsPath, tool).getAbsolutePath();
    }

    private static String ext(String windowsExtension, String nonWindowsExtension) {
        if (SdkConstants.currentPlatform() == 2) {
            return windowsExtension;
        }
        return nonWindowsExtension;
    }

    public String getPathForFrameworkAidl() {
        return this.androidTarget.getPath(2);
    }

    public File getAndroidJar() throws MojoExecutionException {
        return new File(this.androidTarget.getPath(1));
    }

    public File getSdkPath() throws MojoExecutionException {
        if (this.sdkPath.exists()) {
            return this.sdkPath;
        }
        throw new MojoExecutionException("Can't find the SDK directory : " + this.sdkPath.getAbsolutePath());
    }

    public File getPlatform() {
        File platformDirectory;
        this.assertPathIsDirectory(this.sdkPath);
        File platformsDirectory = new File(this.sdkPath, PLATFORMS_FOLDER_NAME);
        this.assertPathIsDirectory(platformsDirectory);
        if (this.androidTarget == null) {
            IAndroidTarget latestTarget = null;
            for (IAndroidTarget target : this.sdkManager.getTargets()) {
                if (!target.isPlatform() || latestTarget != null && target.getVersion().getApiLevel() <= latestTarget.getVersion().getApiLevel()) continue;
                latestTarget = target;
            }
            platformDirectory = new File(latestTarget.getLocation());
        } else {
            platformDirectory = new File(this.androidTarget.getLocation());
        }
        this.assertPathIsDirectory(platformDirectory);
        return platformDirectory;
    }

    private void loadSDKToolsMajorVersion() {
        File propFile = new File(this.sdkPath, "tools/source.properties");
        Properties properties = new Properties();
        try {
            properties.load(new FileInputStream(propFile));
        }
        catch (IOException e) {
            throw new InvalidSdkException("Error reading " + propFile.getAbsoluteFile());
        }
        if (properties.containsKey(SDK_TOOLS_REVISION_PROPERTY)) {
            try {
                String majorVersion;
                String versionString = properties.getProperty(SDK_TOOLS_REVISION_PROPERTY);
                if (versionString.matches(".*[\\.| ].*")) {
                    String[] versions = versionString.split("[\\.| ]");
                    majorVersion = versions[0];
                } else {
                    majorVersion = versionString;
                }
                this.sdkMajorVersion = Integer.parseInt(majorVersion);
            }
            catch (NumberFormatException e) {
                throw new InvalidSdkException("Error - The property 'Pkg.Revision' in the SDK source.properties file  number is not an Integer: " + properties.getProperty(SDK_TOOLS_REVISION_PROPERTY));
            }
        }
    }

    public int getSdkMajorVersion() {
        return this.sdkMajorVersion;
    }
}

