/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.maven.plugins.android.phase05compile;

import com.jayway.maven.plugins.android.AbstractAndroidMojo;
import com.jayway.maven.plugins.android.AndroidNdk;
import com.jayway.maven.plugins.android.CommandExecutor;
import com.jayway.maven.plugins.android.ExecutionException;
import com.jayway.maven.plugins.android.configuration.Ndk;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;

public class NdkBuildMojo
extends AbstractAndroidMojo {
    private Ndk ndk;
    private File ndkPath;
    protected String ndkClassifier;
    protected String ndkBuildAdditionalCommandline;
    protected boolean clearNativeArtifacts = false;
    protected boolean attachNativeArtifacts;
    public static final String ENV_ANDROID_NDK_HOME = "ANDROID_NDK_HOME";
    protected File ndkOutputDirectory;
    private File nativeLibrariesDirectory;
    protected String ndkArchitecture = "armeabi";

    public void execute() throws MojoExecutionException, MojoFailureException {
        File nativeLibDirectory = new File(this.nativeLibrariesDirectory, this.ndkArchitecture);
        boolean libsDirectoryExists = nativeLibDirectory.exists();
        File directoryToRemove = nativeLibDirectory;
        if (!libsDirectoryExists) {
            this.getLog().info((CharSequence)("Creating native output directory " + nativeLibDirectory));
            if (nativeLibDirectory.getParentFile().exists()) {
                nativeLibDirectory.mkdir();
            } else {
                nativeLibDirectory.mkdirs();
                directoryToRemove = nativeLibDirectory.getParentFile();
            }
        }
        CommandExecutor executor = CommandExecutor.Factory.createDefaultCommmandExecutor();
        executor.setLogger(this.getLog());
        ArrayList<String> commands = new ArrayList<String>();
        commands.add("-C");
        commands.add(this.project.getBasedir().getAbsolutePath());
        if (this.ndkBuildAdditionalCommandline != null) {
            String[] additionalCommands;
            for (String command : additionalCommands = this.ndkBuildAdditionalCommandline.split(" ")) {
                commands.add(command);
            }
        }
        String ndkBuildPath = this.getAndroidNdk().getNdkBuildPath();
        this.getLog().info((CharSequence)(ndkBuildPath + " " + ((Object)commands).toString()));
        try {
            executor.executeCommand(ndkBuildPath, commands, this.project.getBasedir(), true);
        }
        catch (ExecutionException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
        if (this.clearNativeArtifacts) {
            File destinationDirectory = new File(this.ndkOutputDirectory.getAbsolutePath(), "/" + this.ndkArchitecture);
            try {
                if (!libsDirectoryExists) {
                    FileUtils.moveDirectory((File)nativeLibDirectory, (File)destinationDirectory);
                } else {
                    FileUtils.copyDirectory((File)nativeLibDirectory, (File)destinationDirectory);
                    FileUtils.cleanDirectory((File)nativeLibDirectory);
                }
                nativeLibDirectory = destinationDirectory;
            }
            catch (IOException e) {
                throw new MojoExecutionException(e.getMessage(), (Exception)e);
            }
        }
        if (!libsDirectoryExists) {
            this.getLog().info((CharSequence)"Cleaning up native library output directory after build");
            if (!directoryToRemove.delete()) {
                this.getLog().warn((CharSequence)"Could not remove directory, marking as delete on exit");
                directoryToRemove.deleteOnExit();
            }
        }
        if ("so".equals(this.project.getPackaging()) || this.attachNativeArtifacts) {
            File[] files = nativeLibDirectory.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.endsWith(".so");
                }
            });
            if (files == null || files.length != 1) {
                this.getLog().warn((CharSequence)("Error while detecting native compile artifacts: " + (files == null || files.length == 0 ? "None found" : "Found more than 1 artifact")));
                if (files != null) {
                    this.getLog().warn((CharSequence)"Currently, only a single, final native library is supported by the build");
                }
            } else {
                this.getLog().debug((CharSequence)("Adding native compile artifact: " + files[0]));
                this.projectHelper.attachArtifact(this.project, "so", this.ndkClassifier != null ? this.ndkClassifier : this.ndkArchitecture, files[0]);
            }
        }
    }

    protected AndroidNdk getAndroidNdk() throws MojoExecutionException {
        File chosenNdkPath = this.ndk != null ? (this.ndk.getPath() != null ? this.ndk.getPath() : (this.ndkPath != null ? this.ndkPath : new File(this.getAndroidNdkHomeOrThrow()))) : (this.ndkPath != null ? this.ndkPath : new File(this.getAndroidNdkHomeOrThrow()));
        return new AndroidNdk(chosenNdkPath);
    }

    private String getAndroidNdkHomeOrThrow() throws MojoExecutionException {
        String androidHome = System.getenv(ENV_ANDROID_NDK_HOME);
        if (StringUtils.isBlank((String)androidHome)) {
            throw new MojoExecutionException("No Android NDK path could be found. You may configure it in the pom using <ndk><path>...</path></ndk> or <properties><ndk.path>...</ndk.path></properties> or on command-line using -Dandroid.ndk.path=... or by setting environment variable ANDROID_NDK_HOME");
        }
        return androidHome;
    }
}

