/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.tdb.index.btree;

import com.hp.hpl.jena.tdb.base.record.RecordFactory;

public final class BTreeParams {
    public static boolean CheckingBTree = false;
    public static boolean CheckingNode = false;
    public static boolean DumpTree = false;
    public static boolean Logging = true;
    private static final int Gap = 0;
    public static final int RootParent = -2;
    public static final int NoParent = -99;
    final int order;
    final RecordFactory recordFactory;
    final int MaxRecNonLeaf;
    final int MaxRecLeaf;
    final int MaxPtr;
    final int MinRec;
    final int MinPtr;
    final int SplitIndex;
    final int HighRecNonLeaf;
    final int HighRecLeaf;
    final int HighPtr;
    static int BlockHeaderSize = 4;

    public String toString() {
        return String.format("Order=%d : Record factory=%s : records=[%d,%d/%d] : pointers=[%d,%d] : split=%d", this.order, this.recordFactory, this.MinRec, this.MaxRecNonLeaf, this.MaxRecLeaf, this.MinPtr, this.MaxPtr, this.SplitIndex);
    }

    public BTreeParams(int order, int keyLen, int valLen) {
        this(order, new RecordFactory(keyLen, valLen));
    }

    public BTreeParams(int order, RecordFactory factory) {
        if (order < 2) {
            throw new IllegalArgumentException("BTree: illegal order (min 2): " + order);
        }
        this.order = order;
        this.recordFactory = factory;
        this.MaxRecNonLeaf = 2 * order - 1 + 0;
        this.MaxPtr = 2 * order + 0;
        this.MinRec = order - 1;
        this.MinPtr = order;
        this.SplitIndex = order - 1 + 0;
        this.HighRecNonLeaf = this.MaxRecNonLeaf - 1;
        this.HighPtr = this.MaxPtr - 1;
        this.MaxRecLeaf = this.MaxRecNonLeaf;
        this.HighRecLeaf = this.HighRecNonLeaf;
    }

    public int getOrder() {
        return this.order;
    }

    public static int getPtrLength() {
        return 4;
    }

    public int getRecordLength() {
        return this.recordFactory.recordLength();
    }

    public RecordFactory getRecordFactory() {
        return this.recordFactory;
    }

    public int getBlockSize() {
        return BTreeParams.calcBlockSize(this.order, this.recordFactory);
    }

    public static int calcOrder(int blockSize, RecordFactory factory) {
        return BTreeParams.calcOrder(blockSize, factory.recordLength());
    }

    public static int calcOrder(int blockSize, int recordLength) {
        int X = ((blockSize -= BlockHeaderSize) - recordLength) / (recordLength + 4);
        int order = (X + 1 - 0) / 2;
        return order;
    }

    public static int calcBlockSize(int bTreeOrder, RecordFactory factory) {
        BTreeParams p = new BTreeParams(bTreeOrder, factory);
        int x = p.getMaxRecNonLeaf() * factory.recordLength() + p.getMaxPtr() * 4;
        return x += BlockHeaderSize;
    }

    public int getMaxRecNonLeaf() {
        return this.MaxRecNonLeaf;
    }

    public int getMaxRecLeaf() {
        return this.MaxRecLeaf;
    }

    public int getMaxPtr() {
        return this.MaxPtr;
    }

    public int getMinRec() {
        return this.MinRec;
    }

    public int getMinPtr() {
        return this.MinPtr;
    }
}

