/*
 * Decompiled with CFR 0.152.
 */
package org.openjena.riot.lang;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.GraphEvents;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.sparql.SystemARQ;
import org.openjena.atlas.event.Event;
import org.openjena.atlas.event.EventListener;
import org.openjena.atlas.event.EventManager;
import org.openjena.atlas.event.EventType;
import org.openjena.atlas.lib.Sink;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SinkToGraph
implements Sink<Triple> {
    static final EventType startRead = new EventType("SinkToGraph.StartRead");
    static final EventType finishRead = new EventType("SinkToGraph.FinishRead");
    protected final Graph graph;
    private EventListener el1;
    private EventListener el2;

    protected SinkToGraph(Graph g) {
        this.graph = g;
        this.el1 = new EventListener(){

            public void event(Object dest, Event event) {
                SinkToGraph.this.graph.getEventManager().notifyEvent(SinkToGraph.this.graph, (Object)GraphEvents.startRead);
            }
        };
        this.el2 = new EventListener(){

            public void event(Object dest, Event event) {
                SinkToGraph.this.graph.getEventManager().notifyEvent(SinkToGraph.this.graph, (Object)GraphEvents.finishRead);
            }
        };
        EventManager.register(this, startRead, this.el1);
        EventManager.register(this, finishRead, this.el2);
    }

    @Override
    public void flush() {
        SystemARQ.sync(this.graph);
    }

    @Override
    public void close() {
        EventManager.unregister(this, finishRead, this.el2);
        EventManager.unregister(this, startRead, this.el1);
    }
}

