/*
 * Decompiled with CFR 0.152.
 */
package org.openjena.riot;

import com.hp.hpl.jena.graph.Factory;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.sparql.core.DatasetGraph;
import com.hp.hpl.jena.sparql.core.Quad;
import com.hp.hpl.jena.sparql.lib.DatasetLib;
import java.io.InputStream;
import org.openjena.atlas.io.IO;
import org.openjena.atlas.lib.IRILib;
import org.openjena.atlas.lib.Sink;
import org.openjena.riot.Lang;
import org.openjena.riot.RiotException;
import org.openjena.riot.RiotReader;
import org.openjena.riot.lang.LangRIOT;
import org.openjena.riot.lang.SinkQuadsToDataset;
import org.openjena.riot.lang.SinkTriplesToGraph;
import org.openjena.riot.tokens.Tokenizer;
import org.openjena.riot.tokens.TokenizerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RiotLoader {
    public static DatasetGraph load(String filename) {
        return RiotLoader.load(filename, null);
    }

    public static DatasetGraph load(String filename, Lang lang) {
        return RiotLoader.load(filename, lang, null);
    }

    public static DatasetGraph load(String filename, Lang lang, String baseURI) {
        if (lang == null) {
            lang = Lang.guess(filename, Lang.NQUADS);
        }
        DatasetGraph dsg = DatasetLib.createDatasetGraphMem();
        RiotLoader.read(filename, dsg, lang, baseURI);
        return dsg;
    }

    public static DatasetGraph datasetFromString(String string, Lang language, String baseURI) {
        DatasetGraph dsg = DatasetLib.createDatasetGraphMem();
        Sink<Quad> sink = RiotLoader.datasetSink(dsg);
        Tokenizer tokenizer = TokenizerFactory.makeTokenizerString(string);
        LangRIOT parser = RiotReader.createParserQuads(tokenizer, language, baseURI, sink);
        parser.parse();
        sink.flush();
        return dsg;
    }

    public static Graph loadGraph(String filename) {
        return RiotLoader.loadGraph(filename, null);
    }

    public static Graph loadGraph(String filename, Lang lang) {
        return RiotLoader.loadGraph(filename, lang, null);
    }

    public static Graph loadGraph(String filename, Lang lang, String baseURI) {
        if (lang == null) {
            lang = Lang.guess(filename, Lang.NTRIPLES);
        }
        Graph g = Factory.createDefaultGraph();
        RiotLoader.read(filename, g, lang, baseURI);
        return g;
    }

    public static Graph graphFromString(String string, Lang language, String baseURI) {
        Graph g = Factory.createDefaultGraph();
        Sink<Triple> sink = RiotLoader.graphSink(g);
        Tokenizer tokenizer = TokenizerFactory.makeTokenizerString(string);
        LangRIOT parser = RiotReader.createParserTriples(tokenizer, language, baseURI, sink);
        parser.parse();
        sink.flush();
        return g;
    }

    public static void read(String filename, DatasetGraph dataset) {
        Lang lang = Lang.guess(filename);
        if (lang == null) {
            throw new RiotException("Can't guess language for " + filename);
        }
        String baseURI = IRILib.filenameToIRI(filename);
        InputStream input = IO.openFile(filename);
        RiotLoader.read(input, dataset, lang, baseURI);
    }

    public static void read(String filename, DatasetGraph dataset, Lang lang) {
        RiotLoader.read(filename, dataset, lang, null);
    }

    public static void read(String filename, DatasetGraph dataset, Lang lang, String baseURI) {
        baseURI = RiotLoader.chooseBaseIRI(baseURI, filename);
        InputStream input = IO.openFile(filename);
        RiotLoader.read(input, dataset, lang, baseURI);
    }

    public static void read(InputStream input, DatasetGraph dataset, Lang language, String baseURI) {
        if (language.isQuads()) {
            Sink<Quad> sink = RiotLoader.datasetSink(dataset);
            RiotLoader.readQuads(input, language, baseURI, sink);
        } else {
            Sink<Triple> sink = RiotLoader.graphSink(dataset.getDefaultGraph());
            RiotLoader.readTriples(input, language, baseURI, sink);
        }
    }

    public static void read(String filename, Graph graph) {
        RiotLoader.read(filename, graph, null);
    }

    public static void read(String filename, Graph graph, Lang lang) {
        RiotLoader.read(filename, graph, lang, null);
    }

    public static void read(String filename, Graph graph, Lang lang, String baseURI) {
        if (lang == null) {
            lang = Lang.guess(filename, Lang.NTRIPLES);
        }
        baseURI = RiotLoader.chooseBaseIRI(baseURI, filename);
        InputStream input = IO.openFile(filename);
        RiotLoader.read(input, graph, lang, baseURI);
    }

    public static void read(InputStream input, Graph graph, Lang lang, String baseURI) {
        Sink<Triple> sink = RiotLoader.graphSink(graph);
        RiotLoader.readTriples(input, lang, baseURI, sink);
    }

    public static void readQuads(InputStream input, Lang language, String baseURI, Sink<Quad> sink) {
        if (!language.isQuads()) {
            throw new RiotException("Language not supported for quads: " + (Object)((Object)language));
        }
        LangRIOT parser = RiotReader.createParserQuads(input, language, baseURI, sink);
        parser.parse();
        sink.flush();
    }

    public static void readTriples(InputStream input, Lang language, String baseURI, Sink<Triple> sink) {
        if (!language.isTriples()) {
            throw new RiotException("Language not supported for triples: " + (Object)((Object)language));
        }
        LangRIOT parser = RiotReader.createParserTriples(input, language, baseURI, sink);
        parser.parse();
        sink.flush();
    }

    public static Sink<Triple> graphSink(Graph graph) {
        return new SinkTriplesToGraph(graph);
    }

    public static Sink<Quad> datasetSink(DatasetGraph dataset) {
        return new SinkQuadsToDataset(dataset);
    }

    private static String chooseBaseIRI(String baseURI, String filename) {
        return RiotReader.chooseBaseIRI(baseURI, filename);
    }
}

