/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query;

import com.hp.hpl.jena.Jena;
import com.hp.hpl.jena.assembler.assemblers.AssemblerGroup;
import com.hp.hpl.jena.sparql.ARQConstants;
import com.hp.hpl.jena.sparql.SystemARQ;
import com.hp.hpl.jena.sparql.core.assembler.AssemblerUtils;
import com.hp.hpl.jena.sparql.engine.main.StageBuilder;
import com.hp.hpl.jena.sparql.expr.nodevalue.XSDFuncOp;
import com.hp.hpl.jena.sparql.lib.Metadata;
import com.hp.hpl.jena.sparql.mgt.ARQMgt;
import com.hp.hpl.jena.sparql.mgt.Explain;
import com.hp.hpl.jena.sparql.mgt.SystemInfo;
import com.hp.hpl.jena.sparql.util.Context;
import com.hp.hpl.jena.sparql.util.Symbol;
import org.openjena.riot.RIOT;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ARQ {
    public static final String logExecName = "com.hp.hpl.jena.arq.exec";
    public static final String logInfoName = "com.hp.hpl.jena.arq.info";
    public static final String logHttpRequestName = "com.hp.hpl.jena.arq.service";
    private static final Logger logExec = LoggerFactory.getLogger((String)"com.hp.hpl.jena.arq.exec");
    private static final Logger logInfo = LoggerFactory.getLogger((String)"com.hp.hpl.jena.arq.info");
    private static final Logger logHttpRequest = LoggerFactory.getLogger((String)"com.hp.hpl.jena.arq.service");
    public static final Symbol symLogExec = ARQConstants.allocSymbol("logExec");
    public static final String arqIRI = "http://jena.hpl.hp.com/#arq";
    public static final String arqNS = "http://jena.hpl.hp.com/ARQ#";
    public static final String arqSymbolPrefix = "arq";
    public static final Symbol strictSPARQL = ARQConstants.allocSymbol("strictSPARQL");
    public static final Symbol constantBNodeLabels = ARQConstants.allocSymbol("constantBNodeLabels");
    public static final Symbol enablePropertyFunctions = ARQConstants.allocSymbol("enablePropertyFunctions");
    public static final Symbol enableExecutionTimeLogging = ARQConstants.allocSymbol("enableExecutionTimeLogging");
    public static final Symbol outputGraphBNodeLabels = ARQConstants.allocSymbol("outputGraphBNodeLabels");
    public static final Symbol inputGraphBNodeLabels = ARQConstants.allocSymbol("inputGraphBNodeLabels");
    public static final Symbol enableRomanNumerals = ARQConstants.allocSymbol("romanNumerals");
    public static final Symbol stageGenerator = ARQConstants.allocSymbol("stageGenerator");
    public static final Symbol hideNonDistiguishedVariables = ARQConstants.allocSymbol("hideNonDistiguishedVariables");
    public static final Symbol useSAX = ARQConstants.allocSymbol("useSAX");
    public static final boolean allowDuplicateSelectColumns = false;
    public static final Symbol regexImpl = ARQConstants.allocSymbol("regexImpl");
    public static final Symbol javaRegex = ARQConstants.allocSymbol("javaRegex");
    public static final Symbol xercesRegex = ARQConstants.allocSymbol("xercesRegex");
    public static final Symbol optimization = ARQConstants.allocSymbol("optimization");
    public static final Symbol optFilterPlacement;
    @Deprecated
    public static final Symbol filterPlacement;
    public static final Symbol optFilterEquality;
    public static final Symbol optTermStrings;
    public static final Symbol optFilterConjunction;
    public static final Symbol optFilterExpandOneOf;
    public static final Symbol optFilterDisjunction;
    public static final Symbol propertyFunctions;
    public static final Symbol strictGraph;
    public static final Symbol extensionValueTypes;
    public static final Symbol generateToList;
    public static final String PATH = "com.hp.hpl.jena.sparql";
    private static String metadataLocation;
    private static Metadata metadata;
    public static final String NAME = "ARQ";
    public static final String VERSION;
    public static final String BUILD_DATE;
    private static boolean initialized;
    private static Context globalContext;

    public static Logger getExecLogger() {
        return logExec;
    }

    public static Logger getInfoLogger() {
        return logInfo;
    }

    public static Logger getHttpRequestLogger() {
        return logHttpRequest;
    }

    public static Explain.InfoLevel getExecutionLogging() {
        return (Explain.InfoLevel)((Object)ARQ.getContext().get(symLogExec));
    }

    public static void setExecutionLogging(Explain.InfoLevel infoLevel) {
        if (Explain.InfoLevel.NONE.equals((Object)infoLevel)) {
            ARQ.getContext().unset(symLogExec);
            return;
        }
        ARQ.getContext().set(symLogExec, (Object)infoLevel);
        if (!ARQ.getExecLogger().isInfoEnabled()) {
            ARQ.getExecLogger().warn("Attempt to enable execution logging but the logger 'com.hp.hpl.jena.arq.exec' is not logging at level INFO");
        }
    }

    public static void enableBlankNodeResultLabels() {
        ARQ.enableBlankNodeResultLabels(true);
    }

    public static void enableBlankNodeResultLabels(boolean val) {
        Boolean b = val;
        globalContext.set(inputGraphBNodeLabels, b);
        globalContext.set(outputGraphBNodeLabels, b);
    }

    public static void enableOptimizer(boolean state) {
        ARQ.enableOptimizer(ARQ.getContext(), state);
    }

    public static void enableOptimizer(Context context, boolean state) {
        context.set(optimization, state);
    }

    public static void setStrictMode() {
        ARQ.setStrictMode(ARQ.getContext());
    }

    public static void setStrictMode(Context context) {
        XSDFuncOp.strictDateTimeFO = true;
        context.set(optimization, false);
        context.set(hideNonDistiguishedVariables, true);
        context.set(strictGraph, true);
        context.set(strictSPARQL, true);
        context.set(extensionValueTypes, false);
        context.set(constantBNodeLabels, false);
        context.set(enablePropertyFunctions, false);
        context.set(generateToList, true);
        context.set(regexImpl, xercesRegex);
    }

    public static boolean isStrictMode() {
        return ARQ.getContext().isTrue(strictSPARQL);
    }

    public static void setNormalMode() {
        ARQ.setNormalMode(ARQ.getContext());
    }

    public static void setNormalMode(Context context) {
        XSDFuncOp.strictDateTimeFO = false;
        context.unset(optimization);
        context.set(strictSPARQL, "false");
        context.set(constantBNodeLabels, "true");
        context.set(enablePropertyFunctions, "true");
        context.set(strictGraph, "false");
        context.set(enableRomanNumerals, "false");
        context.set(regexImpl, javaRegex);
    }

    public static synchronized void init() {
        if (initialized) {
            return;
        }
        initialized = true;
        globalContext = ARQ.defaultSettings();
        StageBuilder.init();
        ARQMgt.init();
        String NS = PATH;
        SystemInfo sysInfo = new SystemInfo(arqIRI, VERSION, BUILD_DATE);
        ARQMgt.register(NS + ".system:type=SystemInfo", sysInfo);
        SystemARQ.registerSubSystem(sysInfo);
        SystemInfo sysInfo2 = new SystemInfo("http://openjena.org/#jena", Jena.VERSION, Jena.BUILD_DATE);
        ARQMgt.register(NS + ".system:type=SystemInfo", sysInfo2);
        SystemARQ.registerSubSystem(sysInfo2);
        RIOT.init();
    }

    public static void whenRequiredByAssembler(AssemblerGroup g) {
        AssemblerUtils.register(g);
    }

    private static Context defaultSettings() {
        Context context = new Context();
        ARQ.setNormalMode(context);
        return context;
    }

    public static Context getContext() {
        return globalContext;
    }

    public static void set(Symbol symbol, boolean value) {
        ARQ.getContext().set(symbol, value);
    }

    public static void setTrue(Symbol symbol) {
        ARQ.getContext().setTrue(symbol);
    }

    public static void setFalse(Symbol symbol) {
        ARQ.getContext().setFalse(symbol);
    }

    public static void unset(Symbol symbol) {
        ARQ.getContext().unset(symbol);
    }

    public static boolean isTrue(Symbol symbol) {
        return ARQ.getContext().isTrue(symbol);
    }

    public static boolean isFalse(Symbol symbol) {
        return ARQ.getContext().isFalse(symbol);
    }

    public static boolean isTrueOrUndef(Symbol symbol) {
        return ARQ.getContext().isTrueOrUndef(symbol);
    }

    public static boolean isFalseOrUndef(Symbol symbol) {
        return ARQ.getContext().isFalseOrUndef(symbol);
    }

    static {
        filterPlacement = optFilterPlacement = ARQConstants.allocSymbol("optFilterPlacement");
        optFilterEquality = ARQConstants.allocSymbol("optFilterEquality");
        optTermStrings = ARQConstants.allocSymbol("optTermStrings");
        optFilterConjunction = ARQConstants.allocSymbol("optFilterConjunction");
        optFilterExpandOneOf = ARQConstants.allocSymbol("optFilterExpandOneOf");
        optFilterDisjunction = ARQConstants.allocSymbol("optFilterDisjunction");
        propertyFunctions = ARQConstants.allocSymbol("propertyFunctions");
        strictGraph = ARQConstants.allocSymbol("strictGraph");
        extensionValueTypes = ARQConstants.allocSymbol("extensionValueTypesExpr");
        generateToList = ARQConstants.allocSymbol("generateToList");
        metadataLocation = "com/hp/hpl/jena/sparql/arq-properties.xml";
        metadata = new Metadata(metadataLocation);
        VERSION = metadata.get("com.hp.hpl.jena.sparql.version", "unknown");
        BUILD_DATE = metadata.get("com.hp.hpl.jena.sparql.build.datetime", "unset");
        initialized = false;
        globalContext = null;
        ARQ.init();
    }
}

