/*
 * Decompiled with CFR 0.152.
 */
package com.herbocailleau.sgq.web.actions.user;

import com.herbocailleau.sgq.business.services.BatchService;
import com.herbocailleau.sgq.entities.Presentation;
import com.herbocailleau.sgq.web.SgqActionSupport;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import org.apache.commons.lang3.StringUtils;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.Result;

public class BatchPresentationEditAction
extends SgqActionSupport {
    private static final long serialVersionUID = 3074255662512738956L;
    protected DateFormat df = new SimpleDateFormat("dd/MM/yyyy");
    protected String presentationId;
    protected Presentation presentation;
    protected String dmesd;

    public void setPresentationId(String presentationId) {
        this.presentationId = presentationId;
    }

    public void setDmesd(String dmesd) {
        this.dmesd = dmesd;
    }

    public String input() throws Exception {
        this.loadData();
        return super.input();
    }

    protected void loadData() {
        BatchService batchService = (BatchService)this.newService(BatchService.class);
        this.presentation = batchService.getPresentationById(this.presentationId);
    }

    public void validate() {
        if (StringUtils.isNotBlank((CharSequence)this.dmesd)) {
            try {
                this.df.parse(this.dmesd);
            }
            catch (ParseException ex) {
                this.addActionError("Format de date invalide (dd/MM/yyyy)");
            }
        }
        if (this.hasErrors()) {
            this.loadData();
        }
    }

    @Action(results={@Result(type="redirectAction", params={"actionName", "batch-view", "batchId", "${presentation.batch.topiaId}"})})
    public String execute() throws Exception {
        BatchService batchService = (BatchService)this.newService(BatchService.class);
        this.presentation = batchService.getPresentationById(this.presentationId);
        if (StringUtils.isNotBlank((CharSequence)this.dmesd)) {
            this.presentation.setDmesd(this.df.parse(this.dmesd));
        } else {
            this.presentation.setDmesd(null);
        }
        batchService.updatePresentation(this.presentation);
        return "success";
    }

    public Presentation getPresentation() {
        return this.presentation;
    }
}

