/*
 * #%L
 * SGQ :: Web
 * $Id: LabelHistoryAction.java 376 2013-05-28 09:27:56Z echatellier $
 * $HeadURL: http://svn.forge.codelutin.com/svn/sgq-ch/tags/sgq-ch-1.1/sgq-web/src/main/java/com/herbocailleau/sgq/web/actions/user/LabelHistoryAction.java $
 * %%
 * Copyright (C) 2012, 2013 Herboristerie Cailleau
 * %%
 * Herboristerie Cailleau - Tous droits réservés
 * #L%
 */

package com.herbocailleau.sgq.web.actions.user;

import java.io.InputStream;
import java.util.Date;
import java.util.List;

import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.Result;
import org.nuiton.util.PagerBean;

import com.herbocailleau.sgq.business.SgqUtils;
import com.herbocailleau.sgq.business.services.ProductionService;
import com.herbocailleau.sgq.entities.LabelError;
import com.herbocailleau.sgq.web.SgqActionSupport;
import com.opensymphony.xwork2.Preparable;

/**
 * Action d'affichage des historiques de corrections.
 * 
 * @author echatellier
 */
public class LabelHistoryAction extends SgqActionSupport implements Preparable {

    /** serialVersionUID. */
    private static final long serialVersionUID = 3074255662512738956L;

    private static final Log log = LogFactory.getLog(LabelHistoryAction.class);

    protected List<LabelError> labelErrors;

    protected Date beginDate;

    protected Date endDate;

    protected int page;

    protected PagerBean pager;

    @Override
    public void prepare() throws Exception {
        // dates
        String dateBegin = getParameter("beginDate");
        if (StringUtils.isNotBlank(dateBegin)) {
            beginDate = SgqUtils.parseSgqDate(dateBegin);
        }
        // dates
        String dateEnd = getParameter("endDate");
        if (StringUtils.isNotBlank(dateEnd)) {
            endDate = SgqUtils.parseSgqDate(dateEnd);
        }
    }

    public Date getBeginDate() {
        return beginDate;
    }

    public Date getEndDate() {
        return endDate;
    }

    public void setPage(int page) {
        this.page = page;
    }

    
    public String execute() throws Exception {
        ProductionService productionService = newService(ProductionService.class);
        Pair<List<LabelError>, Long> searchResult = productionService.getHistory(beginDate,
                endDate, page * ITEM_PER_PAGE, ITEM_PER_PAGE);
        labelErrors = searchResult.getKey();
        long totalCount = searchResult.getValue();
        pager = getPager(page, ITEM_PER_PAGE, totalCount);
        return SUCCESS;
    }

    public List<LabelError> getLabelErrors() {
        return labelErrors;
    }

    public PagerBean getPager() {
        return pager;
    }
    
    @Action(value="label-history-export", results= {@Result(type="stream", params={"contentType", "text/csv", "inputName", "inputStream", "contentDisposition", "attachment; filename=\"historique.csv\""})})
    public String export() throws Exception {
        return SUCCESS;
    }

    public InputStream getInputStream() {
        ProductionService productionService = newService(ProductionService.class);
        InputStream result = null;
        try {
            result = productionService.getHistoryAsCsv(beginDate, endDate);
        } catch (Exception ex) {
            if (log.isErrorEnabled()) {
                log.error("Can't get csv stream", ex);
            }
        }
        return result;
    }
}
