/*
 * #%L
 * SGQ :: Web
 * $Id: BatchReceiveViewAction.java 322 2013-04-17 16:10:16Z echatellier $
 * $HeadURL: http://svn.forge.codelutin.com/svn/sgq-ch/tags/sgq-ch-1.1/sgq-web/src/main/java/com/herbocailleau/sgq/web/actions/user/BatchReceiveViewAction.java $
 * %%
 * Copyright (C) 2012 Herboristerie Cailleau
 * %%
 * Herboristerie Cailleau - Tous droits réservés
 * #L%
 */

package com.herbocailleau.sgq.web.actions.user;

import java.io.File;
import java.util.List;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts2.convention.annotation.Action;

import com.herbocailleau.sgq.business.model.ImportLog;
import com.herbocailleau.sgq.business.services.BatchService;
import com.herbocailleau.sgq.business.services.ConfigurationService;
import com.herbocailleau.sgq.entities.Batch;
import com.herbocailleau.sgq.web.SgqActionSupport;

/**
 * Action d'import de reception des lots.
 * 
 * @author echatellier
 */
public class BatchReceiveViewAction extends SgqActionSupport {

    /** serialVersionUID. */
    private static final long serialVersionUID = 3074255662512738956L;

    private static final Log log = LogFactory.getLog(BatchReceiveViewAction.class);

    protected long batchsCount;

    protected int nextNonBioBatchNumber;

    protected int nextBioBatchNumber;

    protected File file;

    protected List<ImportLog<Batch>> importLogs;

    @Override
    public String execute() throws Exception {

        ConfigurationService configurationService = newService(ConfigurationService.class);
        nextNonBioBatchNumber = configurationService.getNextNonBioBatchNumber();
        nextBioBatchNumber = configurationService.getNextBioBatchNumber();
        return SUCCESS;
    }

    public long getBatchsCount() {
        return batchsCount;
    }

    public int getNextNonBioBatchNumber() {
        return nextNonBioBatchNumber;
    }

    public int getNextBioBatchNumber() {
        return nextBioBatchNumber;
    }

    public void setFile(File file) {
        this.file = file;
    }

    @Action("batch-receive-import")
    public String importBatch() throws Exception {
        String result = SUCCESS;
        if (file == null) {
            result = input();
        } else {
            BatchService batchService = newService(BatchService.class);
            try {
                importLogs = batchService.importBatchFile(file);
            } catch (Exception ex) {
                if (log.isErrorEnabled()) {
                    log.error("Can't import batch file", ex);
                }
                addActionError(ex.getMessage());
                result = input();
            }
        }

        return result;
    }
    
    public List<ImportLog<Batch>> getImportLogs() {
        return importLogs;
    }
}
