/*
 * #%L
 * SGQ :: Web
 * $Id: AnalyzeTypeEditAction.java 292 2013-03-25 11:35:42Z echatellier $
 * $HeadURL: http://svn.forge.codelutin.com/svn/sgq-ch/tags/sgq-ch-1.1/sgq-web/src/main/java/com/herbocailleau/sgq/web/actions/admin/AnalyzeTypeEditAction.java $
 * %%
 * Copyright (C) 2012 Herboristerie Cailleau
 * %%
 * Herboristerie Cailleau - Tous droits réservés
 * #L%
 */

package com.herbocailleau.sgq.web.actions.admin;

import java.util.List;

import org.apache.commons.lang3.StringUtils;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.Result;

import com.herbocailleau.sgq.business.services.ReferentialService;
import com.herbocailleau.sgq.entities.AnalyzeCategory;
import com.herbocailleau.sgq.entities.AnalyzeType;
import com.herbocailleau.sgq.entities.AnalyzeTypeImpl;
import com.herbocailleau.sgq.web.SgqActionSupport;
import com.opensymphony.xwork2.Preparable;

public class AnalyzeTypeEditAction extends SgqActionSupport implements Preparable {

    /** serialVersionUID. */
    private static final long serialVersionUID = 6915148559808770928L;

    protected ReferentialService referentialService;

    protected List<AnalyzeCategory> analyzeCategories;

    protected AnalyzeType analyzeType;

    protected String analyzeCategoryId;

    @Override
    public void prepare() throws Exception {
        referentialService = newService(ReferentialService.class);
    }

    @Override
    public String input() throws Exception {
        analyzeCategories = referentialService.findAllAnalyzeCategories();
        return super.input();
    }

    public List<AnalyzeCategory> getAnalyzeCategories() {
        return analyzeCategories;
    }

    public void setAnalyzeCategoryId(String analyzeCategoryId) {
        this.analyzeCategoryId = analyzeCategoryId;
    }

    @Override
    @Action(results={@Result(type="redirectAction", params = {"actionName" , "analyze-type-list"})})
    public String execute() throws Exception {

        AnalyzeCategory analyzeCategory = referentialService.findAnalyzeCategoryById(analyzeCategoryId);
        analyzeType.setAnalyzeCategory(analyzeCategory);
        referentialService.saveAnalyzeType(analyzeType);

        return super.execute();
    }
    
    public AnalyzeType getAnalyzeType() {
        if (analyzeType == null) {
            String analyzeId = getParameter("analyzeTypeId");
            if (StringUtils.isNotBlank(analyzeId)) {
                analyzeType = referentialService.findAnalyzeTypeById(analyzeId);
            } else {
                analyzeType = new AnalyzeTypeImpl();
                analyzeType.setDurationDays(30); // default value
            }
        }
        return analyzeType;
    }
    
    @Action(value="analyze-type-delete", results={@Result(type="redirectAction", params = {"actionName" , "analyze-type-list"})})
    public String deleteAnalyzeType() throws Exception {
        referentialService.deleteAnalyzeType(getAnalyzeType());
        return SUCCESS;
    }
}
