/*
 * Decompiled with CFR 0.152.
 */
package com.herbocailleau.sgq.web.actions.admin;

import com.herbocailleau.sgq.business.model.ImportLog;
import com.herbocailleau.sgq.business.services.ReferentialService;
import com.herbocailleau.sgq.entities.Supplier;
import com.herbocailleau.sgq.web.SgqActionSupport;
import java.io.File;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SupplierImportAction
extends SgqActionSupport {
    private static final long serialVersionUID = -9055424589556770343L;
    private static final Log log = LogFactory.getLog(SupplierImportAction.class);
    protected File file;
    protected List<ImportLog<Supplier>> importLogs;

    public void setFile(File file) {
        this.file = file;
    }

    public String execute() throws Exception {
        String result = "success";
        try {
            ReferentialService referentialService = (ReferentialService)this.newService(ReferentialService.class);
            this.importLogs = referentialService.importSuppliers(this.file);
        }
        catch (Exception ex) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Can't import supplier file", (Throwable)ex);
            }
            this.addActionError(ex.getMessage());
            result = this.input();
        }
        return result;
    }

    public List<ImportLog<Supplier>> getImportLogs() {
        return this.importLogs;
    }
}

