/*
 * #%L
 * SGQ :: Web
 * $Id: BatchAnalyzeUploadAction.java 453 2014-04-14 12:30:27Z echatellier $
 * $HeadURL: https://svn.codelutin.com/sgq-ch/tags/sgq-ch-1.1.5/sgq-web/src/main/java/com/herbocailleau/sgq/web/actions/user/BatchAnalyzeUploadAction.java $
 * %%
 * Copyright (C) 2012 Herboristerie Cailleau
 * %%
 * Herboristerie Cailleau - Tous droits réservés
 * #L%
 */

package com.herbocailleau.sgq.web.actions.user;

import java.io.File;
import java.util.List;

import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.Result;

import com.herbocailleau.sgq.business.services.BatchService;
import com.herbocailleau.sgq.entities.Batch;
import com.herbocailleau.sgq.web.SgqActionSupport;

/**
 * Action d'upload d'un fichier d'analyse sur un lot.
 * 
 * @author echatellier
 */
public class BatchAnalyzeUploadAction extends SgqActionSupport {

    /** serialVersionUID. */
    private static final long serialVersionUID = 307425532542738956L;

    protected String batchId;

    protected List<File> files;

    protected List<String> filesFileName;

    public void setBatchId(String batchId) {
        this.batchId = batchId;
    }

    public void setFiles(List<File> files) {
        this.files = files;
    }

    public void setFilesFileName(List<String> filesFileName) {
        this.filesFileName = filesFileName;
    }

    @Override
    @Action(results={@Result(type="redirectAction", params = {"actionName", "batch-view", "batchId", "${batchId}"})})
    public String execute() throws Exception {

        BatchService batchService = newService(BatchService.class);
        Batch batch = batchService.getBatchById(batchId);
        for (int i = 0 ; i < files.size() ; i++) {
            File file = files.get(i);
            String fileName = filesFileName.get(i);
            batchService.addAnalyzeFile(batch, null, fileName, file);
        }

        return SUCCESS;
    }
    
    public String getBatchId() {
        return batchId;
    }
}
