/*
 * Decompiled with CFR 0.152.
 */
package com.herbocailleau.sgq.web.actions.admin;

import com.herbocailleau.sgq.business.SgqBusinessException;
import com.herbocailleau.sgq.business.services.ReferentialService;
import com.herbocailleau.sgq.entities.AnalyzeType;
import com.herbocailleau.sgq.entities.Product;
import com.herbocailleau.sgq.entities.ProductImpl;
import com.herbocailleau.sgq.entities.ProductStatus;
import com.herbocailleau.sgq.web.SgqActionSupport;
import com.opensymphony.xwork2.Preparable;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.Result;

public class ProductEditAction
extends SgqActionSupport
implements Preparable {
    private static final long serialVersionUID = 5564446302091087009L;
    private static final Log log = LogFactory.getLog(ProductEditAction.class);
    protected ReferentialService referentialService;
    protected String productId;
    protected Product product;
    protected List<String> categories;
    protected List<ProductStatus> status;
    protected List<AnalyzeType> analyzeTypes;
    protected List<String> productStatusIds;
    protected String productStatusName;
    protected String productCategoryName;
    protected List<String> analyzeTypeIds;
    protected boolean canBeDeleted;
    protected boolean canBeArchived;

    public void setProductId(String productId) {
        this.productId = productId;
    }

    public void prepare() throws Exception {
        this.referentialService = (ReferentialService)this.newService(ReferentialService.class);
        this.status = this.referentialService.findAllProductStatus();
        this.analyzeTypes = this.referentialService.findAllAnalyzeTypes();
        this.categories = this.referentialService.findAllProductCategories();
    }

    public List<String> getCategories() {
        return this.categories;
    }

    public List<ProductStatus> getStatus() {
        return this.status;
    }

    public List<AnalyzeType> getAnalyzeTypes() {
        return this.analyzeTypes;
    }

    public void setProductStatusIds(List<String> productStatusIds) {
        this.productStatusIds = productStatusIds;
    }

    public String getProductCategoryName() {
        return this.productCategoryName;
    }

    public void setProductCategoryName(String productCategoryName) {
        this.productCategoryName = productCategoryName;
    }

    public String getProductStatusName() {
        return this.productStatusName;
    }

    public void setProductStatusName(String productStatusName) {
        this.productStatusName = productStatusName;
    }

    public void setAnalyzeTypeIds(List<String> analyzeTypeIds) {
        this.analyzeTypeIds = analyzeTypeIds;
    }

    @Action(results={@Result(type="redirectAction", params={"actionName", "product-list"})})
    public String execute() throws Exception {
        this.product.clearProductStatus();
        for (String productStatusId : this.productStatusIds) {
            this.product.addProductStatus(this.referentialService.getProductStatusById(productStatusId));
        }
        this.product.clearAnalyzeType();
        for (String analyzeTypeId : this.analyzeTypeIds) {
            this.product.addAnalyzeType(this.referentialService.findAnalyzeTypeById(analyzeTypeId));
        }
        if (StringUtils.isNotBlank((CharSequence)this.productCategoryName)) {
            this.product.setCategory(this.productCategoryName);
        }
        String result = "success";
        try {
            this.referentialService.saveProduct(this.product, this.productStatusName);
        }
        catch (SgqBusinessException ex) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Can't create product", (Throwable)ex);
            }
            this.addActionError(ex.getMessage());
            result = this.input();
        }
        return result;
    }

    public Product getProduct() {
        if (this.product == null) {
            String productId = this.getParameter("productId");
            if (StringUtils.isNotBlank((CharSequence)productId)) {
                this.product = this.referentialService.getProductById(productId);
                this.canBeDeleted = this.referentialService.canBeDeleteProduct(this.product);
                this.canBeArchived = this.referentialService.canBeArchivedProduct(this.product);
            } else {
                this.product = new ProductImpl();
            }
        }
        return this.product;
    }

    public boolean isCanBeDeleted() {
        return this.canBeDeleted;
    }

    public boolean isCanBeArchived() {
        return this.canBeArchived;
    }

    @Action(value="product-delete", results={@Result(type="redirectAction", params={"actionName", "product-list"})})
    public String deleteProduct() {
        this.referentialService.deleteProduct(this.getProduct());
        return "success";
    }

    @Action(value="product-archive", results={@Result(type="redirectAction", params={"actionName", "product-list"})})
    public String archiveProduct() {
        this.referentialService.archiveProduct(this.getProduct());
        return "success";
    }

    @Action(value="product-unarchive", results={@Result(type="redirectAction", params={"actionName", "product-list"})})
    public String unArchiveProduct() {
        this.referentialService.unArchiveProduct(this.getProduct());
        return "success";
    }
}

