/*
 * #%L
 * SGQ :: Web
 * $Id: LabelErrorAction.java 330 2013-04-19 16:48:49Z echatellier $
 * $HeadURL: http://svn.forge.codelutin.com/svn/sgq-ch/tags/sgq-ch-1.1.2/sgq-web/src/main/java/com/herbocailleau/sgq/web/actions/user/LabelErrorAction.java $
 * %%
 * Copyright (C) 2012 Herboristerie Cailleau
 * %%
 * Herboristerie Cailleau - Tous droits réservés
 * #L%
 */

package com.herbocailleau.sgq.web.actions.user;

import java.util.List;

import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.Result;

import com.herbocailleau.sgq.business.model.ImportLog;
import com.herbocailleau.sgq.business.services.ProductionService;
import com.herbocailleau.sgq.entities.LabelError;
import com.herbocailleau.sgq.entities.Zone;
import com.herbocailleau.sgq.web.SgqActionSupport;

/**
 * Action de traitement des erreurs passé des imports de fichiers étiquettes.
 * 
 * @author echatellier
 */
public class LabelErrorAction extends SgqActionSupport {

    /** serialVersionUID. */
    private static final long serialVersionUID = 3074255662512738956L;

    private static final Log log = LogFactory.getLog(LabelErrorAction.class);

    protected List<LabelError> productionErrors;

    protected List<LabelError> expeditionErrors;

    protected String labelErrorId;

    protected String replayLine;

    protected String comment;

    protected boolean editAction;

    protected boolean deleteAction;

    public List<LabelError> getProductionErrors() {
        return productionErrors;
    }

    public List<LabelError> getExpeditionErrors() {
        return expeditionErrors;
    }

    public void setLabelErrorId(String labelErrorId) {
        this.labelErrorId = labelErrorId;
    }

    public void setReplayLine(String replayLine) {
        this.replayLine = replayLine;
    }

    public void setEditAction(boolean editAction) {
        this.editAction = editAction;
    }

    public void setDeleteAction(boolean deleteAction) {
        this.deleteAction = deleteAction;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public String input() throws Exception {
        ProductionService productionService = newService(ProductionService.class);
        productionErrors = productionService.getLabelErrorsForZone(Zone.ZE);
        expeditionErrors = productionService.getLabelErrorsForZone(Zone.ZP);

        return super.input();
    }

    @Action(results={@Result(type="redirectAction", params = {"actionName" , "label-error"})})
    public String execute() throws Exception {
        String result = SUCCESS;
        if (editAction || deleteAction) {
            if (StringUtils.isBlank(comment)) {
                addActionError("Le commentaire est obligatoire");
                result = input();
            } else {
                ProductionService productionService = newService(ProductionService.class);
                try {
                    if (editAction) {
                        ImportLog importLog = productionService.replayError(labelErrorId, replayLine, comment);
                        if (importLog.isError()) {
                            addActionError(importLog.getMessage());
                            result = input();
                        }
                    } else {
                        // delete
                        productionService.deleteError(labelErrorId, comment);
                    }
                } catch (Exception ex) {
                    if (log.isErrorEnabled()) {
                        log.error("Can't edit or delete line", ex);
                    }
                    addActionError(ex.getMessage());
                    result = input();
                }
            }
        } else {
            result = input();
        }

        return result;
    }
}
