/*
 * Decompiled with CFR 0.152.
 */
package com.herbocailleau.sgq.web.actions.user;

import com.herbocailleau.sgq.business.model.ImportLog;
import com.herbocailleau.sgq.business.services.BatchService;
import com.herbocailleau.sgq.entities.Batch;
import com.herbocailleau.sgq.web.SgqActionSupport;
import java.io.File;
import java.io.InputStream;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.Result;

public class InventoryViewAction
extends SgqActionSupport {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(InventoryViewAction.class);
    protected File file;
    protected List<ImportLog<Batch>> importLogs;
    protected long importedLines;

    public void setFile(File file) {
        this.file = file;
    }

    public String execute() throws Exception {
        return "success";
    }

    @Action(value="inventory-export", results={@Result(type="stream", params={"contentType", "text/csv", "inputName", "inputStream", "contentDisposition", "attachment; filename=\"${filename}\""})})
    public String inventoryExport() throws Exception {
        return "success";
    }

    public InputStream getInputStream() {
        InputStream result;
        block2: {
            BatchService batchService = (BatchService)this.newService(BatchService.class);
            result = null;
            try {
                result = batchService.exportInventory();
            }
            catch (Exception ex) {
                if (!log.isErrorEnabled()) break block2;
                log.error((Object)"Can't get csv stream", (Throwable)ex);
            }
        }
        return result;
    }

    public String getFilename() {
        return "inventaire.csv";
    }

    @Action(value="inventory-import")
    public String inventoryImport() throws Exception {
        String result = "success";
        if (this.file == null) {
            result = this.input();
        } else {
            try {
                BatchService batchService = (BatchService)this.newService(BatchService.class);
                this.importLogs = batchService.importInventory(this.file);
                this.importedLines = 0L;
                for (ImportLog importLog : this.importLogs) {
                    ++this.importedLines;
                }
            }
            catch (Exception ex) {
                if (log.isErrorEnabled()) {
                    log.error((Object)"Can't import inventory", (Throwable)ex);
                }
                this.addActionError(ex.getMessage());
                result = this.input();
            }
        }
        return result;
    }

    public long getImportedLines() {
        return this.importedLines;
    }

    public List<ImportLog<Batch>> getImportLogs() {
        return this.importLogs;
    }
}

