/*
 * Decompiled with CFR 0.152.
 */
package com.herbocailleau.sgq.web.actions.admin;

import com.herbocailleau.sgq.business.services.ReferentialService;
import com.herbocailleau.sgq.entities.AnalyzeType;
import com.herbocailleau.sgq.entities.Product;
import com.herbocailleau.sgq.entities.ProductImpl;
import com.herbocailleau.sgq.entities.ProductStatus;
import com.herbocailleau.sgq.web.SgqActionSupport;
import com.opensymphony.xwork2.Preparable;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.Result;

public class ProductAction
extends SgqActionSupport
implements Preparable {
    private static final long serialVersionUID = 5564446302091087009L;
    protected ReferentialService referentialService;
    protected String productId;
    protected Product product;
    protected List<ProductStatus> status;
    protected List<AnalyzeType> analyzeTypes;
    protected List<String> productStatusIds;
    protected String productStatusName;
    protected List<String> analyzeTypeIds;

    public void setProductId(String productId) {
        this.productId = productId;
    }

    public void prepare() throws Exception {
        this.referentialService = (ReferentialService)this.newService(ReferentialService.class);
        this.status = this.referentialService.findAllProductStatus();
        this.analyzeTypes = this.referentialService.findAllAnalyzeTypes();
    }

    public List<ProductStatus> getStatus() {
        return this.status;
    }

    public List<AnalyzeType> getAnalyzeTypes() {
        return this.analyzeTypes;
    }

    public void setProductStatusIds(List<String> productStatusIds) {
        this.productStatusIds = productStatusIds;
    }

    public void setProductStatusName(String productStatusName) {
        this.productStatusName = productStatusName;
    }

    public void setAnalyzeTypeIds(List<String> analyzeTypeIds) {
        this.analyzeTypeIds = analyzeTypeIds;
    }

    @Action(results={@Result(type="redirectAction", params={"actionName", "products"})})
    public String execute() throws Exception {
        this.product.getProductStatus().clear();
        for (String productStatusId : this.productStatusIds) {
            this.product.addProductStatus(this.referentialService.getProductStatusById(productStatusId));
        }
        this.product.getAnalyzeType().clear();
        for (String analyzeTypeId : this.analyzeTypeIds) {
            this.product.addAnalyzeType(this.referentialService.findAnalyzeTypeById(analyzeTypeId));
        }
        this.referentialService.saveProduct(this.product, this.productStatusName);
        return "success";
    }

    public Product getProduct() {
        if (this.product == null) {
            String productId = this.getParameter("productId");
            this.product = StringUtils.isNotBlank((CharSequence)productId) ? this.referentialService.getProductById(productId) : new ProductImpl();
        }
        return this.product;
    }
}

