/*
 * #%L
 * SGQ :: Web
 * $Id: PlacesAction.java 135 2012-10-05 09:06:51Z echatellier $
 * $HeadURL: http://svn.forge.codelutin.com/svn/sgq-ch/tags/sgq-ch-0.4/sgq-web/src/main/java/com/herbocailleau/sgq/web/actions/user/PlacesAction.java $
 * %%
 * Copyright (C) 2012 Herboristerie Cailleau
 * %%
 * Herboristerie Cailleau - Tous droits réservés
 * #L%
 */

package com.herbocailleau.sgq.web.actions.user;

import java.util.List;
import java.util.Map;

import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.herbocailleau.sgq.business.model.PresentationModel;
import com.herbocailleau.sgq.business.services.BatchService;
import com.herbocailleau.sgq.business.services.ReferentialService;
import com.herbocailleau.sgq.entities.Place;
import com.herbocailleau.sgq.web.SgqActionSupport;

public class PlacesAction extends SgqActionSupport {

    /** serialVersionUID. */
    private static final long serialVersionUID = 1L;

    private static final Log log = LogFactory.getLog(PlacesAction.class);

    protected ReferentialService referentialService;

    protected List<Place> places;

    protected Place place;

    protected String placeId;

    protected String productName;

    protected Map<Place, List<PresentationModel>> batchPresentations;

    public void setPlaceId(String placeId) {
        this.placeId = placeId;
    }

    public String getProductName() {
        return productName;
    }

    public void setProductName(String productName) {
        this.productName = productName;
    }

    @Override
    public String execute() throws Exception {
        referentialService = newService(ReferentialService.class);
        places = referentialService.getPlaces();
        if (placeId != null) {
            place = referentialService.getPlaceById(placeId);
        }
        BatchService batchService = newService(BatchService.class);
        if (place != null || StringUtils.isNotBlank(productName)) {
            batchPresentations = batchService.findAllBatchPerPlacesAndProductName(place, productName);
        }
        return SUCCESS;
    }

    public List<Place> getPlaces() {
        return places;
    }

    public Place getPlace() {
        return place;
    }

    public Map<Place, List<PresentationModel>> getBatchPresentations() {
        return batchPresentations;
    }
}
