/*
 * #%L
 * SGQ :: Web
 * $Id: BatchAnalyzeAction.java 145 2012-10-09 12:44:07Z echatellier $
 * $HeadURL: http://svn.forge.codelutin.com/svn/sgq-ch/tags/sgq-ch-0.4/sgq-web/src/main/java/com/herbocailleau/sgq/web/actions/user/BatchAnalyzeAction.java $
 * %%
 * Copyright (C) 2012 Herboristerie Cailleau
 * %%
 * Herboristerie Cailleau - Tous droits réservés
 * #L%
 */

package com.herbocailleau.sgq.web.actions.user;

import java.util.List;

import com.herbocailleau.sgq.business.services.BatchService;
import com.herbocailleau.sgq.entities.AnalyzeFile;
import com.herbocailleau.sgq.entities.BatchAnalyze;
import com.herbocailleau.sgq.web.SgqActionSupport;

/**
 * Action d'affichage du détail d'une analyse.
 * 
 * @author echatellier
 */
public class BatchAnalyzeAction extends SgqActionSupport {

    /** serialVersionUID. */
    private static final long serialVersionUID = 3074255662512738956L;

    protected String analyzeId;

    protected BatchAnalyze analyze;

    protected List<AnalyzeFile> analyzeFiles;

    public void setAnalyzeId(String analyzeId) {
        this.analyzeId = analyzeId;
    }

    @Override
    public String execute() throws Exception {
        BatchService batchService = newService(BatchService.class);
        analyze = batchService.getAnalyzeById(analyzeId);
        analyzeFiles = batchService.findAllAnalyzeFilesByAnalyze(analyze);
        return SUCCESS;
    }

    public BatchAnalyze getAnalyze() {
        return analyze;
    }

    public List<AnalyzeFile> getAnalyzeFiles() {
        return analyzeFiles;
    }
}
